package com.tomas.ht_mast.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.ClickRowItemNg;
import com.tomas.ht_mast.ListData.LabelItem_qc_list;
import com.tomas.ht_mast.R;

import java.util.List;

public class ItemLabel_qc_Adapter extends RecyclerView.Adapter<ItemLabel_qc_Adapter.ViewHolder> {
        private List<LabelItem_qc_list> data;
        Context context;
        private ClickRowItemNg click_row_item;


        public ItemLabel_qc_Adapter(List<LabelItem_qc_list> dataset, Context context, ClickRowItemNg click_row_item ) {
                data = dataset;
                this.context = context;
                this.click_row_item = click_row_item;
        }

        public class ViewHolder extends RecyclerView.ViewHolder{
                LinearLayout layout;
                TextView txt_no, txt_lot_no, txt_box_no, txt_qty, txt_unit, txt_ng;
                public ViewHolder(View itemview){
                        super(itemview);
                        layout = (LinearLayout) itemview.findViewById(R.id.item_row);
                        txt_no = (TextView)itemView.findViewById(R.id.txt_no);
                        txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
                        txt_box_no = (TextView)itemView.findViewById(R.id.txt_box_no);
                        txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
                        txt_unit = (TextView)itemView.findViewById(R.id.txt_unit);
                        txt_ng = (TextView)itemView.findViewById(R.id.txt_ng);
                }
        }


        @NonNull
        @Override
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
                View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_qc_label,parent,false);
                context = parent.getContext();
                return new ViewHolder(content_view);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
                final LabelItem_qc_list item = data.get(position);
                holder.txt_no.setText(item.getNo());
                holder.txt_lot_no.setText(item.getLot_no());
                holder.txt_box_no.setText(item.getBox_no());
                holder.txt_qty.setText(item.getLabel_qty());
                holder.txt_unit.setText(item.getUnit());
                holder.txt_ng.setText(item.getNg_qty());

                String ng = item.getNg_qty();
                if (ng.trim().equals("0")){
                        holder.layout.setBackgroundResource(R.color.color_button);
                }else{
                        holder.layout.setBackgroundResource(R.color.red);
                }
                holder.layout.setOnClickListener(new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {


                                click_row_item.onClickRow(item.getLabel_id(), item.getLabel_qty(),
                                        item.getBox_no(),item.getNg_qty(), item.getIssue_qty(),
                                        item.getPart_no(),item.getControl_unit(),item.getUnit());
//                                click_row_item.onClickRow("1", "100", "3");
                        }


                });
        }

        @Override
        public int getItemCount() {
                return data.size();
        }
}
