package com.tomas.ht_mast.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.ListData.LabelItem_list_out_man;
import com.tomas.ht_mast.R;

import java.util.List;

public class ItemLabel_Adapter_out_man extends RecyclerView.Adapter<ItemLabel_Adapter_out_man.ViewHolder> {
        private List<LabelItem_list_out_man> data;
        Context context;

        public ItemLabel_Adapter_out_man(List<LabelItem_list_out_man> dataset, Context context) {
                data = dataset;
                this.context = context;
        }

        public class ViewHolder extends RecyclerView.ViewHolder{
                LinearLayout layout;
                TextView txt_no, txt_lot_no, txt_box_no, txt_qty, txt_unit, txt_status;
                public ViewHolder(View itemview){
                        super(itemview);
                        layout = (LinearLayout) itemview.findViewById(R.id.item_row);
                        txt_no = (TextView)itemView.findViewById(R.id.txt_no);
                        txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
                        txt_box_no = (TextView)itemView.findViewById(R.id.txt_box_no);
                        txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
                        txt_unit = (TextView)itemView.findViewById(R.id.txt_unit);
                        txt_status = (TextView)itemView.findViewById(R.id.txt_status);
                }
        }


        @NonNull
        @Override
        public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
                View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_label,parent,false);
                context = parent.getContext();
                return new ViewHolder(content_view);
        }

        @Override
        public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
                final  LabelItem_list_out_man item = data.get(position);
                holder.txt_no.setText(item.getNo());
                holder.txt_lot_no.setText(item.getLot_no());
                holder.txt_box_no.setText(item.getBox_no());
                holder.txt_qty.setText(item.getIssue_qty());
                holder.txt_unit.setText(item.getUnit());
                holder.txt_status.setText(item.getStatus());

                String status = item.getStatus();
                if (status.trim().equals("OK")){
                        holder.layout.setBackgroundResource(R.color.status_completed);
                }else{
                        holder.layout.setBackgroundResource(R.color.color_button);
                }
        }

        @Override
        public int getItemCount() {
                return data.size();
        }
}
