package com.tomas.ht_mast.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.ht_mast.ListData.ItemStock_list;
import com.tomas.ht_mast.R;

import java.text.DecimalFormat;
import java.util.List;

public class ItemStock_Adapter extends RecyclerView.Adapter<ItemStock_Adapter.ViewHolder> {
    private List<ItemStock_list>data;
    Context context;
    DecimalFormat decimalFormat;

    public ItemStock_Adapter(List<ItemStock_list> data, Context context) {
        this.data = data;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        LinearLayout layout;
        TextView txt_index, txt_location, txt_qty_per_box, txt_qty;
        public ViewHolder(View itemview){
            super(itemview);
            layout = (LinearLayout) itemview.findViewById(R.id.item_row);
            txt_index = (TextView)itemView.findViewById(R.id.txt_index);
            txt_location = (TextView)itemView.findViewById(R.id.txt_location);
            txt_qty_per_box = (TextView)itemView.findViewById(R.id.txt_qty_per_box);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
        }
    }

    @NonNull
    @Override
    public ItemStock_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_stock_check,parent,false);
        context = parent.getContext();
        return new ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ItemStock_Adapter.ViewHolder holder, int position) {
        decimalFormat = new DecimalFormat("#,#00.00");
        final  ItemStock_list item = data.get(position);
        holder.txt_index.setText(item.getId());
        holder.txt_location.setText(item.getLocation());
        holder.txt_qty_per_box.setText(item.getQty_per_box());
        holder.txt_qty.setText(decimalFormat.format(Double.parseDouble(item.getQty())));
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
