USE [CHECK_SHEET]
GO
/****** Object:  UserDefinedFunction [dbo].[listweekend_of_year]    Script Date: 07/15/2024 12:51:19 ******/
DROP FUNCTION [dbo].[listweekend_of_year]
GO
/****** Object:  UserDefinedFunction [dbo].[listdate_of_year]    Script Date: 07/15/2024 12:51:19 ******/
DROP FUNCTION [dbo].[listdate_of_year]
GO
/****** Object:  Table [dbo].[Users]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Users]') AND type in (N'U'))
DROP TABLE [dbo].[Users]
GO
/****** Object:  Table [dbo].[User_permission]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[User_permission]') AND type in (N'U'))
DROP TABLE [dbo].[User_permission]
GO
/****** Object:  Table [dbo].[ScheduleCheck]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ScheduleCheck]') AND type in (N'U'))
DROP TABLE [dbo].[ScheduleCheck]
GO
/****** Object:  Table [dbo].[RootApproval]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RootApproval]') AND type in (N'U'))
DROP TABLE [dbo].[RootApproval]
GO
/****** Object:  Table [dbo].[mst_Unit]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_Unit]') AND type in (N'U'))
DROP TABLE [dbo].[mst_Unit]
GO
/****** Object:  Table [dbo].[mst_Inspection]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_Inspection]') AND type in (N'U'))
DROP TABLE [dbo].[mst_Inspection]
GO
/****** Object:  Table [dbo].[mst_Frequency]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_Frequency]') AND type in (N'U'))
DROP TABLE [dbo].[mst_Frequency]
GO
/****** Object:  Table [dbo].[mst_ErrorLog]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_ErrorLog]') AND type in (N'U'))
DROP TABLE [dbo].[mst_ErrorLog]
GO
/****** Object:  Table [dbo].[mst_ContentInput]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_ContentInput]') AND type in (N'U'))
DROP TABLE [dbo].[mst_ContentInput]
GO
/****** Object:  Table [dbo].[mst_Approve]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_Approve]') AND type in (N'U'))
DROP TABLE [dbo].[mst_Approve]
GO
/****** Object:  Table [dbo].[mst_Approval_Level]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[mst_Approval_Level]') AND type in (N'U'))
DROP TABLE [dbo].[mst_Approval_Level]
GO
/****** Object:  Table [dbo].[Menu]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Menu]') AND type in (N'U'))
DROP TABLE [dbo].[Menu]
GO
/****** Object:  Table [dbo].[MachineMaster]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MachineMaster]') AND type in (N'U'))
DROP TABLE [dbo].[MachineMaster]
GO
/****** Object:  Table [dbo].[LineGroupMaster]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LineGroupMaster]') AND type in (N'U'))
DROP TABLE [dbo].[LineGroupMaster]
GO
/****** Object:  Table [dbo].[JigMaster]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[JigMaster]') AND type in (N'U'))
DROP TABLE [dbo].[JigMaster]
GO
/****** Object:  Table [dbo].[InspectionItem]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[InspectionItem]') AND type in (N'U'))
DROP TABLE [dbo].[InspectionItem]
GO
/****** Object:  Table [dbo].[InspectionInput]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[InspectionInput]') AND type in (N'U'))
DROP TABLE [dbo].[InspectionInput]
GO
/****** Object:  Table [dbo].[EquipmentList]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EquipmentList]') AND type in (N'U'))
DROP TABLE [dbo].[EquipmentList]
GO
/****** Object:  Table [dbo].[EmailSend_log]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailSend_log]') AND type in (N'U'))
DROP TABLE [dbo].[EmailSend_log]
GO
/****** Object:  Table [dbo].[Dayoff]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Dayoff]') AND type in (N'U'))
DROP TABLE [dbo].[Dayoff]
GO
/****** Object:  Table [dbo].[CalendarPlan]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CalendarPlan]') AND type in (N'U'))
DROP TABLE [dbo].[CalendarPlan]
GO
/****** Object:  Table [dbo].[ApprovalLog]    Script Date: 07/15/2024 12:51:19 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ApprovalLog]') AND type in (N'U'))
DROP TABLE [dbo].[ApprovalLog]
GO
/****** Object:  Table [dbo].[ApprovalLog]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ApprovalLog](
	[logid] [varchar](30) NOT NULL,
	[inspid] [varchar](30) NULL,
	[seqno] [int] NULL,
	[equid] [varchar](30) NULL,
	[userid] [varchar](30) NULL,
	[approvedate] [datetime] NULL,
	[approvetime] [datetime] NULL,
	[approvestatus] [nchar](2) NULL,
	[remark] [varchar](200) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
 CONSTRAINT [PK_ApprovalLog] PRIMARY KEY CLUSTERED 
(
	[logid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[CalendarPlan]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[CalendarPlan](
	[calenid] [varchar](30) NOT NULL,
	[monthno] [int] NULL,
	[yearno] [int] NULL,
	[check_type] [int] NULL,
	[equid] [varchar](30) NULL,
	[dayoff] [datetime] NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
 CONSTRAINT [PK_CalendarPlan] PRIMARY KEY CLUSTERED 
(
	[calenid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Dayoff]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Dayoff](
	[dayoffid] [varchar](30) NOT NULL,
	[dayoff] [datetime] NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_Dayoff] PRIMARY KEY CLUSTERED 
(
	[dayoffid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[EmailSend_log]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[EmailSend_log](
	[error_msg] [varchar](300) NOT NULL,
	[log_datetime] [datetime] NOT NULL,
 CONSTRAINT [PK_EmailSend_log] PRIMARY KEY CLUSTERED 
(
	[error_msg] ASC,
	[log_datetime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[EquipmentList]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[EquipmentList](
	[equid] [varchar](30) NOT NULL,
	[partnumber] [varchar](30) NULL,
	[linegroupid] [varchar](30) NULL,
	[machineid] [varchar](30) NULL,
	[jigid] [varchar](30) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[equ_piz] [varchar](50) NULL,
 CONSTRAINT [PK_EquipmentList] PRIMARY KEY CLUSTERED 
(
	[equid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[InspectionInput]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[InspectionInput](
	[inspidid] [varchar](30) NOT NULL,
	[equid] [varchar](30) NULL,
	[inspectid] [varchar](30) NULL,
	[itemno] [varchar](30) NULL,
	[itemname] [varchar](80) NULL,
	[inspectiondate] [datetime] NULL,
	[inspectiontype] [varchar](20) NULL,
	[jigid] [varchar](50) NULL,
	[partnumber] [varchar](50) NULL,
	[toolname] [varchar](100) NULL,
	[serialnumber] [varchar](50) NULL,
	[resultvalue] [float] NULL,
	[resultstatus] [varchar](10) NULL,
	[notice] [varchar](100) NULL,
	[detailchangepoint] [varchar](200) NULL,
	[result1] [varchar](30) NULL,
	[action1] [varchar](100) NULL,
	[result2] [varchar](30) NULL,
	[action2] [varchar](100) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[insp_piz] [varchar](100) NULL,
	[insp_status] [nchar](1) NULL,
	[confirm1_status] [nchar](1) NULL,
	[confirm1_notice] [varchar](200) NULL,
	[confirm1_date] [datetime] NULL,
	[confirm1_userid] [varchar](50) NULL,
	[check1_status] [nchar](1) NULL,
	[check1_notice] [varchar](200) NULL,
	[check1_date] [datetime] NULL,
	[check1_userid] [varchar](50) NULL,
	[approve1_status] [nchar](1) NULL,
	[approve1_notice] [varchar](200) NULL,
	[approve1_date] [datetime] NULL,
	[approve1_userid] [varchar](50) NULL,
	[confirm2_status] [nchar](1) NULL,
	[confirm2_notice] [varchar](200) NULL,
	[confirm2_date] [datetime] NULL,
	[confirm2_userid] [varchar](50) NULL,
	[check2_status] [nchar](1) NULL,
	[check2_notice] [varchar](200) NULL,
	[check2_date] [datetime] NULL,
	[check2_userid] [varchar](50) NULL,
	[approve2_status] [nchar](1) NULL,
	[approve2_notice] [varchar](200) NULL,
	[approve2_date] [datetime] NULL,
	[approve2_userid] [varchar](50) NULL,
 CONSTRAINT [PK_InspectionInput] PRIMARY KEY CLUSTERED 
(
	[inspidid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[InspectionItem]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[InspectionItem](
	[inspectid] [varchar](30) NOT NULL,
	[equid] [varchar](30) NOT NULL,
	[itemno] [varchar](30) NOT NULL,
	[itemname] [varchar](80) NULL,
	[whoid] [varchar](20) NULL,
	[whochecklist] [varchar](50) NULL,
	[freqid] [varchar](20) NULL,
	[frequency] [varchar](50) NULL,
	[howcheck] [varchar](80) NULL,
	[criteriatext] [varchar](80) NULL,
	[criteriamin] [float] NULL,
	[criteriamax] [float] NULL,
	[unitid] [varchar](20) NULL,
	[unit] [varchar](50) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[input_method] [varchar](100) NULL,
	[input_x] [varchar](20) NULL,
	[input_type] [nchar](1) NULL,
	[inspection_type] [nchar](1) NULL,
 CONSTRAINT [PK_InspectionItem_1] PRIMARY KEY CLUSTERED 
(
	[inspectid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[JigMaster]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[JigMaster](
	[jigid] [varchar](30) NOT NULL,
	[toolname] [varchar](50) NULL,
	[serial] [varchar](50) NOT NULL,
	[expire_date] [datetime] NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
 CONSTRAINT [PK_JigMaster] PRIMARY KEY CLUSTERED 
(
	[jigid] ASC,
	[serial] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[LineGroupMaster]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[LineGroupMaster](
	[linegroupid] [varchar](30) NOT NULL,
	[linename] [varchar](100) NULL,
	[partnumber] [varchar](50) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[linegroup_piz] [varchar](200) NULL,
 CONSTRAINT [PK_LineGroupMaster] PRIMARY KEY CLUSTERED 
(
	[linegroupid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[MachineMaster]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[MachineMaster](
	[machineid] [varchar](30) NOT NULL,
	[machinename] [varchar](100) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[machine_piz] [varchar](200) NULL,
 CONSTRAINT [PK_MachineMaster] PRIMARY KEY CLUSTERED 
(
	[machineid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Menu]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Menu](
	[menuid] [int] NOT NULL,
	[menuname] [varchar](50) NULL,
	[menulink] [varchar](30) NULL,
	[menuimage] [varchar](30) NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_Menu] PRIMARY KEY CLUSTERED 
(
	[menuid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_Approval_Level]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_Approval_Level](
	[approvalid] [varchar](20) NOT NULL,
	[approvalname] [varchar](80) NULL,
	[approvallevel] [int] NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_mst_Approval_Level] PRIMARY KEY CLUSTERED 
(
	[approvalid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_Approve]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_Approve](
	[approve_id] [varchar](20) NOT NULL,
	[approve_userid] [varchar](30) NULL,
	[approve_username] [varchar](80) NULL,
	[approve_positionid] [varchar](10) NULL,
	[approve_position] [varchar](80) NULL,
	[approve_level] [int] NULL,
	[approve_email] [varchar](50) NULL,
	[approve_seq] [int] NULL,
	[inspectiontype] [varchar](10) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[linegroupid] [varchar](20) NULL,
	[linename] [varchar](80) NULL,
	[partnumber] [varchar](50) NULL,
 CONSTRAINT [PK_mst_Approve] PRIMARY KEY CLUSTERED 
(
	[approve_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_ContentInput]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_ContentInput](
	[input_type_id] [int] NOT NULL,
	[input_type_name] [varchar](50) NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_mst_ContentInput] PRIMARY KEY CLUSTERED 
(
	[input_type_id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_ErrorLog]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_ErrorLog](
	[error_msg_sql] [varchar](300) NOT NULL,
	[error_log_datetime] [datetime] NOT NULL,
 CONSTRAINT [PK_mst_ErrorLog] PRIMARY KEY CLUSTERED 
(
	[error_msg_sql] ASC,
	[error_log_datetime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_Frequency]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_Frequency](
	[freqid] [varchar](20) NOT NULL,
	[freqname] [varchar](50) NULL,
	[freqtype] [nchar](2) NULL,
	[freqdate] [varchar](20) NULL,
	[freqvalue] [varchar](50) NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_mst_Frequency] PRIMARY KEY CLUSTERED 
(
	[freqid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_Inspection]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_Inspection](
	[inspectionid] [varchar](20) NOT NULL,
	[inspectionname] [varchar](80) NULL,
	[flagdel] [nchar](10) NULL,
 CONSTRAINT [PK_mst_Inspection] PRIMARY KEY CLUSTERED 
(
	[inspectionid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[mst_Unit]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[mst_Unit](
	[unitid] [int] NOT NULL,
	[unitname] [varchar](80) NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_mst_Unit] PRIMARY KEY CLUSTERED 
(
	[unitid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[RootApproval]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[RootApproval](
	[rootid] [varchar](30) NOT NULL,
	[seqno] [int] NOT NULL,
	[equid] [varchar](30) NULL,
	[userid] [varchar](30) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
	[emp_approve_status] [varchar](20) NULL,
	[emp_approve_seqno] [varchar](10) NULL,
 CONSTRAINT [PK_RootApproval] PRIMARY KEY CLUSTERED 
(
	[rootid] ASC,
	[seqno] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[ScheduleCheck]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[ScheduleCheck](
	[scheid] [varchar](30) NOT NULL,
	[partnumber] [varchar](30) NULL,
	[linegroupid] [varchar](30) NULL,
	[linename] [varchar](80) NULL,
	[equid] [varchar](30) NULL,
	[itemno] [int] NULL,
	[monthcheck] [int] NULL,
	[yearcheck] [int] NULL,
	[flagdel] [bit] NULL,
 CONSTRAINT [PK_ScheduleCheck] PRIMARY KEY CLUSTERED 
(
	[scheid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[User_permission]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[User_permission](
	[id] [int] IDENTITY(1,1) NOT NULL,
	[userid] [int] NULL,
	[menuid] [int] NULL,
 CONSTRAINT [PK_User_permission] PRIMARY KEY CLUSTERED 
(
	[id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  Table [dbo].[Users]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[Users](
	[userid] [int] IDENTITY(1,1) NOT NULL,
	[usercode] [varchar](20) NULL,
	[username] [varchar](30) NULL,
	[password] [varchar](50) NULL,
	[firstname] [varchar](50) NULL,
	[lastname] [varchar](50) NULL,
	[position] [varchar](50) NULL,
	[emailaddress] [varchar](50) NULL,
	[flagdel] [bit] NULL,
	[create_user] [varchar](50) NULL,
	[create_datetime] [datetime] NULL,
	[update_user] [varchar](50) NULL,
	[update_datetime] [datetime] NULL,
 CONSTRAINT [PK_User] PRIMARY KEY CLUSTERED 
(
	[userid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
GO
/****** Object:  UserDefinedFunction [dbo].[listdate_of_year]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE FUNCTION [dbo].[listdate_of_year] (@d datetime)
RETURNS TABLE 
AS
RETURN 
(
select dateadd(dd,number,@d) as listday,Datename(dw,dateadd(dd,number,@d)) as listdayname from master.dbo.spt_values
where type = 'p'
and year(dateadd(dd,number,@d))=year(@d)

)
GO
/****** Object:  UserDefinedFunction [dbo].[listweekend_of_year]    Script Date: 07/15/2024 12:51:19 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE FUNCTION [dbo].[listweekend_of_year]	 (@d datetime)
RETURNS TABLE 
AS
RETURN 
(
select dateadd(dd,number,@d) as listday from master.dbo.spt_values
where type = 'p'
and year(dateadd(dd,number,@d))=year(@d)
and DATEPART(dw,dateadd(dd,number,@d)) in (7)
union
select dateadd(dd,1,dateadd(dd,number,@d)) as listday from master.dbo.spt_values
where type = 'p'
and year(dateadd(dd,number,@d))=year(@d)
and DATEPART(dw,dateadd(dd,number,@d)) in (7)


)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', 6, 2024, 1, N'', CAST(N'2024-06-01T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'10', 6, 2024, 1, N'', CAST(N'2024-06-30T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'11', 6, 2024, 1, N'1', CAST(N'2024-06-01T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'12', 6, 2024, 1, N'1', CAST(N'2024-06-02T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'13', 6, 2024, 1, N'1', CAST(N'2024-06-08T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'14', 6, 2024, 1, N'1', CAST(N'2024-06-09T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'15', 6, 2024, 1, N'1', CAST(N'2024-06-15T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'16', 6, 2024, 1, N'1', CAST(N'2024-06-16T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'17', 6, 2024, 1, N'1', CAST(N'2024-06-22T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'18', 6, 2024, 1, N'1', CAST(N'2024-06-23T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'19', 6, 2024, 1, N'1', CAST(N'2024-06-29T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'2', 6, 2024, 1, N'', CAST(N'2024-06-02T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'20', 6, 2024, 1, N'1', CAST(N'2024-06-30T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'21', 6, 2024, 1, N'1', CAST(N'2024-06-21T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:30.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'22', 6, 2024, 1, N'1', CAST(N'2024-06-20T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:31.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'23', 6, 2024, 2, N'', CAST(N'2024-06-01T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'24', 6, 2024, 2, N'', CAST(N'2024-06-02T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'25', 6, 2024, 2, N'', CAST(N'2024-06-08T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'26', 6, 2024, 2, N'', CAST(N'2024-06-09T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'27', 6, 2024, 2, N'', CAST(N'2024-06-15T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'28', 6, 2024, 2, N'', CAST(N'2024-06-16T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'29', 6, 2024, 2, N'', CAST(N'2024-06-22T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'3', 6, 2024, 1, N'', CAST(N'2024-06-08T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'30', 6, 2024, 2, N'', CAST(N'2024-06-23T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'31', 6, 2024, 2, N'', CAST(N'2024-06-29T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'32', 6, 2024, 2, N'', CAST(N'2024-06-30T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:44.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'33', 6, 2024, 2, N'1', CAST(N'2024-06-01T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'34', 6, 2024, 2, N'1', CAST(N'2024-06-02T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'35', 6, 2024, 2, N'1', CAST(N'2024-06-08T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'36', 6, 2024, 2, N'1', CAST(N'2024-06-09T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'37', 6, 2024, 2, N'1', CAST(N'2024-06-15T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'38', 6, 2024, 2, N'1', CAST(N'2024-06-16T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'39', 6, 2024, 2, N'1', CAST(N'2024-06-22T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'4', 6, 2024, 1, N'', CAST(N'2024-06-09T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'40', 6, 2024, 2, N'1', CAST(N'2024-06-23T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'41', 6, 2024, 2, N'1', CAST(N'2024-06-29T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'42', 6, 2024, 2, N'1', CAST(N'2024-06-30T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'43', 6, 2024, 2, N'1', CAST(N'2024-06-28T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:10:53.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'44', 7, 2024, 1, N'1', CAST(N'2024-07-06T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'45', 7, 2024, 1, N'1', CAST(N'2024-07-07T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'46', 7, 2024, 1, N'1', CAST(N'2024-07-13T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'47', 7, 2024, 1, N'1', CAST(N'2024-07-14T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'48', 7, 2024, 1, N'1', CAST(N'2024-07-20T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'49', 7, 2024, 1, N'1', CAST(N'2024-07-21T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'5', 6, 2024, 1, N'', CAST(N'2024-06-15T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'50', 7, 2024, 1, N'1', CAST(N'2024-07-27T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'51', 7, 2024, 1, N'1', CAST(N'2024-07-28T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-26T16:19:28.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'52', 7, 2024, 3, N'', CAST(N'2024-07-06T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'53', 7, 2024, 3, N'', CAST(N'2024-07-07T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'54', 7, 2024, 3, N'', CAST(N'2024-07-13T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'55', 7, 2024, 3, N'', CAST(N'2024-07-14T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'56', 7, 2024, 3, N'', CAST(N'2024-07-20T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'57', 7, 2024, 3, N'', CAST(N'2024-07-21T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'58', 7, 2024, 3, N'', CAST(N'2024-07-27T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'59', 7, 2024, 3, N'', CAST(N'2024-07-28T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T15:50:21.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'6', 6, 2024, 1, N'', CAST(N'2024-06-16T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'60', 7, 2024, 4, N'', CAST(N'2024-07-06T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'61', 7, 2024, 4, N'', CAST(N'2024-07-07T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'62', 7, 2024, 4, N'', CAST(N'2024-07-13T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'63', 7, 2024, 4, N'', CAST(N'2024-07-14T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'64', 7, 2024, 4, N'', CAST(N'2024-07-20T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'65', 7, 2024, 4, N'', CAST(N'2024-07-21T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'66', 7, 2024, 4, N'', CAST(N'2024-07-27T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'67', 7, 2024, 4, N'', CAST(N'2024-07-28T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-07-01T20:37:20.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'7', 6, 2024, 1, N'', CAST(N'2024-06-22T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'8', 6, 2024, 1, N'', CAST(N'2024-06-23T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[CalendarPlan] ([calenid], [monthno], [yearno], [check_type], [equid], [dayoff], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'9', 6, 2024, 1, N'', CAST(N'2024-06-29T00:00:00.000' AS DateTime), 0, N'admin', CAST(N'2024-06-22T00:09:51.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'1', CAST(N'2024-06-01T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'10', CAST(N'2024-06-30T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'11', CAST(N'2024-06-11T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'13', CAST(N'2024-07-06T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'14', CAST(N'2024-07-07T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'16', CAST(N'2024-07-14T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'17', CAST(N'2024-07-20T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'18', CAST(N'2024-07-21T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'19', CAST(N'2024-07-24T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'2', CAST(N'2024-06-02T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'20', CAST(N'2024-07-28T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'21', CAST(N'2024-08-03T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'22', CAST(N'2024-08-04T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'23', CAST(N'2024-08-10T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'24', CAST(N'2024-08-11T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'25', CAST(N'2024-08-17T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'26', CAST(N'2024-08-18T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'27', CAST(N'2024-08-24T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'28', CAST(N'2024-08-25T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'29', CAST(N'2024-08-31T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'3', CAST(N'2024-06-08T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'30', CAST(N'2024-09-01T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'31', CAST(N'2024-09-07T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'32', CAST(N'2024-09-08T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'33', CAST(N'2024-09-14T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'34', CAST(N'2024-09-15T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'35', CAST(N'2024-09-21T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'36', CAST(N'2024-09-22T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'37', CAST(N'2024-09-28T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'38', CAST(N'2024-09-29T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'4', CAST(N'2024-06-09T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'6', CAST(N'2024-06-16T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'7', CAST(N'2024-06-22T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[Dayoff] ([dayoffid], [dayoff], [flagdel]) VALUES (N'8', CAST(N'2024-06-23T00:00:00.000' AS DateTime), 0)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'1', N'P0001', N'0001', N'1', N'1', 1, NULL, NULL, N'00001', CAST(N'2024-07-08T13:04:19.000' AS DateTime), N'../machine/mc.png')
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'10', N'PN0004', N'L004', N'MC103', NULL, 0, N'00001', CAST(N'2024-07-13T20:38:18.000' AS DateTime), N'00001', CAST(N'2024-07-13T20:38:36.000' AS DateTime), NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'2', N'P0002', N'0002', N'2', N'2', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'3', N'P0003', N'0003', N'3', NULL, 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'4', N'P0001', N'0001', N'MC001', NULL, 0, N'00001', CAST(N'2024-07-05T21:02:07.000' AS DateTime), N'00002', CAST(N'2024-07-12T21:09:29.000' AS DateTime), NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'5', N'P0002', N'0002', N'MC002', NULL, 0, N'00001', CAST(N'2024-07-05T21:04:48.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'6', N'P0004', N'0004', N'MC004', NULL, 0, N'00001', CAST(N'2024-07-05T21:05:36.000' AS DateTime), N'00002', CAST(N'2024-07-12T21:11:31.000' AS DateTime), NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'7', N'P0001', N'0001', NULL, N'3', 0, N'00001', CAST(N'2024-07-06T12:06:07.000' AS DateTime), N'00001', CAST(N'2024-07-08T13:15:07.000' AS DateTime), NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'8', N'P0001', N'0001', N'mzpiz001', NULL, 0, N'00001', CAST(N'2024-07-11T16:27:19.000' AS DateTime), N'00002', CAST(N'2024-07-12T21:06:45.000' AS DateTime), NULL)
GO
INSERT [dbo].[EquipmentList] ([equid], [partnumber], [linegroupid], [machineid], [jigid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [equ_piz]) VALUES (N'9', N'P0004', N'0004', NULL, N'4', 0, N'00001', CAST(N'2024-07-13T15:40:24.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'1', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-19T20:59:33.000' AS DateTime), N'1', NULL, NULL, NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-20T20:59:33.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_205928.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'10', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-06-24T14:34:15.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, 67.23, NULL, N'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-24T12:33:28.000' AS DateTime), N'admin', CAST(N'2024-06-24T14:34:15.000' AS DateTime), N'../piz/1/1_2_Inspection_tiem_2_20240624_143348.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'11', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-06-24T14:44:10.000' AS DateTime), N'2', NULL, N'0001', NULL, NULL, 88, NULL, N'ddddddddddddddddddddddddddddddddd', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-24T14:43:55.000' AS DateTime), N'admin', CAST(N'2024-06-24T14:44:10.000' AS DateTime), N'../piz/2/1_2_Inspection_tiem_2_20240624_144353.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'12', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-24T17:40:59.000' AS DateTime), N'4', NULL, N'0001', NULL, NULL, NULL, NULL, N'xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx', N'aaaaaaaaaaaaaaaaaaaaaaaaaaaxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxyyyyyyyyyyyyyyyyyyyyyzzzzzzzzzzzzzzzzzzz', N'NG', N'bbbbbbbbbbbbbbbbbbbbbbbbbb', N'OK', N'', 0, N'admin', CAST(N'2024-06-24T15:19:53.000' AS DateTime), N'admin', CAST(N'2024-06-24T17:40:59.000' AS DateTime), N'../piz/1/0001_1__20240624_151948.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'13', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-06-24T19:25:27.000' AS DateTime), N'4', NULL, N'0001', NULL, NULL, NULL, NULL, N'', N'dsafadsfdsfs', N'OK', N'', N'', N'', 0, N'admin', CAST(N'2024-06-24T19:25:27.000' AS DateTime), NULL, NULL, N'../piz/1/0001_1__20240624_151948.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'14', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-27T22:09:10.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-27T22:09:10.000' AS DateTime), NULL, NULL, N'../piz/1/0001_1__20240624_151948.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'15', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-28T16:00:00.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-28T16:00:00.000' AS DateTime), NULL, NULL, N'../piz/1/0001_1__20240624_151948.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'16', N'2', N'21', N'1', N'Inspection_tiem_1', CAST(N'2024-06-28T16:44:04.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-28T16:44:04.000' AS DateTime), NULL, NULL, N'', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'17', N'2', N'24', N'4', N'Inspection_tiem_4', CAST(N'2024-06-28T21:09:17.000' AS DateTime), N'2', NULL, N'0001', NULL, NULL, 99.87, NULL, N'TEST XR', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-28T21:09:07.000' AS DateTime), N'admin', CAST(N'2024-06-28T21:09:17.000' AS DateTime), N'', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'18', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-02T17:19:55.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-02T17:19:55.000' AS DateTime), NULL, NULL, N'', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'19', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-07-02T17:20:04.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, 34.98, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-02T17:20:04.000' AS DateTime), NULL, NULL, N'', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'2', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-20T23:08:24.000' AS DateTime), N'1', NULL, NULL, NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-20T23:08:24.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_230821.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'20', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-07-02T17:20:09.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-02T17:20:09.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_230821.jpg', N'S', N'Y', N'', CAST(N'2024-07-04T23:54:56.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-12T23:33:03.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:51:18.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-04T23:56:18.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'21', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-03T11:04:57.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:04:57.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_230821.jpg', N'W', N'Y', N'', CAST(N'2024-07-13T00:09:22.000' AS DateTime), N'00003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'22', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-07-03T11:05:08.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, 76.9, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:05:08.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_230821.jpg', N'W', N'Y', N'', CAST(N'2024-07-13T00:09:25.000' AS DateTime), N'00003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'23', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-07-03T11:05:17.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:05:17.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_Inspection_tiem_1_20240620_230821.jpg', N'S', N'Y', N'', CAST(N'2024-07-04T23:54:59.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-12T23:33:03.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:51:18.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-04T23:56:20.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'24', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-07-03T11:29:53.000' AS DateTime), N'2', NULL, N'0001', NULL, NULL, 98.7, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:29:53.000' AS DateTime), NULL, NULL, N'', N'R', N'N', N'testreject', CAST(N'2024-07-05T12:13:02.000' AS DateTime), N'00001', NULL, NULL, NULL, NULL, NULL, N'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'25', N'1', N'4', N'4', N'Inspection_tiem_4', CAST(N'2024-07-03T11:30:06.000' AS DateTime), N'2', NULL, N'0001', NULL, NULL, 12.9, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:30:06.000' AS DateTime), NULL, NULL, N'', N'R', N'Y', N'', CAST(N'2024-07-05T12:13:05.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-12T21:55:37.000' AS DateTime), N'00003', NULL, N'', NULL, NULL, N'N', N'xxxxxxxxxxxxxxxxxxxxxx', CAST(N'2024-07-05T12:14:31.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'26', NULL, NULL, NULL, NULL, CAST(N'2024-07-03T11:42:02.000' AS DateTime), N'3', N'1', N'0001', N'Tool_01', N'00001', NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:42:02.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'R', N'N', N'testreject', CAST(N'2024-07-05T15:46:28.000' AS DateTime), N'00001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'27', NULL, NULL, NULL, NULL, CAST(N'2024-07-03T11:42:04.000' AS DateTime), N'3', N'1', N'0001', N'Tool_02', N'00002', NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:42:04.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'R', N'Y', N'', CAST(N'2024-07-05T15:47:01.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-13T16:11:35.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:12:39.000' AS DateTime), N'00002', N'N', N'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', CAST(N'2024-07-05T16:22:06.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'28', NULL, NULL, NULL, NULL, CAST(N'2024-07-03T11:42:06.000' AS DateTime), N'3', N'1', N'0001', N'Tool_03', N'00003', NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-03T11:42:06.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'S', N'Y', N'', CAST(N'2024-07-05T15:47:03.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-13T16:11:35.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:12:39.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-05T16:22:09.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'29', N'2', N'23', N'3', N'Inspection_tiem_3', CAST(N'2024-07-03T11:42:38.000' AS DateTime), N'4', NULL, N'0001', NULL, NULL, NULL, NULL, N'', N'TESTXXXXXx', N'OK', N'Move I2', N'', N'', 0, N'admin', CAST(N'2024-07-03T11:42:38.000' AS DateTime), NULL, NULL, N'', N'S', N'Y', N'', CAST(N'2024-07-05T17:07:06.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-05T17:16:58.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-05T17:50:32.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-05T17:50:18.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'3', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-06-20T23:28:30.000' AS DateTime), N'1', NULL, NULL, NULL, NULL, NULL, N'NG', N'uuuuuuuuuuuuuuuuuuuuuuuuuuuuuu', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-20T23:28:30.000' AS DateTime), NULL, NULL, N'../piz/1/1_3_Inspection_tiem_3_20240620_232827.jpg', N'S', N'Y', N'', CAST(N'2024-07-04T23:54:54.000' AS DateTime), N'00001', N'Y', N'', CAST(N'2024-07-12T23:33:03.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:51:18.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-04T23:56:16.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'30', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-03T12:22:32.000' AS DateTime), N'4', NULL, N'0001', NULL, NULL, NULL, NULL, N'Notice TEST', N'AAAAAAAAAAATEST', N'NG', N'TEST Action', N'', N'', 0, N'admin', CAST(N'2024-07-03T12:22:32.000' AS DateTime), NULL, NULL, N'', N'R', N'N', N'TEST REJECT', CAST(N'2024-07-05T17:07:15.000' AS DateTime), N'00001', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'31', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-07-12T16:10:28.000' AS DateTime), N'1', NULL, N'P0001', NULL, NULL, 23, NULL, N'xxxxxxxxxxxxxxxxxxxxxxxx', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-11T16:10:28.000' AS DateTime), NULL, NULL, N'../piz/1/1_2_Inspection_tiem_2_20240711_161019.jpg', N'R', N'N', N'dsfdsfdsfdsafds', CAST(N'2024-07-12T22:57:51.000' AS DateTime), N'00003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'32', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-07-12T23:34:41.000' AS DateTime), N'1', NULL, N'P0002', NULL, NULL, NULL, N'OK', N'test', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-11T23:34:41.000' AS DateTime), NULL, NULL, N'../piz/1/1_2_Inspection_tiem_2_20240711_161019.jpg', N'S', N'Y', N'', CAST(N'2024-07-12T23:32:53.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:33:03.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:51:18.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-12T23:34:45.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'33', N'1', N'3', N'3', N'Inspection_tiem_3', CAST(N'2024-07-12T11:58:34.000' AS DateTime), N'2', NULL, N'P0002', NULL, NULL, 87.98, NULL, N'testxxxxx', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T11:58:34.000' AS DateTime), NULL, NULL, N'../piz/3/0001_00002__20240624_161715.jpg', N'W', N'N', N'aaaaaaaaaaaaaaaabbbbbbbbbbbbccccccc', CAST(N'2024-07-12T22:48:37.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T21:55:37.000' AS DateTime), N'00003', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'34', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:16.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_01', N'00001', NULL, N'OK', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:16.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'S', N'Y', N'', CAST(N'2024-07-13T16:11:19.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:11:35.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:12:39.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-13T16:12:22.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'35', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:17.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_02', N'00002', NULL, N'OK', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:17.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'S', N'Y', N'', CAST(N'2024-07-13T16:11:23.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:11:35.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:12:39.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-13T16:12:25.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'36', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:18.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_04', N'00004', NULL, N'OK', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:18.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'S', N'Y', N'', CAST(N'2024-07-13T16:11:26.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:11:35.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:12:39.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-13T16:12:27.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'37', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:22.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_05', N'00005', NULL, N'OK', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:22.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'38', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:24.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_06', N'00006', NULL, N'NG', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:24.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'39', NULL, NULL, NULL, NULL, CAST(N'2024-07-12T12:04:26.000' AS DateTime), N'3', N'1', N'P0001', N'Tool_07', N'00007', NULL, N'NG', N'TESTXXXXVVVVVVVVV', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T12:04:26.000' AS DateTime), NULL, NULL, N'../image/piz.png', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'4', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-06-21T12:36:36.000' AS DateTime), N'1', NULL, NULL, NULL, NULL, 56.89, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-21T12:36:36.000' AS DateTime), NULL, NULL, N'../piz/1/1_2_Inspection_tiem_2_20240621_123605.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'40', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-12T12:08:41.000' AS DateTime), N'4', NULL, N'P0001', NULL, NULL, NULL, NULL, N'sdfdsfdsfdsafdsfdsfdsfdsfdsfs', N'aaaaaaaaaaaaaaaaabbbbccccccc', N'NG', N'Fix test xxxxxxxx', N'', N'', 0, N'admin', CAST(N'2024-07-12T12:08:41.000' AS DateTime), NULL, NULL, N'../piz/3/0001_00002__20240624_161715.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'41', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-12T15:57:30.000' AS DateTime), N'1', NULL, N'P0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T15:57:30.000' AS DateTime), NULL, NULL, N'../piz/1/1_1_20240712_155724.jpg', N'S', N'Y', N'', CAST(N'2024-07-12T16:36:53.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:33:03.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-12T23:51:18.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-12T21:48:34.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'42', N'1', N'30', N'10', N'Inspection_tiem_10', CAST(N'2024-07-12T23:07:54.000' AS DateTime), N'2', NULL, N'P0001', NULL, NULL, 45, NULL, N'bbbbbbb', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-12T23:07:54.000' AS DateTime), NULL, NULL, N'../piz/2/1_30_20240712_230752.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'43', N'1', N'2', N'2', N'Inspection_tiem_2', CAST(N'2024-07-13T15:46:58.000' AS DateTime), N'4', NULL, N'P0001', NULL, NULL, NULL, NULL, N'dsfdsafdsfdsfdsfdsfdsf', N'ds;flkjsd;fkdsfdsjf ;osddsfdsf', N'NG', N'dsfdsafdsfdsfdsfsd', N'', N'', 0, N'admin', CAST(N'2024-07-13T15:46:58.000' AS DateTime), NULL, NULL, N'../piz/1/P0001_2_20240713_154654.jpg', N'S', N'Y', N'', CAST(N'2024-07-13T15:48:36.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T15:59:44.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:00:46.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-13T15:57:49.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'44', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-13T15:47:24.000' AS DateTime), N'4', NULL, N'P0001', NULL, NULL, NULL, NULL, N'aaaaaaaaaaaaaaaaaaaaaaaaaaaaaa', N'bbbbbbbbbbbcccccccccccccccc', N'OK', N'', N'', N'', 0, N'admin', CAST(N'2024-07-13T15:47:24.000' AS DateTime), NULL, NULL, N'../piz/1/P0001_1_20240713_154721.jpg', N'S', N'Y', N'', CAST(N'2024-07-13T15:59:32.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T15:59:44.000' AS DateTime), N'00003', N'Y', N'', CAST(N'2024-07-13T16:00:46.000' AS DateTime), N'00002', N'Y', N'', CAST(N'2024-07-13T16:00:31.000' AS DateTime), N'00002', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'45', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-07-15T11:41:29.000' AS DateTime), N'1', NULL, N'P0001', NULL, NULL, NULL, N'OK', N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-15T11:41:29.000' AS DateTime), NULL, NULL, N'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'46', N'1', N'4', N'4', N'Inspection_tiem_4', CAST(N'2024-07-15T11:41:45.000' AS DateTime), N'1', NULL, N'P0002', NULL, NULL, 56, NULL, N'', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-07-15T11:41:45.000' AS DateTime), NULL, NULL, N'', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'5', N'1', N'4', N'4', N'Inspection_tiem_4', CAST(N'2024-06-21T16:03:48.000' AS DateTime), N'2', NULL, NULL, NULL, NULL, 100, NULL, N'dsafdsfdsafdsaffdsafdsafdsafdsafdsfdsfdsfdsaafdsafdsfdsafdsafdsafdsafdasfdsafdsfa', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-21T16:03:48.000' AS DateTime), NULL, NULL, N'../piz/2/1_4_Inspection_tiem_4_20240621_160343.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'6', NULL, NULL, NULL, NULL, CAST(N'2024-06-24T16:18:10.000' AS DateTime), N'55', N'1', N'0001', N'Tool_01', N'00001', NULL, N'NG', N'sfadsfdssdfsssssssssssssaaaaaaaaaaaaaaaaaagggggggggggggggggggggg', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-22T23:20:06.000' AS DateTime), N'admin', CAST(N'2024-06-24T16:18:10.000' AS DateTime), N'../piz/3/0001_00001__20240624_161712.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'7', NULL, NULL, NULL, NULL, CAST(N'2024-06-24T16:18:13.000' AS DateTime), N'55', N'1', N'0001', N'Tool_02', N'00002', NULL, N'OK', N'sfadsfdssdfsssssssssssssaaaaaaaaaaaaaaaaaagggggggggggggggggggggg', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-22T23:20:45.000' AS DateTime), N'admin', CAST(N'2024-06-24T16:18:13.000' AS DateTime), N'../piz/3/0001_00002__20240624_161715.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'8', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-23T18:26:59.000' AS DateTime), N'4', NULL, N'0001', NULL, NULL, NULL, NULL, N'ddddddddddddddddddddddddddddddddddddddddddddddddddd', NULL, N'NG', N'cccccccccccccccccccccccccccccccccccc', N'', N'', 0, N'admin', CAST(N'2024-06-23T18:26:59.000' AS DateTime), NULL, NULL, N'../piz/1/0001_1__20240623_182627.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionInput] ([inspidid], [equid], [inspectid], [itemno], [itemname], [inspectiondate], [inspectiontype], [jigid], [partnumber], [toolname], [serialnumber], [resultvalue], [resultstatus], [notice], [detailchangepoint], [result1], [action1], [result2], [action2], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [insp_piz], [insp_status], [confirm1_status], [confirm1_notice], [confirm1_date], [confirm1_userid], [check1_status], [check1_notice], [check1_date], [check1_userid], [approve1_status], [approve1_notice], [approve1_date], [approve1_userid], [confirm2_status], [confirm2_notice], [confirm2_date], [confirm2_userid], [check2_status], [check2_notice], [check2_date], [check2_userid], [approve2_status], [approve2_notice], [approve2_date], [approve2_userid]) VALUES (N'9', N'1', N'1', N'1', N'Inspection_tiem_1', CAST(N'2024-06-24T14:28:18.000' AS DateTime), N'1', NULL, N'0001', NULL, NULL, NULL, N'NG', N'bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb', NULL, NULL, NULL, NULL, NULL, 0, N'admin', CAST(N'2024-06-24T12:33:01.000' AS DateTime), N'admin', CAST(N'2024-06-24T14:28:18.000' AS DateTime), N'../piz/1/1_1_Inspection_tiem_1_20240624_142752.jpg', N'W', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'1', N'1', N'1', N'Inspection_tiem_1', N'00001', N'EMP_TEST1 SURNAME_1', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)', N'OK or Not Good', 0, 0, N'1', N'Mpa', 0, NULL, NULL, N'00001', CAST(N'2024-07-09T17:13:42.000' AS DateTime), N'Input is set status', N'', N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'10', N'1', N'10', N'Inspection_tiem_10', N'00001', N'EMP_TEST1 SURNAME_1', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'', 10, 100, N'2', N'Sec', 0, NULL, NULL, N'00001', CAST(N'2024-07-09T20:06:30.000' AS DateTime), N'Input is range number', N'45', N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'11', N'1', N'11', N'Inspection_tiem_11', NULL, N'Operator M11', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'12', N'1', N'12', N'Inspection_tiem_12', NULL, N'Operator M12', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'13', N'1', N'13', N'Inspection_tiem_13', NULL, N'Operator M13', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'14', N'1', N'14', N'Inspection_tiem_14', NULL, N'Operator M14', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'15', N'1', N'15', N'Inspection_tiem_15', NULL, N'Operator M15', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'16', N'1', N'16', N'Inspection_tiem_16', NULL, N'Operator M16', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'17', N'1', N'17', N'Inspection_tiem_17', NULL, N'Operator M17', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'18', N'1', N'18', N'Inspection_tiem_18', NULL, N'Operator M18', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'19', N'1', N'19', N'Inspection_tiem_19', NULL, N'Operator M19', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'2', N'1', N'2', N'Inspection_tiem_2', NULL, N'Operator M2', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'20', N'1', N'20', N'Inspection_tiem_20', NULL, N'Operator M20', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'21', N'2', N'1', N'Inspection_tiem_1', NULL, N'Operator M1', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)', N'OK or Not Good', NULL, NULL, NULL, N'Stauts', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'22', N'2', N'2', N'Inspection_tiem_2', NULL, N'Operator M2', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'23', N'2', N'3', N'Inspection_tiem_3', NULL, N'Operator M3', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'24', N'2', N'4', N'Inspection_tiem_4', NULL, N'Operator M4', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 5, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'25', N'4', N'5', N'Inspection_tiem_5', N'00001', N'EMP_TEST1 SURNAME_1', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'', 10, 100, N'2', N'Sec', 0, NULL, NULL, N'00001', CAST(N'2024-07-09T20:09:01.000' AS DateTime), N'Input is range number', N'21', N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'26', N'4', N'6', N'Inspection_tiem_6', NULL, N'Operator M6', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Stauts', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'27', N'4', N'7', N'Inspection_tiem_7', NULL, N'Operator M7', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'28', N'4', N'8', N'Inspection_tiem_8', NULL, N'Operator M8', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'29', N'4', N'9', N'Inspection_tiem_9', NULL, N'Operator M9', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'3', N'1', N'3', N'Inspection_tiem_3', NULL, N'Operator M3', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'30', N'1', N'10', N'Inspection_tiem_10', NULL, N'Operator M10', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'31', N'1', N'11', N'Inspection_tiem_11', NULL, N'Operator M11', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'32', N'1', N'12', N'Inspection_tiem_12', NULL, N'Operator M12', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'33', N'2', N'13', N'Inspection_tiem_13', NULL, N'Operator M13', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'34', N'2', N'14', N'Inspection_tiem_14', NULL, N'Operator M14', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'35', N'2', N'15', N'Inspection_tiem_15', NULL, N'Operator M15', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'36', N'2', N'16', N'Inspection_tiem_16', NULL, N'Operator M16', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'37', N'2', N'17', N'Inspection_tiem_17', NULL, N'Operator M17', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'38', N'2', N'18', N'Inspection_tiem_18', NULL, N'Operator M18', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'39', N'2', N'19', N'Inspection_tiem_19', NULL, N'Operator M19', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'4', N'1', N'4', N'Inspection_tiem_4', NULL, N'Operator M4', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 5, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'40', N'2', N'20', N'Inspection_tiem_20', NULL, N'Operator M20', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'41', N'1', N'41', N'Inspection TEST', N'00002', N'EMP_TEST2 SURNAME_2', N'1', N'Daily', N'1)check step(1) 2)check step(2) 3)check step(3)', N'OK or Not Good', 0, 0, N'2', N'Sec', 1, N'00001', CAST(N'2024-07-09T11:35:31.000' AS DateTime), N'00001', CAST(N'2024-07-09T16:59:52.000' AS DateTime), N'Input is set status', N'0.1', N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'42', N'', N'42', N'Inspection_tiem_12', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'', 10, 100, N'1', N'Mpa', 0, N'00001', CAST(N'2024-07-09T17:11:00.000' AS DateTime), NULL, NULL, N'Input is range number', N'', N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'43', N'', N'43', N'Inspection_tiem_12', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'1/W', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'', 10, 100, N'1', N'Mpa', 0, N'00001', CAST(N'2024-07-09T17:13:23.000' AS DateTime), NULL, NULL, N'Input is range number', N'', N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'44', N'4', N'44', N'TEST XR123', N'00003', N'EMP_TEST3 SURNAME_3', N'3', N'1/M (date specified)', N'Check items 1,2,3', N'', 99, 9, N'2', N'Sec', 0, N'00001', CAST(N'2024-07-09T19:07:09.000' AS DateTime), N'00001', CAST(N'2024-07-09T20:08:41.000' AS DateTime), N'Input is range number', N'45', N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'46', N'1', N'46', N'Check XR chart TEST Edit123', N'00003', N'EMP_TEST3 SURNAME_3', N'2', N'1/W (fixed day of the week)', N'check machine 1,2,3,4,5', N'', 100, 10, N'2', N'Sec', 0, N'00001', CAST(N'2024-07-09T19:21:37.000' AS DateTime), N'00001', CAST(N'2024-07-09T19:31:11.000' AS DateTime), N'Input is range number', N'120', N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'47', N'4', N'47', N'ADDTEST XR', N'00003', N'EMP_TEST3 SURNAME_3', N'1', N'Daily', N'Check XR', N'', 200, 10, N'1', N'Mpa', 1, N'00001', CAST(N'2024-07-09T20:09:42.000' AS DateTime), NULL, NULL, N'Input is range number', N'3', N'2', N'2')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'48', N'4', N'48', N'MCIE TEST 1234', N'00001', N'EMP_TEST1 SURNAME_1', N'1', N'Daily', N'Check Process 1,2,43', N'', 89, 9, N'1', N'Mpa', 1, N'00001', CAST(N'2024-07-09T20:10:40.000' AS DateTime), N'00001', CAST(N'2024-07-09T20:10:59.000' AS DateTime), N'Input is range number', N'', N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'49', N'4', N'49', N'ITEMS TEST 345', N'00001', N'EMP_TEST1 SURNAME_1', N'2', N'1/W (fixed day of the week)', N'TEST1,2,3', N'OK or Not Good', 0, 0, N'1', N'Mpa', 0, N'00001', CAST(N'2024-07-13T15:29:49.000' AS DateTime), NULL, NULL, N'Input is set status', N'45', N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'5', N'1', N'5', N'Inspection_tiem_5', NULL, N'Operator M5', N'3', N'1/M', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', NULL, 10, 100, NULL, N'Level', 0, NULL, NULL, NULL, NULL, N'Input is range number', NULL, N'2', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'6', N'1', N'6', N'Inspection_tiem_6', NULL, N'Operator M6', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Stauts', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'7', N'1', N'7', N'Inspection_tiem_7', NULL, N'Operator M7', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'8', N'1', N'8', N'Inspection_tiem_8', NULL, N'Operator M8', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[InspectionItem] ([inspectid], [equid], [itemno], [itemname], [whoid], [whochecklist], [freqid], [frequency], [howcheck], [criteriatext], [criteriamin], [criteriamax], [unitid], [unit], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [input_method], [input_x], [input_type], [inspection_type]) VALUES (N'9', N'1', N'9', N'Inspection_tiem_9', NULL, N'Operator M9', N'1', N'Daily', N'1)check step(1)<br/>2)check step(2)<br/>3)check step(3)<br/>4)check step(4)', N'OK or Not Good', NULL, NULL, NULL, N'Status', 0, NULL, NULL, NULL, NULL, N'Input is set status', NULL, N'1', N'1')
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_01', N'00001', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, N'00001', CAST(N'2024-07-08T13:04:19.000' AS DateTime))
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_02', N'00002', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_03', N'00003', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 1, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_04', N'00004', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_05', N'00005', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_06', N'00006', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_07', N'00007', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_08', N'00008', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_09', N'00009', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_10', N'00010', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_11', N'00011', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 1, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_12', N'00012', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'1', N'Tool_13', N'00013', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'2', N'Tool_14', N'00014', CAST(N'2024-10-01T00:00:00.000' AS DateTime), 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'3', N'ToolNameTEST', N'90999889', CAST(N'2024-07-15T00:00:00.000' AS DateTime), 1, N'00001', CAST(N'2024-07-06T12:06:07.000' AS DateTime), N'00001', CAST(N'2024-07-08T13:15:07.000' AS DateTime))
GO
INSERT [dbo].[JigMaster] ([jigid], [toolname], [serial], [expire_date], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (N'4', N'TEST JIG tool', N'99980889', CAST(N'2027-07-13T00:00:00.000' AS DateTime), 0, N'00001', CAST(N'2024-07-13T15:40:24.000' AS DateTime), NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0001', N'XXX1', N'P0001', 0, NULL, NULL, NULL, NULL, N'../piz/equ/mc.png')
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0002', N'XXX2', N'P0002', 0, NULL, NULL, NULL, NULL, N'../piz/equ/LNG0098_0887763334_20240711_171617.jpg')
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0003', N'XXX3', N'P0003', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0004', N'XXX4', N'P0004', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0005', N'XXX5', N'P0005', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0006', N'XXX6', N'P0006', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0007', N'XXX7', N'P0007', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0008', N'XXX8', N'P0008', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0009', N'XXX9', N'P0009', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0010', N'XXX10', N'P0010', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0011', N'XXX11', N'P0011', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0012', N'XXX12', N'P0012', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0013', N'XXX13', N'P0013', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0014', N'XXX14', N'P0014', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0015', N'XXX15', N'P0015', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0016', N'XXX16', N'P0016', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0017', N'XXX17', N'P0017', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0018', N'XXX18', N'P0018', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0019', N'XXX19', N'P0019', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0020', N'XXX20', N'P0020', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0021', N'XXX21', N'P0021', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0022', N'XXX22', N'P0022', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0023', N'XXX23', N'P0023', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0024', N'XXX24', N'P0024', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0025', N'XXX25', N'P0025', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0026', N'XXX26', N'P0026', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0027', N'XXX27', N'P0027', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0028', N'XXX28', N'P0028', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0029', N'XXX29', N'P0029', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0030', N'XXX30', N'P0030', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0031', N'XXX31', N'P0031', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0032', N'XXX32', N'P0032', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0033', N'XXX33', N'P0033', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0034', N'XXX34', N'P0034', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0035', N'XXX35', N'P0035', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0036', N'XXX36', N'P0036', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0037', N'XXX37', N'P0037', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0038', N'XXX38', N'P0038', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0039', N'XXX39', N'P0039', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0040', N'XXX40', N'P0040', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0041', N'XXX41', N'P0041', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0042', N'XXX42', N'P0042', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0043', N'XXX43', N'P0043', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0044', N'XXX44', N'P0044', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0045', N'XXX45', N'P0045', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0046', N'XXX46', N'P0046', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0047', N'XXX47', N'P0047', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0048', N'XXX48', N'P0048', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0049', N'XXX49', N'P0049', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'0050', N'XXX50', N'P0050', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'111', N'1111', N'P1111', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'222', N'2222', N'P2222', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'333', N'3333', N'P3333', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'444', N'4444', N'P4444', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'51', N'LineTEST', N'P51', 1, N'00001', CAST(N'2024-07-06T12:20:59.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'52', N'Line MC 01', N'00990090', 0, N'00001', CAST(N'2024-07-08T11:47:30.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'53', N'TEST XXXXXx', N'000988877', 0, N'00001', CAST(N'2024-07-08T11:55:18.000' AS DateTime), N'00001', CAST(N'2024-07-09T22:15:39.000' AS DateTime), NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'555', N'5555', N'P5555', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'666', N'6666', N'P6666', 0, N'00001', CAST(N'2024-07-13T20:25:02.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[LineGroupMaster] ([linegroupid], [linename], [partnumber], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroup_piz]) VALUES (N'LNG0098', N'MC LING008', N'0887763334', 0, N'00001', CAST(N'2024-07-08T11:57:47.000' AS DateTime), N'00001', CAST(N'2024-07-11T17:16:20.000' AS DateTime), N'../piz/equ/LNG0098_0887763334_20240711_171617.jpg')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'1', N'Machine_name_01', 0, NULL, NULL, NULL, NULL, N'../machine/cnc.png')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'10', N'Machine_name_10', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'11', N'Machine_name_11', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'12', N'Machine_name_12', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'13', N'Machine_name_13', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'14', N'Machine_name_14', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'15', N'Machine_name_15', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'16', N'Machine_name_16', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'17', N'Machine_name_17', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'18', N'Machine_name_18', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'19', N'Machine_name_19', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'2', N'Machine_name_02', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'20', N'Machine_name_20', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'3', N'Machine_name_03', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'4', N'Machine_name_04', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'5', N'Machine_name_05', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'6', N'Machine_name_06', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'7', N'Machine_name_07', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'8', N'Machine_name_08', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'9', N'Machine_name_09', 0, NULL, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC001', N'TESTMACHINE', 0, N'00001', CAST(N'2024-07-05T21:02:07.000' AS DateTime), N'00001', CAST(N'2024-07-11T16:43:08.000' AS DateTime), N'../piz/machine/MC001_TESTMACHINE_20240711_164303.jpg')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC002', N'MachineTEST', 0, N'00001', CAST(N'2024-07-05T21:04:48.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC004', N'Machine004', 0, N'00001', CAST(N'2024-07-05T21:05:36.000' AS DateTime), NULL, NULL, NULL)
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC100', N'MachineTESTMC100', 0, N'00001', CAST(N'2024-07-13T20:38:18.000' AS DateTime), NULL, NULL, N'')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC101', N'MachineTESTMC101', 0, N'00001', CAST(N'2024-07-13T20:38:35.000' AS DateTime), NULL, NULL, N'')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC102', N'MachineTESTMC102', 0, N'00001', CAST(N'2024-07-13T20:38:36.000' AS DateTime), NULL, NULL, N'')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'MC103', N'MachineTESTMC103', 0, N'00001', CAST(N'2024-07-13T20:38:36.000' AS DateTime), NULL, NULL, N'')
GO
INSERT [dbo].[MachineMaster] ([machineid], [machinename], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [machine_piz]) VALUES (N'mzpiz001', N'McPizm00001', 0, N'00001', CAST(N'2024-07-11T16:27:19.000' AS DateTime), NULL, NULL, N'../piz/machine/mzpiz001_McPizm00001_20240711_162701.jpg')
GO
INSERT [dbo].[mst_Approval_Level] ([approvalid], [approvalname], [approvallevel], [flagdel]) VALUES (N'0', N'
Inspector', 0, 0)
GO
INSERT [dbo].[mst_Approval_Level] ([approvalid], [approvalname], [approvallevel], [flagdel]) VALUES (N'1', N'Check', 1, 0)
GO
INSERT [dbo].[mst_Approval_Level] ([approvalid], [approvalname], [approvallevel], [flagdel]) VALUES (N'2', N'Approver', 2, 0)
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'1', N'00001', N'EMP_TEST1 SURNAME_1', N'0', N'Inspector', 0, N'pairoj.nj@gmail.com', 1, N'1', 0, NULL, NULL, N'00001', CAST(N'2024-07-10T12:11:04.000' AS DateTime), N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'10', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'Approvol', 2, N'piriya_roj@live.com', 1, N'4', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'2', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'Approvol', 2, N'piriya_roj@live.com', 1, N'1', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'3', N'00003', N'EMP_TEST3 SURNAME_3', N'1', N'Checker', 1, N'priroj.n@tomastc.com', 1, N'1', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'4', N'admin', N'ADM Administrator', N'2', N'Approver', 2, N'pairoj.nj@gmail.com', 1, N'1', 0, N'00001', CAST(N'2024-07-10T11:13:56.000' AS DateTime), N'00001', CAST(N'2024-07-13T00:19:25.000' AS DateTime), N'0003', N'XXX3', N'P0003')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'5', N'00003', N'EMP_TEST3 SURNAME_3', N'1', N'Checker', 1, N'priroj.n@tomastc.com', 1, N'2', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'6', N'00003', N'EMP_TEST3 SURNAME_3', N'1', N'Checker', 1, N'priroj.n@tomastc.com', 1, N'3', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'7', N'00003', N'EMP_TEST3 SURNAME_3', N'1', N'Checker', 1, N'priroj.n@tomastc.com', 1, N'4', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'8', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'Approvol', 2, N'piriya_roj@live.com', 1, N'2', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_Approve] ([approve_id], [approve_userid], [approve_username], [approve_positionid], [approve_position], [approve_level], [approve_email], [approve_seq], [inspectiontype], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [linegroupid], [linename], [partnumber]) VALUES (N'9', N'00002', N'EMP_TEST2 SURNAME_2', N'2', N'Approvol', 2, N'piriya_roj@live.com', 1, N'3', 0, NULL, NULL, NULL, NULL, N'0001', N'XXX1', N'P0001')
GO
INSERT [dbo].[mst_ContentInput] ([input_type_id], [input_type_name], [flagdel]) VALUES (1, N'Input is set status', 0)
GO
INSERT [dbo].[mst_ContentInput] ([input_type_id], [input_type_name], [flagdel]) VALUES (2, N'Input is range number', 0)
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Error converting data type varchar to real.', CAST(N'2024-07-13T20:25:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-02T23:43:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-02T23:43:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-02T23:43:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-02T23:43:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-02T23:43:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:48.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:04:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:05:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:09:16.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:09:17.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:09:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:09:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:15:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:15:04.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:15:05.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:15:06.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:15:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:03.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:04.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:37.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:19:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:22:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:22:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:22:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:22:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:23:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:24:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:27:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:27:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:27:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:27:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:27:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:28:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:43.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:54.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:55.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:56.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:29:57.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:30:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:30:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:30:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:30:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:34:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:34:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:34:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-03T11:34:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:23.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:24.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:25.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-08T20:34:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:05.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:06.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T14:48:15.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T15:05:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T15:05:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T15:05:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T15:05:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-10T15:05:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:09:37.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:09:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:09:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:09:40.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:09:41.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:10:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:10:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:10:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:10:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T16:10:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T17:48:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T17:48:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T17:49:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T17:49:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T17:49:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:42.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:43.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:34:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:37:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:37:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:37:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:37:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-11T23:37:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:11:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:11:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:11:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:11:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:11:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:21:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:21:48.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:21:49.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:21:50.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T10:21:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:11:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:11:52.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:40.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:12:41.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ).
Incorrect syntax near ).', CAST(N'2024-07-15T11:17:48.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near ,.', CAST(N'2024-07-09T11:34:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Incorrect syntax near the keyword User.', CAST(N'2024-07-03T15:59:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name check_status.', CAST(N'2024-07-13T15:52:17.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name confirm_status.
Invalid column name confirm_notice.
Invalid column name confirm_date.
Invalid column name confirm_userid.', CAST(N'2024-07-03T20:11:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name confirm_status.
Invalid column name confirm_notice.
Invalid column name confirm_date.
Invalid column name confirm_userid.', CAST(N'2024-07-05T15:37:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inspectiontype.', CAST(N'2024-07-04T14:48:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inspectiontype.', CAST(N'2024-07-04T14:57:50.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inspectiontype.', CAST(N'2024-07-04T15:04:53.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:48:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:48:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:57:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:57:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:58:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T14:58:56.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid column name inst_status.', CAST(N'2024-07-04T15:01:23.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Invalid object name jigid.', CAST(N'2024-07-06T12:05:17.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-03T11:34:16.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-03T11:35:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-04T14:48:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-04T14:57:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-04T15:08:25.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-11T16:27:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'String or binary data would be truncated.
The statement has been terminated.', CAST(N'2024-07-13T15:52:17.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_EquipmentList. Cannot insert duplicate key in object dbo.EquipmentList.
The statement has been terminated.', CAST(N'2024-07-08T13:07:05.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_EquipmentList. Cannot insert duplicate key in object dbo.EquipmentList.
The statement has been terminated.', CAST(N'2024-07-08T13:15:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_EquipmentList. Cannot insert duplicate key in object dbo.EquipmentList.
The statement has been terminated.', CAST(N'2024-07-08T14:56:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_EquipmentList. Cannot insert duplicate key in object dbo.EquipmentList.
The statement has been terminated.', CAST(N'2024-07-11T16:43:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_EquipmentList. Cannot insert duplicate key in object dbo.EquipmentList.
The statement has been terminated.', CAST(N'2024-07-13T20:38:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T12:57:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T12:59:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T16:59:52.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T17:13:42.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T19:12:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T19:31:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T20:06:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T20:08:41.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T20:09:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_InspectionItem_1. Cannot insert duplicate key in object dbo.InspectionItem.
The statement has been terminated.', CAST(N'2024-07-09T20:10:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_JigMaster. Cannot insert duplicate key in object dbo.JigMaster.
The statement has been terminated.', CAST(N'2024-07-08T13:04:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_JigMaster. Cannot insert duplicate key in object dbo.JigMaster.
The statement has been terminated.', CAST(N'2024-07-08T13:04:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_JigMaster. Cannot insert duplicate key in object dbo.JigMaster.
The statement has been terminated.', CAST(N'2024-07-08T13:06:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_JigMaster. Cannot insert duplicate key in object dbo.JigMaster.
The statement has been terminated.', CAST(N'2024-07-08T13:15:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_LineGroupMaster. Cannot insert duplicate key in object dbo.LineGroupMaster.
The statement has been terminated.', CAST(N'2024-07-09T22:15:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_LineGroupMaster. Cannot insert duplicate key in object dbo.LineGroupMaster.
The statement has been terminated.', CAST(N'2024-07-09T22:15:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_LineGroupMaster. Cannot insert duplicate key in object dbo.LineGroupMaster.
The statement has been terminated.', CAST(N'2024-07-09T22:15:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_LineGroupMaster. Cannot insert duplicate key in object dbo.LineGroupMaster.
The statement has been terminated.', CAST(N'2024-07-11T17:16:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_MachineMaster. Cannot insert duplicate key in object dbo.MachineMaster.
The statement has been terminated.', CAST(N'2024-07-08T14:56:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_MachineMaster. Cannot insert duplicate key in object dbo.MachineMaster.
The statement has been terminated.', CAST(N'2024-07-11T16:43:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-10T12:09:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-10T12:10:55.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-10T12:11:04.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-12T23:54:06.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-12T23:56:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_Approve. Cannot insert duplicate key in object dbo.mst_Approve.
The statement has been terminated.', CAST(N'2024-07-13T00:19:25.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-02T23:43:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-02T23:43:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-02T23:43:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-02T23:43:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-02T23:43:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:48.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:04:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:05:23.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:09:16.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:09:17.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:09:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:09:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:09:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:15:04.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:15:05.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:15:06.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:15:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:03.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:04.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:05.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:37.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:19:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:22:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:22:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:22:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:22:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:22:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:23:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:03.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:24:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:27:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:27:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:27:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:27:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:27:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:23.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:28:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:43.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:54.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:55.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:56.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:57.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:29:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:30:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:30:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:30:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:30:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:30:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:34:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:34:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:34:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:34:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-03T11:34:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-04T14:48:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-04T14:48:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-04T14:57:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-04T14:57:52.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-04T15:04:54.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-05T15:37:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:18.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:19.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:20.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:21.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:22.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:23.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:24.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:25.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-08T20:34:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:06.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:07.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:08.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:14.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:15.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T14:48:16.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T15:05:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T15:05:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T15:05:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T15:05:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-10T15:05:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:09:37.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:09:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:09:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:09:40.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:09:41.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:10:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:10:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:10:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:10:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T16:10:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T17:48:58.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T17:48:59.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T17:49:00.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T17:49:01.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T17:49:02.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:42.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:43.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:34:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:37:26.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:37:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:37:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:37:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-11T23:37:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-13T20:38:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-13T20:38:37.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:11:09.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:11:10.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:11:11.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:11:12.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:11:13.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:21:48.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:21:49.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:21:50.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:21:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T10:21:52.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:11:51.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:11:52.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:11:53.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:32.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:33.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:34.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:35.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:36.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:38.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:39.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:40.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:41.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:12:42.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:27.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:28.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:29.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:30.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:31.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:44.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:45.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:46.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:47.000' AS DateTime))
GO
INSERT [dbo].[mst_ErrorLog] ([error_msg_sql], [error_log_datetime]) VALUES (N'Violation of PRIMARY KEY constraint PK_mst_ErrorLog. Cannot insert duplicate key in object dbo.mst_ErrorLog.
The statement has been terminated.', CAST(N'2024-07-15T11:17:48.000' AS DateTime))
GO
INSERT [dbo].[mst_Frequency] ([freqid], [freqname], [freqtype], [freqdate], [freqvalue], [flagdel]) VALUES (N'1', N'Daily', N'1 ', NULL, NULL, 0)
GO
INSERT [dbo].[mst_Frequency] ([freqid], [freqname], [freqtype], [freqdate], [freqvalue], [flagdel]) VALUES (N'2', N'1/W (fixed day of the week)', N'2 ', N'Thursday', NULL, 0)
GO
INSERT [dbo].[mst_Frequency] ([freqid], [freqname], [freqtype], [freqdate], [freqvalue], [flagdel]) VALUES (N'3', N'1/M (date specified)', N'3 ', NULL, N'15', 0)
GO
INSERT [dbo].[mst_Inspection] ([inspectionid], [inspectionname], [flagdel]) VALUES (N'1', N'Machine check', N'0         ')
GO
INSERT [dbo].[mst_Inspection] ([inspectionid], [inspectionname], [flagdel]) VALUES (N'2', N'Control chart', N'0         ')
GO
INSERT [dbo].[mst_Inspection] ([inspectionid], [inspectionname], [flagdel]) VALUES (N'3', N'Measuring Instrument', N'0         ')
GO
INSERT [dbo].[mst_Inspection] ([inspectionid], [inspectionname], [flagdel]) VALUES (N'4', N'4M Change', N'0         ')
GO
INSERT [dbo].[mst_Unit] ([unitid], [unitname], [flagdel]) VALUES (1, N'Mpa', 0)
GO
INSERT [dbo].[mst_Unit] ([unitid], [unitname], [flagdel]) VALUES (2, N'Sec', 0)
GO
INSERT [dbo].[mst_Unit] ([unitid], [unitname], [flagdel]) VALUES (3, N'Degree Celsius', 0)
GO
INSERT [dbo].[RootApproval] ([rootid], [seqno], [equid], [userid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [emp_approve_status], [emp_approve_seqno]) VALUES (N'1', 1, N'1', N'1', 0, NULL, NULL, NULL, NULL, N'Check', N'1')
GO
INSERT [dbo].[RootApproval] ([rootid], [seqno], [equid], [userid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [emp_approve_status], [emp_approve_seqno]) VALUES (N'1', 2, N'2', N'2', 0, NULL, NULL, NULL, NULL, N'Check', N'2')
GO
INSERT [dbo].[RootApproval] ([rootid], [seqno], [equid], [userid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [emp_approve_status], [emp_approve_seqno]) VALUES (N'1', 3, N'3', N'3', 0, NULL, NULL, NULL, NULL, N'Approve', N'1')
GO
INSERT [dbo].[RootApproval] ([rootid], [seqno], [equid], [userid], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime], [emp_approve_status], [emp_approve_seqno]) VALUES (N'1', 4, N'4', N'4', 0, NULL, NULL, NULL, NULL, N'Approve', N'2')
GO
SET IDENTITY_INSERT [dbo].[Users] ON 
GO
INSERT [dbo].[Users] ([userid], [usercode], [username], [password], [firstname], [lastname], [position], [emailaddress], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (1, N'00001', N'emp1', N'1234', N'EMP_TEST1', N'SURNAME_1', N'Inspector', N'pairoj.nj@gmail.com', 0, NULL, CAST(N'2024-07-10T14:39:37.000' AS DateTime), N'00001', NULL)
GO
INSERT [dbo].[Users] ([userid], [usercode], [username], [password], [firstname], [lastname], [position], [emailaddress], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (2, N'00002', N'emp2', N'1234', N'EMP_TEST2', N'SURNAME_2', N'Approvol', N'pairoj.nj@gmail.com', 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[Users] ([userid], [usercode], [username], [password], [firstname], [lastname], [position], [emailaddress], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (3, N'00003', N'emp3', N'1234', N'EMP_TEST3', N'SURNAME_3', N'Checker', N'pairoj.nj@gmail.com', 0, NULL, NULL, NULL, NULL)
GO
INSERT [dbo].[Users] ([userid], [usercode], [username], [password], [firstname], [lastname], [position], [emailaddress], [flagdel], [create_user], [create_datetime], [update_user], [update_datetime]) VALUES (4, N'admin', N'admin', N'1234', N'ADM', N'Administrator', N'Inspector', N'pairoj.nj@gmail.com', 0, NULL, NULL, NULL, NULL)
GO
SET IDENTITY_INSERT [dbo].[Users] OFF
GO
