﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Collections;
using System.Globalization;
using System.Web.Caching;
using System.IO;
using System.Threading;
using Microsoft.Reporting.WebForms;


namespace CheckSheet.setting
{
    public partial class rptInspectionItemsCSV : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {




            if (!Page.IsPostBack)
            {

                try
                {
                    _genReport(Page.Request["filter"].ToString(), Page.Request["item"].ToString());
                }
                catch { };


            }
        }








        private void _genReport(string filter, string item)
        {

            // Set the processing mode for the ReportViewer to Local
            rptview.ProcessingMode = ProcessingMode.Local;
            LocalReport rep = rptview.LocalReport;
            rep.ReportPath = "setting/rptInspectionItemsCSV.rdlc";

            // Create a report data source for the sales order data
            ReportDataSource dsMaintenanceDS = new ReportDataSource();
            dsMaintenanceDS.Name = "dsRpt";
            DataTable dt = _genDataSource(filter);
            dsMaintenanceDS.Value = dt;
            rep.DataSources.Clear();
            string filpara = string.Empty;
            if (item.IndexOf('|') != -1)
            {
                string[] arr = item.Split('|');
               
                if (arr[0].Length > 0)
                {
                    filpara = filpara + "  Line group id" + arr[0];

                }
                if (arr[1].Length > 0)
                {
                    filpara = filpara + "  Part number" + arr[1];

                }
          


            }

            ReportParameter param1 = new ReportParameter("hdpara", filpara);
            rep.SetParameters(new ReportParameter[] { param1 });


            rep.DataSources.Add(dsMaintenanceDS);
            rep.Refresh();


            //}
        }
        private DataTable _genDataSource(string filter)
        {
            DataTable dt = new DataTable();



            string sqlquery = string.Empty;
            using (FcSql.Function fc = new FcSql.Function())
            {





                string strquery = string.Empty;
                strquery = string.Format("select a.equid, b.linegroupid,b.linename,b.partnumber,c.machineid,c.machinename,e.inspectionid, e.inspectionname,d.* from EquipmentList as a inner join LineGroupMaster as b on  a.linegroupid=b.linegroupid inner join machineMaster as c on a.machineid=c.machineid inner join InspectionItem as d on a.equid=d.equid inner join mst_Inspection as e on d.inspection_type=e.inspectionid   {0} Order by d.Create_datetime ", filter);
                dt = fc.SQL_DataTable(strquery.ToString());
                fc.closeconnection();
                foreach (DataRow dr in dt.Rows)
                {

                    try
                    {
                        if (dr["Create_user"].ToString().Length > 0)
                        {
                            dr["Create_user"] = dr["Create_user"].ToString() + ":" + clsControlUI.getEmpName(dr["Create_user"].ToString());
                        }

                    }
                    catch { };
                    try
                    {
                        if (dr["Update_user"].ToString().Length > 0)
                        {
                            dr["Update_user"] = dr["Update_user"].ToString() + ":" + clsControlUI.getEmpName(dr["Update_user"].ToString());
                        }

                    }
                    catch { };
                  
                }






            }
            return dt;





        }


    }
}