﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data;
using System.Collections;
using System.Globalization;
using System.Web.Caching;
using System.IO;
using System.Threading;
using Microsoft.Reporting.WebForms;

namespace CheckSheet.approve
{
    public partial class rptMachineCSV : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {


            if (!Page.IsPostBack)
            {

                try
                {
                    _genReport(Page.Request["filter"].ToString(), Page.Request["item"].ToString());
                }
                catch { };


            }
        }








        private void _genReport(string filter, string item)
        {

            // Set the processing mode for the ReportViewer to Local
            rptview.ProcessingMode = ProcessingMode.Local;
            LocalReport rep = rptview.LocalReport;
            rep.ReportPath = "approve/rptMachineCSV.rdlc";

            // Create a report data source for the sales order data
            ReportDataSource dsMaintenanceDS = new ReportDataSource();
            dsMaintenanceDS.Name = "dsRpt";
            DataTable dt = _genDataSource(filter);
            dsMaintenanceDS.Value = dt;
            rep.DataSources.Clear();
            string filpara = string.Empty;
            if (item.IndexOf('|') != -1)
            {
                string[] arr = item.Split('|');
                if (arr[0].Length > 0)
                {

                    filpara = "Doc No." + arr[0];

                }
                if (arr[1].Length > 0)
                {
                    filpara = filpara + "  Period date." + arr[1] + " to " + arr[2];

                }
                if (arr[3].Length > 0)
                {
                    filpara = filpara + "  Line group id" + arr[3];

                }
                if (arr[4].Length > 0)
                {
                    filpara = filpara + "  Part number" + arr[4];

                }
                if (arr[5].Length > 0)
                {
                    filpara = filpara + "  Machine " + arr[5] + ":" + arr[6];

                }


            }

            ReportParameter param1 = new ReportParameter("hdpara", filpara);
            rep.SetParameters(new ReportParameter[] { param1 });


            rep.DataSources.Add(dsMaintenanceDS);
            rep.Refresh();


            //}
        }
        private DataTable _genDataSource(string filter)
        {
            DataTable dt = new DataTable();



            string sqlquery = string.Empty;
            using (FcSql.Function fc = new FcSql.Function())
            {





                string strquery = string.Empty;
                strquery = string.Format("select d.linegroupid,d.linename,d.partnumber,b.machineid,c.machinename,a.* from InspectionInput as a inner join EquipmentList as b on a.equid=b.equid inner join MachineMaster as c on b.machineid=c.machineid inner join LineGroupMaster as d on b.linegroupid=d.linegroupid and b.partnumber=d.partnumber  Where inspectiontype='1' and a.flagdel=0  {0} Order by a.Create_datetime ", filter);
                dt = fc.SQL_DataTable(strquery.ToString());
                fc.closeconnection();
                foreach (DataRow dr in dt.Rows)
                {

                    try
                    {
                        if (dr["Create_user"].ToString().Length > 0)
                        {
                            dr["Create_user"] = dr["Create_user"].ToString() + ":" + clsControlUI.getEmpName(dr["Create_user"].ToString());
                        }

                    }
                    catch { };
                    try
                    {
                        if (dr["Update_user"].ToString().Length > 0)
                        {
                            dr["Update_user"] = dr["Update_user"].ToString() + ":" + clsControlUI.getEmpName(dr["Update_user"].ToString());
                        }

                    }
                    catch { };
                    try
                    {
                        if (dr["check1_userid"].ToString().Length > 0)
                        {
                            dr["check1_userid"] = dr["check1_userid"].ToString() + ":" + clsControlUI.getEmpName(dr["check1_userid"].ToString());
                        }

                    }
                    catch { };
                    try
                    {
                        if (dr["check2_userid"].ToString().Length > 0)
                        {
                            dr["check2_userid"] = dr["check2_userid"].ToString() + ":" + clsControlUI.getEmpName(dr["check2_userid"].ToString());
                        }

                    }
                    catch { };
                    try
                    {
                        if (dr["approve1_userid"].ToString().Length > 0)
                        {
                            dr["approve1_userid"] = dr["approve1_userid"].ToString() + ":" + clsControlUI.getEmpName(dr["approve1_userid"].ToString());
                        }
                    }
                    catch { };
                    try
                    {
                        if (dr["approve2_userid"].ToString().Length > 0)
                        {
                            dr["approve2_userid"] = dr["approve2_userid"].ToString() + ":" + clsControlUI.getEmpName(dr["approve2_userid"].ToString());
                        }


                    }
                    catch { };

                    if(dr["inspectiondate"].ToString().Length>0)
                    {
                        try
                        {
                            dr["inspectiondate"] = DateTime.Parse(dr["inspectiondate"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["Create_datetime"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["Create_datetime"] = DateTime.Parse(dr["Create_datetime"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["Update_datetime"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["Update_datetime"] = DateTime.Parse(dr["Update_datetime"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["check1_date"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["check1_date"] = DateTime.Parse(dr["check1_date"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["approve1_date"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["approve1_date"] = DateTime.Parse(dr["approve1_date"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["check2_date"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["check2_date"] = DateTime.Parse(dr["check2_date"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                    if (dr["approve2_date"].ToString().Length > 0)
                    {
                        try
                        {
                            dr["approve2_date"] = DateTime.Parse(dr["approve2_date"].ToString()).ToString("yyyy-MM-dd HH:mm:ss", new CultureInfo("en-US"));
                        }
                        catch { };
                    }
                }






            }
            return dt;





        }


    }
}