﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Mainmenu.aspx.cs" Inherits="CheckSheet.Mainmenu" %>
<!DOCTYPE html>
<html lang="en" class="no-js">

    <head>

        <meta charset="utf-8">
        <title>Menu Check Sheet Application</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <meta name="description" content="">
        <meta name="author" content="">

        <!-- CSS -->
        <link rel="stylesheet" href="fonts/stylesheet.css?v=002" type="text/css" charset="utf-8" />
        <link rel="stylesheet" href="css/inputlogin.css?v=01"/>
        <script src="Scripts/jquery-1.7.2.min.js"></script>
        <script src="Scripts/inputlogin.js?v=1"></script>
        <script type="text/javascript" src="Script/crypto.js?v=01112023"></script> 
        <script src="Scripts/sweetalert2.all.min.js"></script>
        <link rel="stylesheet" type="text/css" href="css/sweetalert2.min.css"/> 
       
        <!-- HTML5 shim, for IE6-8 support of HTML5 elements -->
        <!--[if lt IE 9]>
            <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
        <![endif]-->
        <script>

            $(document).ready(function () {

                let userposition = $("#lblposition").html();
          
                if (userposition.toLowerCase().indexOf('inspector') != -1 || userposition.toLowerCase().indexOf('inspection') != -1)
                {
                    $("#btninput").show();
                    $("#btnresult").hide();

                }
                else
                {
                    $("#btninput").hide();
                    $("#btnresult").show();

                }

                checkadmin();




            });
            function checkadmin()
            {
                let username = $("#lbluserid").html();
                $.ajax({
                    type: "POST",
                    url: "Mainmenu.aspx/getadmin_data",
                    data: '{username:"' + username + '"}',
                    contentType: "application/json; charset=utf-8",
                    dataType: "json",
                    success: function (response) {
                        
                        if(response.d=="A")
                        {
                            $("#btnmaster").show();

                        }
                        else
                        {
                            $("#btnmaster").hide();

                        }


                    },
                    failure: function (response) {
                        alert(response.d);
                    },
                    error: function (response) {
                        alert(response.d);
                    }
                });

            }
            function linkpage(page) {

                window.location.href = page;


            }
            function exit() {         

                swal({
                    title: 'Are you sure?',
                    text: "Do you want to exit application!",
                    type: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#3085d6',
                    cancelButtonColor: '#d33',
                    confirmButtonText: 'Yes, Exit now!'
                }).then(function (result) {
                    if (result.value) {
                        swal(
                          'Exit!',
                          'Go to login page.',
                          'success'
                        );
                        
                        setTimeout(function () {
                            window.location.href = "Default";

                        }, 500);
                    } else {
                        return false;
                    }
                })

            }

        </script>

  
 </head>

    <body>
<div class="session">
    <div class="left">
      <?xml version="1.0" encoding="UTF-8"?>
      <svg enable-background="new 0 0 300 302.5" version="1.1" viewBox="0 0 300 302.5" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
<style type="text/css">
	.st01{fill:#fff;}
</style>
				
</svg>  
        
               <div class="form-row">
                <div class="frmrow">
                    <span>
                    <label>
                    <img src="image/userid.png" width="30">
                    </label>
                    <label style="margin-top:-1px;position:absolute;width:100%;font-size:10px;font-weight:900">User ID:
                    <asp:Label ID="lbluserid" style="display:inline-block;font-size:10px;" Font-Bold="true" runat="server" Text="xxxx"></asp:Label><br />
                     
                    <asp:Label ID="lblfullname" Style ="display:inline-block;font-size:10px;"  Font-Bold="true" runat="server" Text="xxxx  xxxxx"></asp:Label><br />
                    Position:
                    <asp:Label ID="lblposition" style="display:inline-block;font-size:10px;" Font-Bold="true"   runat="server" Text="xxxxxxxxx"></asp:Label>
                    </label>

                    </span>

                    
                </div>
             </div>

    
    </div>
    <form runat="server" class="log-in" autocomplete="off"> 


      <p><span style="color:dodgerblue;font-weight:900;">Menu select</span></p>
             <asp:Button ID="btninput" runat="server" Width="100%" Text="Check and input" style="margin-top:20px;" CssClass="button"   OnClientClick="javascript:linkpage('checkinput/Machine_condition_check');return false;"/>
             <asp:Button ID="btnresult" runat="server" Width="100%" Text="Check Result/Approve"  style="margin-top:20px;" CssClass="button"  OnClientClick="javascript:linkpage('CheckItemResultSelect');return false;"/>
             <asp:Button ID="btnmaster" runat="server" Width="100%" Text="Master setting"  style="margin-top:20px;" CssClass="button" OnClientClick="javascript:linkpage('setting/Menusetting');return false;"/>
             <asp:Button ID="btnreport" runat="server" Width="100%" Text="Report"  style="margin-top:20px;" CssClass="button" OnClientClick="javascript:linkpage('setting/rptReport_filter');return false;"/>
             <asp:Button ID="btnlogout" runat="server" Width="100%" Text="Exit"  style="margin-top:20px;" CssClass="button"  BackColor="Red" ForeColor="White" OnClientClick="javascript:exit();return false;"/>

   </form>
            

  </div>
</body>
</html>