﻿Imports Bt
Imports System.Runtime.InteropServices
Public Class user_setting
    Private ip As String() = {"192", "168", "100", "1"}
    'ボタン配列
    Private textlist() As TextBox
    ' Inquiry件数
    Shared m_devnum As UInt32 = 0
    '---------------------------------------------------------------------------------
    ' フォームロード時の設定
    '---------------------------------------------------------------------------------
    Private Sub user_setting_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Try

            Call change.QVGAtoVGA(Me)
            Me.FormBorderStyle = FormBorderStyle.None

            'コントロール配列の作成
            Me.textlist = New TextBox() {Me.iptext1, Me.iptext2, Me.iptext3, Me.iptext4}
            For i As Integer = 0 To 3
                AddHandler textlist(i).GotFocus, AddressOf textlist_focus
                AddHandler textlist(i).LostFocus, AddressOf textlist_lostfocus
                AddHandler textlist(i).KeyDown, AddressOf textlist_keydown
            Next


            '照明設定読み込み
            Dim idSet As UInt32 = 0
            Dim ret As Int32 = 0
            Dim disp As [String] = ""
            Dim ulDataSet As UInt32 = 0
            Dim pValueGet As New IntPtr()
            Dim data As UInt32 = 0



            '照明設定ON/OFF
            If strHttypeDef <> "BT-W85" And strHttypeDef <> "BT-W150" And strHttypeDef <> "BT-W75" And strHttypeDef <> "BT-W155" Then
                light_combo.Enabled = False
            Else
                '照明
                If status(3) = "0" Then
                    light_combo.Checked = False
                Else
                    light_combo.Checked = True
                End If
            End If

            '小サイズ設定ON/OFF
            If strHttypeDef <> "BT-W150" Then
                small_combo.Enabled = False
            Else
                '小サイズ
                If status(4) = "7" Then
                    small_combo.Checked = True
                Else
                    small_combo.Checked = False
                End If
            End If


            If status(5) = "0" Then
                ComboBox1.Text = "CR"
            ElseIf status(5) = "1" Then
                ComboBox1.Text = "CR+LF"
            ElseIf status(5) = "2" Then
                ComboBox1.Text = "LF"
            ElseIf status(5) = "3" Then
                ComboBox1.Text = "Tab"
            ElseIf status(5) = "4" Then
                ComboBox1.Text = "なし"
            Else
                ComboBox1.Text = "CR"
            End If
            init_set()

            'IPアドレス設定
            ip = status(1).Split(".")

            If Integer.Parse(ip(0)) > 223 Or Integer.Parse(ip(0)) < 1 Then
                iptext1.Text = "192"
            Else
                iptext1.Text = ip(0)
            End If

            If Integer.Parse(ip(1)) > 255 Or Integer.Parse(ip(1)) < 0 Then
                iptext2.Text = "168"
            Else
                iptext2.Text = ip(1)
            End If

            If Integer.Parse(ip(2)) > 255 Or Integer.Parse(ip(2)) < 0 Then
                iptext3.Text = "100"
            Else
                iptext3.Text = ip(2)
            End If
            If Integer.Parse(ip(3)) > 254 Or Integer.Parse(ip(3)) < 1 Then
                iptext4.Text = "10"
            Else
                iptext4.Text = ip(3)
            End If


            'ポート番号設定
            If Integer.Parse(status(2)) < 1024 Or Integer.Parse(status(2)) > 65535 Then
                port_text.Text = "8501"
            Else
                port_text.Text = status(2)
            End If

            'ポート番号設定
            If Integer.Parse(status(6)) < 1 Or Integer.Parse(status(6)) > 65534 Then
                dm_text.Text = "11000"
            Else
                dm_text.Text = status(6)
            End If

            'ステータスバー非表示
            b_wedge.Visible = False
        Catch
            status(0) = "1"

            status(1) = "192.168.100.10"
            ip(0) = "192"
            ip(1) = "168"
            ip(2) = "100"
            ip(3) = "1"
            iptext1.Text = ip(0)
            iptext2.Text = ip(1)
            iptext3.Text = ip(2)
            iptext4.Text = ip(3)
            status(2) = "8501"
            port_text.Text = status(2)
            status(6) = "11000"
            dm_text.Text = status(6)

            'ステータスバー非表示
            b_wedge.Visible = False
        End Try
    End Sub
    Private Sub init_set()

        host_label.Visible = True
        iplabel1.Visible = True
        iplabel2.Visible = True
        iplabel3.Visible = True
        iptext1.Visible = True
        iptext2.Visible = True
        iptext3.Visible = True
        iptext4.Visible = True
        port_text.Visible = True
        portno_label.Visible = True
        iptext1.Focus()
        iptext1.SelectAll()
    End Sub
    Private Function get_textfocus(ByVal sender As System.Object)
        'コントロール配列の要素番号を取得
        Dim i As Integer
        For i = 0 To textlist.Length - 1
            If textlist(i).Equals(sender) Then
                Exit For
            End If
        Next
        Return (i)
    End Function
    '---------------------------------------------------------------------------------
    ' キーダウン時の設定
    '---------------------------------------------------------------------------------
    Private Sub textlist_keydown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs)
        Try
            If e.KeyCode = Keys.Enter Then
                Dim i As Integer = get_textfocus(sender)
                If IsNumeric(textlist(i).Text) = False Then
                    ng()
                    textlist(i).Text = ip(i)
                    textlist(i).SelectAll()
                    Return
                End If

                'カーソル移動
                If i = 3 Then
                    port_text.Focus()
                Else
                    textlist(i + 1).Focus()
                End If
            End If
        Catch
        End Try
    End Sub

    Private Sub port_text_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles port_text.KeyDown
        If e.KeyCode = Keys.Enter Then
            dm_text.Focus()
        End If
    End Sub

    Private Sub dm_text_GotFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles dm_text.GotFocus
        'キー入力設定
        SysLib.Display.btSetKeyCharacter(LibDef.BT_KEYINPUT_DIRECT)
        dm_text.ForeColor = Color.White
        dm_text.BackColor = Color.Orange
        dm_text.SelectAll()
    End Sub

    Private Sub dm_text_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles dm_text.KeyDown
        If e.KeyCode = Keys.Enter Then
            end_button.Focus()
        End If
    End Sub

    Private Sub textlist_focus(ByVal sender As System.Object, ByVal e As System.EventArgs)
        'キー入力設定
        SysLib.Display.btSetKeyCharacter(LibDef.BT_KEYINPUT_DIRECT)
        Dim i As Integer = get_textfocus(sender)
        textlist(i).ForeColor = Color.White
        textlist(i).BackColor = Color.Orange
        textlist(i).SelectAll()
    End Sub

    Private Sub port_text_GotFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles port_text.GotFocus
        'キー入力設定
        SysLib.Display.btSetKeyCharacter(LibDef.BT_KEYINPUT_DIRECT)
        port_text.ForeColor = Color.White
        port_text.BackColor = Color.Orange
        port_text.SelectAll()
    End Sub

    Private Sub end_button_GotFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles end_button.GotFocus
        end_button.ForeColor = Color.White
        end_button.BackColor = Color.Green
    End Sub

    Private Sub textlist_lostfocus(ByVal sender As System.Object, ByVal e As System.EventArgs)
        Dim i As Integer = get_textfocus(sender)

        '数値チェック
        If IsNumeric(textlist(i).Text) = False Then
            ng()
            textlist(i).Text = ip(i)
            textlist(i).SelectAll()
            textlist(i).Focus()
            Return
        End If
        '小数
        If textlist(i).Text.IndexOf(".") <> -1 Then
            ng()
            textlist(i).Text = ip(i)
            textlist(i).SelectAll()
            textlist(i).Focus()
            Return
        End If
        '全角チェック
        If textlist(i).Text.Length <> System.Text.Encoding.GetEncoding("SHIFT_JIS").GetByteCount(textlist(i).Text) Then
            ng()
            textlist(i).Text = ip(i)
            textlist(i).SelectAll()
            textlist(i).Focus()
            Return
        End If


        If i = 0 Then
            If textlist(i).Text > 223 Or textlist(i).Text < 1 Then
                ng()
                MessageBox.Show("Set IPaddress range 1-223 in 1 octet.", "Alert", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                textlist(i).Text = ip(i)
                textlist(i).SelectAll()
                textlist(i).Focus()
                Return
            End If
            ip(i) = Integer.Parse(textlist(i).Text)
        ElseIf i = 3 Then
            If textlist(i).Text > 254 Or textlist(i).Text < 1 Then
                ng()
                MessageBox.Show("Set IPaddress range 1-254 in 4 octet.", "Alert", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                textlist(i).Text = ip(i)
                textlist(i).SelectAll()
                textlist(i).Focus()
                Return
            End If
            ip(i) = Integer.Parse(textlist(i).Text)
        Else
            If textlist(i).Text > 255 Or textlist(i).Text < 0 Then
                ng()
                MessageBox.Show("Set IPaddress range 0-255 in 2, 3 octet.", "Alert", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                textlist(i).Text = ip(i)
                textlist(i).SelectAll()
                textlist(i).Focus()
                Return
            End If
            ip(i) = Integer.Parse(textlist(i).Text)
        End If

        textlist(i).ForeColor = Color.Black
        textlist(i).BackColor = Color.White
    End Sub

    Private Sub port_text_LostFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles port_text.LostFocus

        If IsNumeric(port_text.Text) = False Then
            ng()
            port_text.Text = status(2)
            port_text.SelectAll()
            port_text.Focus()
            Return
        End If
        '小数
        If port_text.Text.IndexOf(".") <> -1 Then
            ng()
            port_text.Text = status(2)
            port_text.SelectAll()
            port_text.Focus()
            Return
        End If
        '全角チェック
        If port_text.Text.Length <> System.Text.Encoding.GetEncoding("SHIFT_JIS").GetByteCount(port_text.Text) Then
            ng()
            port_text.Text = status(2)
            port_text.SelectAll()
            port_text.Focus()
            Return
        End If
        If port_text.Text > 65535 Or port_text.Text < 1024 Then
            ng()
            MessageBox.Show("Set Port No range 1024-65535.", "Alert", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
            port_text.Text = status(2)
            port_text.SelectAll()
            port_text.Focus()
            Return
        End If
        status(2) = UInt32.Parse(port_text.Text)

        port_text.ForeColor = Color.Black
        port_text.BackColor = Color.White
    End Sub


    Private Sub end_button_LostFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles end_button.LostFocus
        end_button.ForeColor = Color.Black
        end_button.BackColor = Color.PaleGreen
    End Sub

    Private Sub end_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles end_button.Click
        end_status()
    End Sub


    Private Sub radio_wlan_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
        status(0) = "1"
        init_set()
    End Sub

    Private Sub user_setting_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyDown
        If e.KeyCode = Keys.F1 Then
            end_status()
        ElseIf e.KeyCode = Keys.Back Then
        End If
    End Sub
    Private Sub end_status()

        '読み取り制御
        ScanLib.Control.btScanEnable()

        status(1) = ip(0) & "." & ip(1) & "." & ip(2) & "." & ip(3)
        Dim sw As New System.IO.StreamWriter(pathcheck + "\" + setting_file, False, System.Text.Encoding.GetEncoding("Shift_Jis"))
        'Bluetooth接続
        sw.Write(status(0) + vbCrLf)
        'ホストIP
        sw.Write(status(1) + vbCrLf)
        'ポート番号
        sw.Write(status(2) + vbCrLf)
        'ライト
        sw.Write(status(3) + vbCrLf)
        '小サイズ
        sw.Write(status(4) + vbCrLf)
        'ターミネータ
        If ComboBox1.Text = "CR" Then
            status(5) = "0"
            terminator = Microsoft.VisualBasic.ChrW(Keys.Return)
        ElseIf ComboBox1.Text = "CR+LF" Then
            status(5) = "1"
            terminator = Microsoft.VisualBasic.ChrW(Keys.Return) + Microsoft.VisualBasic.ChrW(Keys.LineFeed)
        ElseIf ComboBox1.Text = "LF" Then
            status(5) = "2"
            terminator = Microsoft.VisualBasic.ChrW(Keys.LineFeed)
        ElseIf ComboBox1.Text = "Tab" Then
            status(5) = "3"
            terminator = Microsoft.VisualBasic.ChrW(Keys.Tab)
        ElseIf ComboBox1.Text = "None" Then
            status(5) = "4"
            terminator = ""
        Else
            status(5) = "0"
            terminator = Microsoft.VisualBasic.ChrW(Keys.Return)
        End If
        sw.Write(status(5) + vbCrLf)

        'DM番号 //##
        sw.Write(status(6) + vbCrLf)

        'ストリームを閉じる
        sw.Close()

        keyset(LibDef.BT_KEY_ALL)
        'メニューに戻る
        b_wedge.Visible = True
        Me.Close()
        Me.Dispose()
    End Sub


    Private Sub light_combo_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles light_combo.CheckStateChanged
        '照明
        If light_combo.Checked = True Then
            light_setting(1)
            status(3) = "1"
        Else
            light_setting(0)
            status(3) = "0"
        End If
    End Sub

    Private Sub small_combo_CheckStateChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles small_combo.CheckStateChanged
        '小サイズ
        If small_combo.Checked = True Then
            status(4) = "7"
            small_setting(7, 3)
        Else
            status(4) = "3"
            small_setting(3, 1)
        End If
    End Sub

    Private Sub dm_text_LostFocus(ByVal sender As Object, ByVal e As System.EventArgs) Handles dm_text.LostFocus

        If IsNumeric(dm_text.Text) = False Then
            ng()
            dm_text.Text = status(6)
            dm_text.SelectAll()
            dm_text.Focus()
            Return
        End If
        '小数
        If dm_text.Text.IndexOf(".") <> -1 Then
            ng()
            dm_text.Text = status(6)
            dm_text.SelectAll()
            dm_text.Focus()
            Return
        End If
        '全角チェック
        If dm_text.Text.Length <> System.Text.Encoding.GetEncoding("SHIFT_JIS").GetByteCount(dm_text.Text) Then
            ng()
            dm_text.Text = status(6)
            dm_text.SelectAll()
            dm_text.Focus()
            Return
        End If
        If dm_text.Text > 65534 Or dm_text.Text < 1 Then
            ng()
            MessageBox.Show("Set Port No range 1-65534.", "Alert", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
            dm_text.Text = status(6)
            dm_text.SelectAll()
            dm_text.Focus()
            Return
        End If
        status(6) = UInt32.Parse(dm_text.Text)

        dm_text.ForeColor = Color.Black
        dm_text.BackColor = Color.White

    End Sub
End Class