﻿Module change

    '// VGA画面をQVGAに変換する
    '// 各FormのLoad処理に追加する

    Public Sub VGAtoQVGA(ByRef top As Control)
        Dim h As Integer, w As Integer, hh As Integer, ww As Integer, x As Integer, y As Integer
        Dim ss As Single

        h = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Height
        w = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width

        '// QVGAであれば、変換処理をおこなう
        If w = 240 Then

            '//////////////////////////////////////////////////////////////////////
            '// フォーム内の部品の変換処理
            '//////////////////////////////////////////////////////////////////////

            Dim items As Control() = GetAllControls(top)
            For Each item As Control In items

                '// 座標、幅＆高さ
                ww = (item.Width * w) / 480
                x = (item.Left * w) / 480
                hh = (item.Height * h) / 640
                y = item.Top * h / 640

                item.Width = ww
                item.Left = x
                item.Height = hh
                item.Top = y

                '// フォントサイズ
                If item.GetType.Name = "PictureBox" Or item.GetType.Name = "Panel" Or item.GetType.Name = "TabPage" Then
                Else
                    ss = (item.Font.Size * h) / 640
                    item.Font = New Font(item.Font.Name, ss, item.Font.Style)
                End If

            Next


            '//////////////////////////////////////////////////////////////////////
            '// フォーム自体の変換
            '//////////////////////////////////////////////////////////////////////

            '// 座標、幅＆高さ
            ww = (top.Width * w) / 480
            x = (top.Left * w) / 480
            hh = (top.Height * h) / 640
            y = top.Top * h / 640
            ss = (top.Font.Size * h) / 640

            top.Width = ww
            top.Left = x
            top.Height = hh
            top.Top = y

            '// フォントサイズ
            top.Font = New Font(top.Font.Name, ss, top.Font.Style)


        End If

    End Sub


    Public Sub QVGAtoVGA(ByRef top As Control)
        Dim h As Integer, w As Integer, hh As Integer, ww As Integer, x As Integer, y As Integer
        Dim ss As Single

        h = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Height
        w = System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width

        '// VGAであれば、変換処理をおこなう
        If w = 480 Then

            '//////////////////////////////////////////////////////////////////////
            '// フォーム内の部品の変換処理
            '//////////////////////////////////////////////////////////////////////

            Dim items As Control() = GetAllControls(top)
            For Each item As Control In items

                '// 座標、幅＆高さ
                ww = (item.Width * w) / 240
                x = (item.Left * w) / 240
                hh = (item.Height * h) / 320
                y = item.Top * h / 320

                item.Width = ww
                item.Left = x
                item.Height = hh
                item.Top = y

                '// フォントサイズ
                If item.GetType.Name = "PictureBox" Or item.GetType.Name = "Panel" Or item.GetType.Name = "TabPage" Then
                Else
                    ss = (item.Font.Size * h) / 320
                    item.Font = New Font(item.Font.Name, ss, item.Font.Style)
                End If

            Next

            '//////////////////////////////////////////////////////////////////////
            '// フォーム自体の変換
            '//////////////////////////////////////////////////////////////////////

            '// 座標、幅＆高さ
            ww = (top.Width * w) / 240
            x = (top.Left * w) / 240
            hh = (top.Height * h) / 320
            y = top.Top * h / 320
            ss = (top.Font.Size * h) / 320

            top.Width = ww
            top.Left = x
            top.Height = hh
            top.Top = y

            '// フォントサイズ
            top.Font = New Font(top.Font.Name, ss, top.Font.Style)
        End If

    End Sub



    Public Function GetAllControls(ByVal top As Control) As Control()
        Dim buf As New ArrayList()
        For Each c As Control In top.Controls
            buf.Add(c)
            buf.AddRange(GetAllControls(c))
        Next
        Return DirectCast(buf.ToArray(GetType(Control)), Control())
    End Function

End Module
