﻿Imports Bt
Imports Bt.SysLib
Imports System.Runtime.InteropServices

Module common

    '色の設定
    Public online_backcolor = Color.PeachPuff
    Public offline_backcolor = Color.Gray
    Public Const set_key_all As UInt32 = LibDef.BT_KEY_ALL 'キー入力許可
    Public Const set_key_disable As UInt32 = LibDef.BT_KEY_DISABLEALL 'キー入力不許可
    Public pathcheck As String     'パス取得
    Public modulescheck As System.Reflection.Module() 'パス取得

    'ホストIP 
    Public status As String() = {"1", "192.168.100.10", "8501", "1", "3", "0", "11000"}
    Public Const setting_file As String = "keyboardwedge.ini" '1行目 通信経路 0:Bluetooth 1:無線　2行目 ホストIP(無線) 3行目 ポート番号 4行目 照明 5行目 小サイズ 6行目 ターミネータ　0:CR 1:CR+LR 2:LF 3:Tab 4:なし
    Public terminator As String = Microsoft.VisualBasic.ChrW(Keys.Return)
    '機種
    Public strHttypeDef As [String] = ""
    '-----------------------------------------------------------
    ' キー設定
    '-----------------------------------------------------------
    Public Sub keyset(ByVal keycode As Int32)
        Dim ret As Int32 = 0
        Dim disp As [String] = ""

        ret = SysLib.Device.btSetKeyEnable(keycode)
        If ret <> LibDef.BT_OK Then
            disp = "btSetKeyEnable error ret[" & ret & "]"
            MessageBox.Show(disp, "Error")
        End If
    End Sub

    Public Sub ng()
        Dim ret As Int32 = 0
        Dim disp As [String] = ""

        Dim stBuzzerSet As New LibDef.BT_BUZZER_PARAM()
        ' ブザー制御構造体(Set)
        stBuzzerSet.dwOn = 100
        ' 鳴動時間[ms] （1～5000）
        stBuzzerSet.dwOff = 100
        ' 停止時間[ms] （0～5000）
        stBuzzerSet.dwCount = 2
        ' 鳴動回数[回] （0～100）
        stBuzzerSet.bTone = 1
        ' 音階 （1～16）
        stBuzzerSet.bVolume = 3
        Dim stLedSet As New LibDef.BT_LED_PARAM()
        ' LED制御構造体(Set)
        stLedSet.dwOn = 100
        ' 鳴動時間[ms] （1～5000）
        stLedSet.dwOff = 100
        ' 停止時間[ms] （0～5000）
        stLedSet.dwCount = 2
        ' 鳴動回数[回] （0～100）
        stLedSet.bColor = LibDef.BT_LED_RED
        Dim stVibSet As New LibDef.BT_VIBRATOR_PARAM()
        ' バイブレータ制御構造体(Set)
        ' 「500msオン、500msオフ」を3回繰り返す設定
        stVibSet.dwOn = 100
        ' 鳴動時間[ms] （1～5000）
        stVibSet.dwOff = 100
        ' 停止時間[ms] （0～5000）
        stVibSet.dwCount = 2
        ' 鳴動回数[回] （0～100）

        Try
            ' btBuzzer 鳴動
            ret = Device.btBuzzer(1, stBuzzerSet)
            If ret <> LibDef.BT_OK Then
                disp = "btBuzzer error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If
            ' 点灯色
            ' btLED 点灯
            ret = Device.btLED(1, stLedSet)
            If ret <> LibDef.BT_OK Then
                disp = "btLED error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If
            ' btVibrator 鳴動
            ret = Device.btVibrator(1, stVibSet)
            If ret <> LibDef.BT_OK Then
                disp = "btVibrator error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If
        Catch ex As Exception
            MessageBox.Show(ex.ToString())
        End Try
    End Sub
    '-----------------------------------------------------------
    ' 照明設定
    '-----------------------------------------------------------
    Public Sub light_setting(ByVal lightset As UInt32)

        Dim idSet As UInt32 = 0
        Dim ret As Int32 = 0
        Dim disp As [String] = ""
        Dim pValueSet As New IntPtr()
        Dim data As UInt32 = 0


        '2次元コードのみ照明設定
        If strHttypeDef = "BT-W85" Or strHttypeDef = "BT-W150" Or strHttypeDef = "BT-W75" Or strHttypeDef = "BT-W155" Then
            idSet = LibDef.BT_SCAN_PROP_ILLUMINATION
            pValueSet = Marshal.AllocCoTaskMem(Marshal.SizeOf(lightset))
            Marshal.WriteInt32(pValueSet, CType(lightset, Int32))
            ret = ScanLib.Setting.btScanSetProperty(idSet, pValueSet)
            Marshal.FreeCoTaskMem(pValueSet)
            If ret <> LibDef.BT_OK Then
                disp = "btScanSetProperty error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If
        End If

    End Sub
    '-----------------------------------------------------------
    ' 小サイズ設定
    '-----------------------------------------------------------
    Public Sub small_setting(ByVal qrflgset As UInt16, ByVal dmflgset As UInt16)

        Dim idSet As UInt32 = 0
        Dim ret As Int32 = 0
        Dim disp As [String] = ""

        Dim ulDataSetQR As LibDef.BT_CODESET_QR
        Dim ulDataSetDM As LibDef.BT_CODESET_DM

        Dim ulDataSet As UInt32 = 0
        Dim pValueSet As New IntPtr()
        Dim data As UInt32 = 0

        ulDataSetQR.flgset = qrflgset
        ulDataSetQR.max = 7089
        ulDataSetQR.min = 1
        ulDataSetDM.flgset = dmflgset
        ulDataSetDM.max = 3116
        ulDataSetDM.min = 1


        'BTW150のみ小サイズ設定
        If strHttypeDef = "BT-W150" Then
            '読み取りモード　QR
            idSet = LibDef.BT_SCAN_PROP_QR
            pValueSet = Marshal.AllocCoTaskMem(Marshal.SizeOf(ulDataSetQR))
            Marshal.StructureToPtr(ulDataSetQR, pValueSet, True)
            ret = ScanLib.Setting.btScanSetProperty(idSet, pValueSet)
            Marshal.FreeCoTaskMem(pValueSet)
            If ret <> LibDef.BT_OK Then
                ng()
                disp = "btScanSetProperty error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If

            '読み取りモード　DM
            idSet = LibDef.BT_SCAN_PROP_DM
            pValueSet = Marshal.AllocCoTaskMem(Marshal.SizeOf(ulDataSetDM))
            Marshal.StructureToPtr(ulDataSetDM, pValueSet, True)
            ret = ScanLib.Setting.btScanSetProperty(idSet, pValueSet)
            Marshal.FreeCoTaskMem(pValueSet)
            If ret <> LibDef.BT_OK Then
                ng()
                disp = "btScanSetProperty error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Return
            End If
        End If
    End Sub
End Module
