﻿Imports Bt
Imports System.Runtime.InteropServices
Imports System.Net.Sockets

Public Class b_wedge

    ' フォーム
    '--------------------------------------------------------------
    ' DLLImport
    '--------------------------------------------------------------
    'ソケット通信用
    <DllImport("wininet.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
    Private Shared Function InternetOpen(ByVal lpszAgent As [String], ByVal dwAccessType As Int32, ByVal lpszProxyName As [String], ByVal lpszProxyBypass As [String], ByVal dwFlags As Int32) As IntPtr
    End Function

    <DllImport("wininet.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
    Private Shared Function InternetConnect(ByVal hInternet As IntPtr, ByVal lpszServerName As [String], ByVal nServerPort As Int16, ByVal lpszUsername As [String], ByVal lpszPassword As [String], ByVal dwService As Int32, _
     ByVal dwFlags As Int32, ByVal dwContext As IntPtr) As IntPtr
    End Function

    <DllImport("wininet.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
    Private Shared Function InternetCloseHandle(ByVal hInternet As IntPtr) As <MarshalAs(UnmanagedType.Bool)> [Boolean]
    End Function

    <DllImport("wininet.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
    Private Shared Function FtpPutFile(ByVal hConnect As IntPtr, ByVal lpszLocalFile As [String], ByVal lpszNewRemoteFile As [String], ByVal dwFlags As Int64, ByVal dwContext As IntPtr) As <MarshalAs(UnmanagedType.Bool)> Boolean
    End Function

    <DllImport("coredll.dll", SetLastError:=True, CharSet:=CharSet.Unicode)> _
    Public Shared Function WaitForSingleObject(ByVal Handle As IntPtr, ByVal Wait As Int32) As Int32
    End Function

    <DllImport("coredll.dll", SetLastError:=True, CallingConvention:=CallingConvention.Winapi, CharSet:=CharSet.Unicode)> _
    Public Shared Function CreateEvent(ByVal lpEventAttributes As IntPtr, <[In](), MarshalAs(UnmanagedType.Bool)> ByVal bManualReset As [Boolean], <[In](), MarshalAs(UnmanagedType.Bool)> ByVal bIntialState As Boolean, <[In](), MarshalAs(UnmanagedType.BStr)> ByVal lpName As [String]) As IntPtr
    End Function

    '--------------------------------------------------------------
    ' 定数定義
    '--------------------------------------------------------------
    ' wininetで使用する定数
    Public Const INTERNET_DEFAULT_FTP_PORT As Int32 = 21
    Public Const INTERNET_OPEN_TYPE_PRECONFIG As Int32 = 0
    Public Const INTERNET_OPEN_TYPE_DIRECT As Int32 = 1
    Public Const INTERNET_OPEN_TYPE_PROXY As Int32 = 3
    Public Const INTERNET_INVALID_PORT_NUMBER As Int32 = 0
    Public Const INTERNET_SERVICE_FTP As Int32 = 1
    Public Const INTERNET_SERVICE_GOPHER As Int32 = 2
    Public Const INTERNET_SERVICE_HTTP As Int32 = 3
    Public Const FTP_TRANSFER_TYPE_BINARY As Int64 = &H2
    Public Const FTP_TRANSFER_TYPE_ASCII As Int64 = &H1
    Public Const INTERNET_FLAG_NO_CACHE_WRITE As Int64 = &H4000000
    Public Const INTERNET_FLAG_RELOAD As Int64 = &H80000000UI
    Public Const INTERNET_FLAG_KEEP_CONNECTION As Int64 = &H400000
    Public Const INTERNET_FLAG_MULTIPART As Int64 = &H200000
    Public Const INTERNET_FLAG_PASSIVE As Int64 = &H8000000
    Public Const FILE_ATTRIBUTE_READONLY As Int64 = &H1
    Public Const FILE_ATTRIBUTE_HIDDEN As Int64 = &H2
    Public Const FILE_ATTRIBUTE_SYSTEM As Int64 = &H4
    Public Const FILE_ATTRIBUTE_DIRECTORY As Int64 = &H10
    Public Const FILE_ATTRIBUTE_ARCHIVE As Int64 = &H20
    Public Const FILE_ATTRIBUTE_NORMAL As Int64 = &H80
    Public Const FILE_ATTRIBUTE_TEMPORARY As Int64 = &H100
    Public Const FILE_ATTRIBUTE_COMPRESSED As Int64 = &H800
    Public Const FILE_ATTRIBUTE_OFFLINE As Int64 = &H1000

    Public Const WAIT_OBJECT_0 As Int32 = &H0 ' coredll.dllで使用する定数
    Private MsgWin As MsgWindow
    Private ip As String() = {"192", "168", "100", "1"} 'IPアドレス
    Public strCodedata As [String] = "" 'スキャンデータ
    Public data_count As Integer = 0 'データ数
    Public connectflag As Integer = 1 '0:接続 1:切断
    Private textlist() As TextBox
    Private data_array As String()
    Private senddata As String


    Public Sub New()
        InitializeComponent()
        ' メッセージウインドウインスタンス作成
        Me.MsgWin = New MsgWindow()
    End Sub

    Private Sub b_wedge_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim idSet As UInt32 = 0
        Dim ret As Int32 = 0
        Dim disp As [String] = ""
        '端末情報
        Dim pValueGetDef_HtType As IntPtr = Marshal.AllocCoTaskMem(Marshal.SizeOf(LibDef.BT_SYS_HTTYPE_MAXLEN))

        Try
            Call change.QVGAtoVGA(Me)

            ' 機種タイプ
            idSet = LibDef.BT_SYS_PRM_HTTYPE
            ret = SysLib.Terminal.btGetHandyParameter(idSet, pValueGetDef_HtType)
            If ret <> LibDef.BT_OK Then
                ng()
                disp = "btGetHandyParameter error ret[" & ret & "]"
                MessageBox.Show(disp, "Error")
                Me.Close()
                Me.Dispose()
                Return
            End If
            strHttypeDef = Marshal.PtrToStringUni(pValueGetDef_HtType)

            'オフライン用配列作成
            data_array = New String(500) {}
            'タイトルバーを非表示
            Me.FormBorderStyle = FormBorderStyle.None
            'コントロール配列の作成
            Me.textlist = New TextBox() {Me.rireki1, Me.rireki2, Me.rireki3, Me.rireki4, Me.rireki5, Me.rireki6}
            '初期設定
            initial_setting()

            'パス取得
            modulescheck = System.Reflection.Assembly.GetExecutingAssembly().GetModules()
            pathcheck = System.IO.Path.GetDirectoryName(modulescheck(0).FullyQualifiedName)
            'ファイル存在チェック
            If System.IO.File.Exists(pathcheck + "\" + setting_file) = False Then
                Dim sw As New System.IO.StreamWriter(pathcheck + "\" + setting_file, False, System.Text.Encoding.GetEncoding("Shift_Jis"))
                'Bluetooth接続
                sw.Write("0" + vbCrLf)
                status(0) = "1"
                'ホストIP
                sw.Write("192.168.100.10" + vbCrLf)
                status(1) = "192.168.100.10"
                'ポート番号
                sw.Write("8501" + vbCrLf)
                status(2) = "8501"
                'ライト
                sw.Write("1" + vbCrLf)
                status(3) = "1"

                light_setting(1)
                '小サイズ
                sw.Write("3" + vbCrLf)
                status(4) = "3"
                small_setting(3, 1)
                'ターミネータ
                sw.Write("0" + vbCrLf)
                status(5) = "0"
                'DM番号
                sw.Write("11000" + vbCrLf)
                status(6) = "11000"

                terminator = Microsoft.VisualBasic.ChrW(Keys.Return)

                'ストリームを閉じる
                sw.Close()
            Else
                '設定取得
                Dim sw As New System.IO.StreamReader(pathcheck + "\" + setting_file, System.Text.Encoding.GetEncoding("Shift_Jis"))
                Dim readdata As String
                For i = 0 To 6
                    readdata = sw.ReadLine()
                    If readdata = Nothing Or readdata = "" Then

                    ElseIf IsNumeric(readdata.Replace(".", "")) = False Then
                        'IP設定が数字以外の場合
                    ElseIf i = 2 And readdata.IndexOf(".") <> -1 Then
                        'ポート設定が数字以外の場合()
                    Else
                        status(i) = readdata
                    End If
                Next
                'ファイルクローズ
                sw.Close()
            End If

            '通信経路
            If status(0) <> "0" And status(0) <> "1" Then
                status(0) = "1"
            End If
            'IPアドレス設定
            ip = status(1).Split(".")
            If ip.Length <> 4 Then
                status(1) = "192.168.100.10"
            Else
                status(1) = Integer.Parse(ip(0)) & "." & Integer.Parse(ip(1)) & "." & Integer.Parse(ip(2)) & "." & Integer.Parse(ip(3))
            End If

            'ポート番号設定
            If Integer.Parse(status(2)) < 1024 Or Integer.Parse(status(2)) > 65535 Then
                status(2) = "8501"
            Else
                status(2) = Integer.Parse(status(2))
            End If
            If status(3) = "0" Then
                light_setting(0)
            Else
                light_setting(1)
            End If
            If status(4) = "7" Then
                small_setting(7, 3)
            Else
                small_setting(3, 1)
            End If

            'ターミネータ
            If Integer.Parse(status(5)) < 0 Or Integer.Parse(status(5)) > 4 Then
                status(5) = "0"
                terminator = Microsoft.VisualBasic.ChrW(Keys.Return)
            Else
                If status(5) = "0" Then
                    terminator = Microsoft.VisualBasic.ChrW(Keys.Return)
                ElseIf status(5) = "1" Then
                    terminator = Microsoft.VisualBasic.ChrW(Keys.Return) + Microsoft.VisualBasic.ChrW(Keys.LineFeed)
                ElseIf status(5) = "2" Then
                    terminator = Microsoft.VisualBasic.ChrW(Keys.LineFeed)
                ElseIf status(5) = "3" Then
                    terminator = Microsoft.VisualBasic.ChrW(Keys.Tab)
                ElseIf status(5) = "4" Then
                    terminator = ""
                Else
                    terminator = Microsoft.VisualBasic.ChrW(Keys.Return)
                End If
            End If

            'DM番号設定
            If Integer.Parse(status(6)) < 1 Or Integer.Parse(status(6)) > 65534 Then
                status(6) = "11000"
            Else
                status(6) = Integer.Parse(status(6))
            End If

            connect_check()
        Catch
            status(0) = "1"
            status(1) = "192.168.100.10"
            status(2) = "8501"
            status(3) = "1"
            status(4) = "3"
            status(5) = "0"
            status(6) = "11000"
            light_setting(1)
            small_setting(3, 1)
            ng()
            MessageBox.Show("Setting error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
            connect_check()
        End Try
    End Sub
    Private Sub connect_check()
        Dim ret As Boolean
        Try
            '無線
            ret = wlan_connect()
            If ret = True Then
                '接続成功
                label_change("WLAN", "DisC", online_backcolor)
                'label_change("Online(WLAN)", "DisC", online_backcolor)
                connectflag = 0
            Else
                '失敗
                label_change("WLAN", "Conn", online_backcolor)
                'label_change("Offline(WLAN)", "Conn", offline_backcolor)
                connectflag = 1
            End If
        Catch
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            ng()
            MessageBox.Show("Connect error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        End Try
    End Sub

    '無線接続
    Private Function wlan_connect()

        Dim ret As Int32 = 0

        ''// scan enable all symbol
        'Dim ulDataset As UInt32 = 0
        'ulDataset = Bt.LibDef.BT_WLAN_OPEN_SYNC

        'Dim pValueSet As New IntPtr()
        'pValueSet = Marshal.AllocCoTaskMem(Marshal.SizeOf(ulDataset)) '
        'Marshal.WriteInt32(pValueSet, CType(ulDataset, Int32))

        'ret = Bt.CommLib.Wlan.btWLANSetProperty(Bt.LibDef.BTWLAN_PROPID.BT_WLAN_PROP_OPENMODE, pValueSet)
        'Marshal.FreeCoTaskMem(pValueSet)


        Dim disp As [String] = ""
        Dim return_status As Boolean
        Try
            keyset(LibDef.BT_KEY_DISABLEALL)
            taiki.Text = "WLAN connecting"
            taiki.Visible = True
            Me.Refresh()


            '            MessageBox.Show("1", "debug", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1) '//##



            ret = CommLib.Wlan.btWLANOpen()
            If ret = LibDef.BT_ERR_COMM_ALREADY_OPEN Then
                'Dim statusGet As UInt32 = 0
                'ret = Bt.CommLib.Wlan.btWLANGetStatus(statusGet)
                'If statusGet <> LibDef.BT_WLAN_STS_CONNECTED Then
                '    disp = "btWLANGetStatus error status [" & statusGet & "]"
                '    MessageBox.Show(disp, "エラー")
                '    return_status = False
                'End If

                return_status = True
                GoTo L_END

            ElseIf ret <> LibDef.BT_OK Then
                ng()
                disp = "btWLANOpen error ret[" & ret & "]"
                keyset(LibDef.BT_KEY_ALL)
                MessageBox.Show(disp, "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
                return_status = False
                GoTo L_END

            Else '// 無線Open成功時
                'Dim statusGet As UInt32 = 0
                'ret = Bt.CommLib.Wlan.btWLANGetStatus(statusGet)
                'If statusGet <> LibDef.BT_WLAN_STS_CONNECTED Then
                '    disp = "btWLANGetStatus error status [" & statusGet & "]"
                '    MessageBox.Show(disp, "エラー")
                '    return_status = False
                'End If

                return_status = True
                GoTo L_END
            End If


            return_status = True
L_END:
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            Return return_status
        Catch e As SocketException
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            ng()
            MessageBox.Show("wlan_connect", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
            Return False
        Catch
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            ng()
            MessageBox.Show("wlan_connect", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
            Return False
        End Try
    End Function

    '初期設定
    Private Sub initial_setting()

        scan_text.Text = ""
        scan_text.Focus()
        'コントロール配列の要素番号を取得
        Dim i As Integer
        For i = 0 To textlist.Length - 1
            textlist(i).Text = ""
            textlist(i).BackColor = Color.White
        Next

    End Sub


    Private Sub scan_text_GotFocus(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles scan_text.GotFocus
        '読み取り制御
        ScanLib.Control.btScanEnable()
        'キー入力設定
        SysLib.Display.btSetKeyCharacter(LibDef.BT_KEYINPUT_DIRECT)
    End Sub

    Private Sub end_status()
        '読み取り制御
        ScanLib.Control.btScanEnable()
        taiki.Visible = False

        keyset(LibDef.BT_KEY_ALL)
        data_count = 0
    End Sub

    Private Sub scan_text_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles scan_text.KeyDown
        Dim bRet As [Boolean] = False
        Dim ret As Int32 = 0
        Dim disp As [String] = ""
        Dim dsizeSet As UInt32 = 0
        Dim ssizeGet As UInt32 = 0
        Dim str(0) As Byte
        Dim refkeySet As UInt32 = 0
        Dim nowkeyGet As UInt32 = 0
        Dim keydata As String

        'Try

        If e.KeyCode = Keys.Left Then
            '左
            refkeySet = LibDef.BT_KEY_LEFT
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_LEFT Then
                Return
            End If
            str(0) = 19
        ElseIf e.KeyCode = Keys.Up Then
            '上
            refkeySet = LibDef.BT_KEY_UP
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_UP Then
                Return
            End If
            str(0) = 17
        ElseIf e.KeyCode = Keys.Right Then
            '右   
            refkeySet = LibDef.BT_KEY_RIGHT
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_RIGHT Then
                Return
            End If
            str(0) = 20
        ElseIf e.KeyCode = Keys.Down Then
            '下
            refkeySet = LibDef.BT_KEY_DOWN
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_DOWN Then
                Return
            End If
            str(0) = 18
        ElseIf e.KeyCode = Keys.Tab Then
            'tab
            refkeySet = LibDef.BT_KEY_TAB
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_TAB Then
                Return
            End If
            str(0) = 9
        ElseIf e.KeyCode = Keys.Back Then
            If scan_text.Text <> "" Then
                Return
            End If
            'backspace
            refkeySet = LibDef.BT_KEY_CLR
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet <> LibDef.BT_KEY_CLR Then
                Return
            End If
            str(0) = 8
        ElseIf e.KeyCode = Keys.F2 Then
            onoff_change()
            Return
        ElseIf e.KeyCode = Keys.F3 Then

            data_count = 0
            keyset(LibDef.BT_KEY_ALL)
            Dim f As New user_setting()
            f.ShowDialog()
            connect_check()
            scan_text.Focus()
            Return
        ElseIf e.KeyCode = Keys.Enter Then
            If scan_text.TextLength <= 0 Then
                Return
            End If
            If scan_text.TextLength >= 100 Then '//##
                scan_text.Text = scan_text.Text.Substring(0, 100)
            End If

            refkeySet = LibDef.BT_KEY_ENT
            SysLib.Device.btKeySense(refkeySet, nowkeyGet)
            If nowkeyGet = LibDef.BT_KEY_ENT Then
                str = System.Text.Encoding.GetEncoding(932).GetBytes(scan_text.Text + terminator)
                keydata = scan_text.Text.ToString()
                rireki_data(keydata)
            ElseIf strCodedata <> "" Then
                str = System.Text.Encoding.GetEncoding(932).GetBytes(strCodedata + terminator)
                keydata = strCodedata
                rireki_data(keydata)
                strCodedata = ""
            End If
        Else
            Return
        End If
        'オンラインの場合
        If connectflag = 0 Then
            keyset(LibDef.BT_KEY_DISABLEALL)
            Connect(status(1), str)
            keyset(LibDef.BT_KEY_ALL)
        End If
        scan_text.Text = ""
        'Catch ex As Exception
        '    taiki.Visible = False
        '    keyset(LibDef.BT_KEY_ALL)
        '    ng()
        '    MessageBox.Show("Error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        'Finally
        'End Try
    End Sub
    Public Sub offline_send()
        Dim bRet As [Boolean] = False
        Dim ret As Int32 = 0
        Dim disp As [String] = ""

        Dim dsizeSet As UInt32 = 0
        Dim ssizeGet As UInt32 = 0
        Dim bytes(1) As Byte
        Try

            Dim i As Integer

            keyset(LibDef.BT_KEY_DISABLEALL)
            '無線とBluetoothで処理を分ける
            ' ソケット通信用
            Dim port As Int32 = Int32.Parse(status(2))
            Dim client As New TcpClient(status(1), port)
            Dim stream As NetworkStream = client.GetStream()
            For i = 0 To data_count - 1
                senddata = data_array(i) + terminator
                bytes = System.Text.Encoding.GetEncoding(932).GetBytes(senddata)
                stream.Write(bytes, 0, bytes.Length)
            Next
            stream.Close()
            client.Close()

            keyset(LibDef.BT_KEY_ALL)
        Catch ex As Exception
            ng()
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            MessageBox.Show("Communication error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        Finally
        End Try
    End Sub

    Private Sub onoff_change()
        Dim ret As Boolean
        Try
            keyset(LibDef.BT_KEY_ALL)

            '無線
            If connectflag = 0 Then
                'オンラインの場合
                '無線切断()
                CommLib.Wlan.btWLANClose()
                label_change("WLAN", "Conn", online_backcolor)
                'label_change("Offline(WLAN)", "Conn", offline_backcolor)
                'オフラインに設定
                connectflag = 1
            Else
                ret = wlan_connect()
                If ret = True Then
                    '接続成功
                    'テキスト色変更
                    label_change("WLAN", "DisC", online_backcolor)
                    'label_change("Online(WLAN)", "DisC", online_backcolor)
                    connectflag = 0
                Else
                    '失敗
                    label_change("WLAN", "Conn", online_backcolor)
                    'label_change("Offline(WLAN)", "Conn", offline_backcolor)
                    connectflag = 1
                End If
            End If

            scan_text.Focus()
        Catch
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            ng()
            MessageBox.Show("Connection error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        End Try
    End Sub
    '履歴データの表示
    Public Sub rireki_data(ByVal rireki As String)

        'オフラインモードの場合
        If connectflag = 1 Then
            '履歴データ作成
            data_array(data_count) = rireki
            'オフラインの場合
            data_count += 1
        End If
        'データを1件ずらす
        For i = 5 To 1 Step -1
            '空のデータに挿入
            textlist(i).Text = textlist(i - 1).Text
        Next
        textlist(0).Text = rireki

    End Sub

    Private Sub endbutton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles end_button2.Click
        Try
            If MessageBox.Show("Exit application?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) = DialogResult.Yes Then
                end_status()
                light_setting(1)
                small_setting(3, 1)
                Me.Close()
                Me.Dispose()
            End If
            scan_text.Focus()
        Catch
            ng()
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            MessageBox.Show("Setting error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        End Try
    End Sub
 
    Private Sub connect_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles connect_button.Click

        onoff_change()
    End Sub

    Private Sub set_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles set_button.Click
        data_count = 0
        keyset(LibDef.BT_KEY_ALL)
        Dim f As New user_setting()
        f.ShowDialog()
        connect_check()
        scan_text.Focus()
    End Sub

    Private Sub ex_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ex_button.Click
        scan_text.Focus()
    End Sub
    'ラベル変更
    Public Sub label_change(ByVal moji1 As String, ByVal moji2 As String, ByVal color1 As System.Drawing.Color)
        onoff_label.Text = moji1
        onoff_label.BackColor = color1
        connect_button.Text = moji2
    End Sub

    Private Sub b_wedge_KeyDown(ByVal sender As System.Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles MyBase.KeyDown
        Try
            If e.KeyCode = Keys.F1 Then
                If MessageBox.Show("Exit application?", "Confirm", MessageBoxButtons.YesNo, MessageBoxIcon.Question, MessageBoxDefaultButton.Button1) = DialogResult.Yes Then
                    end_status()
                    light_setting(1)
                    small_setting(3, 1)
                    Me.Close()
                    Me.Dispose()
                End If
            End If
            scan_text.Focus()
        Catch
            ng()
            taiki.Visible = False
            keyset(LibDef.BT_KEY_ALL)
            MessageBox.Show("Setting error", "Error", MessageBoxButtons.OK, MessageBoxIcon.Exclamation, MessageBoxDefaultButton.Button1)
        End Try
    End Sub

    Public Sub Connect(ByVal serverIP As String, ByVal data() As Byte)

        Try

            Dim writedat() As String = {"0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", _
                                        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", _
                                        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", _
                                        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", _
                                        "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0"}

            Dim remotePort As Integer = CLng(user_setting.port_text.Text)
            Dim localPort As Integer = CLng(user_setting.port_text.Text)
            Dim remoteHost As String
            remoteHost = serverIP

            Dim objSck As New System.Net.Sockets.TcpClient(remoteHost, remotePort)
            'Dim objSck As New System.Net.Sockets.UdpClient(remotePort)

            Dim i As Integer
            For i = 0 To scan_text.TextLength - 1
                writedat(i) = Hex(Asc(scan_text.Text.Substring(i, 1)))
            Next

            Dim sendByte As Byte() = System.Text.Encoding.ASCII.GetBytes("WRS DM" + status(6) + ".H 0050 " _
                                           & writedat(0) & writedat(1) & " " & writedat(2) & writedat(3) & " " & writedat(4) & writedat(5) & " " & writedat(6) & writedat(7) & " " & writedat(8) & writedat(9) & " " _
                                           & writedat(10) & writedat(11) & " " & writedat(12) & writedat(13) & " " & writedat(14) & writedat(15) & " " & writedat(16) & writedat(17) & " " & writedat(18) & writedat(19) & " " _
                                           & writedat(20) & writedat(21) & " " & writedat(22) & writedat(23) & " " & writedat(24) & writedat(25) & " " & writedat(26) & writedat(27) & " " & writedat(28) & writedat(29) & " " _
                                           & writedat(30) & writedat(31) & " " & writedat(32) & writedat(33) & " " & writedat(34) & writedat(35) & " " & writedat(36) & writedat(37) & " " & writedat(38) & writedat(39) & " " _
                                           & writedat(40) & writedat(41) & " " & writedat(42) & writedat(43) & " " & writedat(44) & writedat(45) & " " & writedat(46) & writedat(47) & " " & writedat(48) & writedat(49) & " " _
                                           & writedat(50) & writedat(51) & " " & writedat(52) & writedat(53) & " " & writedat(54) & writedat(55) & " " & writedat(56) & writedat(57) & " " & writedat(58) & writedat(59) & " " _
                                           & writedat(60) & writedat(61) & " " & writedat(62) & writedat(63) & " " & writedat(64) & writedat(65) & " " & writedat(66) & writedat(67) & " " & writedat(68) & writedat(69) & " " _
                                           & writedat(70) & writedat(71) & " " & writedat(72) & writedat(73) & " " & writedat(74) & writedat(75) & " " & writedat(76) & writedat(77) & " " & writedat(78) & writedat(79) & " " _
                                           & writedat(80) & writedat(81) & " " & writedat(82) & writedat(83) & " " & writedat(84) & writedat(85) & " " & writedat(86) & writedat(87) & " " & writedat(98) & writedat(89) & " " _
                                           & writedat(90) & writedat(91) & " " & writedat(92) & writedat(93) & " " & writedat(94) & writedat(95) & " " & writedat(96) & writedat(97) & " " & writedat(98) & writedat(99) & Chr(&HD))

            Dim stream As NetworkStream = objSck.GetStream()
            stream.Write(sendByte, 0, sendByte.Length)

            'objSck.Connect(remoteHost, remotePort)
            'objSck.Send(sendByte, sendByte.GetLength(0))

            Dim cnt As Integer = 0
            For cnt = 0 To 100
                System.Threading.Thread.Sleep(100)

                If objSck.Client.Available > 0 Then
                    Dim remoteEP As System.Net.IPEndPoint = Nothing
                    Dim dat2 As Byte() = New [Byte](255) {}
                    stream.Read(dat2, 0, dat2.Length)
                    'Dim dat2 As Byte() = objSck.Receive(remoteEP)

                    Dim result As String = System.Text.Encoding.ASCII.GetString(dat2, 0, dat2.Length)
                    'MsgBox("result = [" & result & "]")

                    Exit For
                End If

                'If cnt = 15 Then
                '    MsgBox("Timeout")
                '    Exit For
                'End If
            Next


            stream.Close()
            objSck.Close()



        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        'Try

            '    Dim writedat() As String = {"0", "0", "0", "0", "0", "0", "0", _
            '                                "0", "0", "0", "0", "0", "0", "0", _
            '                                "0", "0", "0", "0", "0", "0"}

            '    Dim remotePort As Integer = CLng(user_setting.port_text.Text)
            '    Dim localPort As Integer = CLng(user_setting.port_text.Text)
            '    Dim remoteHost As String
            '    remoteHost = serverIP

            '    Dim objSck As New System.Net.Sockets.TcpClient(remoteHost, remotePort)
            '    'Dim objSck As New System.Net.Sockets.UdpClient(remotePort)

            '    Dim i As Integer
            '    For i = 0 To scan_text.TextLength - 1
            '        writedat(i) = Hex(Asc(scan_text.Text.Substring(i, 1)))
            '    Next

            '    Dim sendByte As Byte() = System.Text.Encoding.ASCII.GetBytes("WRS DM" + status(6) + ".H 0010 " _
            '                                   & writedat(0) & writedat(1) & " " _
            '                                   & writedat(2) & writedat(3) & " " _
            '                                   & writedat(4) & writedat(5) & " " _
            '                                   & writedat(6) & writedat(7) & " " _
            '                                   & writedat(8) & writedat(9) & " " _
            '                                   & writedat(10) & writedat(11) & " " _
            '                                   & writedat(12) & writedat(13) & " " _
            '                                   & writedat(14) & writedat(15) & " " _
            '                                   & writedat(16) & writedat(17) & " " _
            '                                   & writedat(18) & writedat(19) & Chr(&HD))

            '    Dim stream As NetworkStream = objSck.GetStream()
            '    stream.Write(sendByte, 0, sendByte.Length)

            '    'objSck.Connect(remoteHost, remotePort)
            '    'objSck.Send(sendByte, sendByte.GetLength(0))

            '    Dim cnt As Integer = 0
            '    For cnt = 0 To 20
            '        System.Threading.Thread.Sleep(100)

            '        If objSck.Client.Available > 0 Then
            '            Dim remoteEP As System.Net.IPEndPoint = Nothing
            '            Dim dat2 As Byte() = New [Byte](255) {}
            '            stream.Read(dat2, 0, dat2.Length)
            '            'Dim dat2 As Byte() = objSck.Receive(remoteEP)

            '            Dim result As String = System.Text.Encoding.ASCII.GetString(dat2, 0, dat2.Length)
            '            'MsgBox("result = [" & result & "]")

            '            Exit For
            '        End If

            '        'If cnt = 15 Then
            '        '    MsgBox("Timeout")
            '        '    Exit For
            '        'End If
            '    Next


            '    stream.Close()
            '    objSck.Close()



            'Catch ex As Exception
            '    MsgBox(ex.Message)
            'End Try
    End Sub
End Class

'---------------------------------------------------------------------------------
' メッセージウインドウクラス
'---------------------------------------------------------------------------------
Public Class MsgWindow
    Inherits Microsoft.WindowsCE.Forms.MessageWindow

    Protected Overrides Sub WndProc(ByRef msg As Microsoft.WindowsCE.Forms.Message)
        Dim bRet As [Boolean] = False
        Dim ret As Int32 = 0
        Dim disp As [String] = ""

        Dim dsizeSet As UInt32 = 0
        Dim ssizeGet As UInt32 = 0

        Dim index As UInt32
        Dim codeData As Byte()
        Dim report As LibDef.BT_SCAN_REPORT
        Dim qr_report As LibDef.BT_SCAN_QR_REPORT
        Dim codeLen As Int32 = 0
        Dim i As UInt32 = 0

        Select Case msg.Msg
            Case CType(LibDef.WM_BT_WLAN, Int32)

                If msg.WParam.ToInt32() = CType(LibDef.BTMSG_WPARAM.WP_WLAN_CONNECT, Int32) Then
                    '無線接続成功
                    If b_wedge.data_count <> 0 Then
                        'データをまとめて送信
                        b_wedge.offline_send()
                        'オンラインに設定
                        b_wedge.data_count = 0
                    End If
                    b_wedge.connectflag = 0
                End If
                Exit Select
            Case CType(LibDef.WM_BT_SCAN, Int32)
                ' 読み取り成功の場合
                If msg.WParam.ToInt32() = CType(LibDef.BTMSG_WPARAM.WP_SCN_SUCCESS, Int32) Then
                    codeLen = 0
                    '読み取りデータ取得
                    codeLen = Bt.ScanLib.Control.btScanGetDataSize(i)
                    codeData = New [Byte](codeLen - 1) {}
                    ScanLib.Control.btScanGetData(index, codeData, report, qr_report)
                    b_wedge.strCodedata = System.Text.Encoding.GetEncoding(932).GetString(codeData, 0, codeLen)
                End If
                Exit Select
        End Select
        MyBase.WndProc(msg)
    End Sub
End Class