﻿using System;
using System.IO;
using System.Reflection;

namespace SCAN.lib
{


    public class LogWriter
    {
        private string m_exePath = string.Empty;
        private static LogWriter logWriter = null;

        public static bool Disable = false;

        public static LogWriter getInstance()
        {
            if (logWriter == null)
                logWriter = new LogWriter();

            return logWriter;
        }

        private LogWriter()
        {
            m_exePath = Path.GetDirectoryName(this.GetType().Assembly.GetModules()[0].FullyQualifiedName);
        }

        public void Log(string logMessage)
        {
            try
            {
                using (StreamWriter w = File.AppendText(m_exePath + "\\" + "log.txt"))
                {
                    Log(logMessage, w);

                    w.Flush();
                    w.Close();
                }
            }
            catch (Exception ex)
            {
            }
        }

        public void Log(string[] arry)
        {
            try
            {
                using (StreamWriter w = File.AppendText(m_exePath + "\\" + "log.txt"))
                {
                    string tmp = "[";
                    bool first = true;
                    foreach (var str in arry)
                    {
                        tmp += String.Format("{0}\"{1}\"\n", first?"":",", str);
                        first = false;
                    }
                    tmp += "]";
                    Log(tmp, w);

                    w.Flush();
                    w.Close();
                }
            }
            catch (Exception ex)
            {
            }
        }

        public void Log(string logMessage, TextWriter txtWriter)
        {
            if (Disable) return;

            try
            {
                txtWriter.WriteLine("{0}| {1}", DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss"), logMessage);
            }
            catch (Exception ex)
            {
            }
        }
    }
}
