﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using HT_NMB.Data.DataAccess;
using Bt.ScanLib;

namespace HT_NMB
{
    public partial class frmLogin : Form
    {
        public string userName = string.Empty;

        public frmLogin()
        {
            InitializeComponent();
            InitialDataControl();
        }

        private void frmLogin_Load(object sender, EventArgs e)
        {
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
        }

        private void InitialDataControl()
        {

            DataTable objUsers = GetAccess.Instant.getAllUser();
            if (objUsers.Rows.Count > 0)
            {
                foreach (DataRow dr in objUsers.Rows)
                {
                    cbUserName.Items.Add(dr["UserName"].ToString().Trim());
                }
               
            }
      
        
        }

        private void btnLogin_Click(object sender, EventArgs e)
        {
            if (cbUserName.Text == string.Empty)
            {
                MessageBox.Show("Please Select Username");
                return;
            }
            if (tbxPassword.Text.Trim() == string.Empty)
            {
                MessageBox.Show("Please Input Password");
                return;
            }

          DataTable objdt = GetAccess.Instant.getUserPass(cbUserName.SelectedItem.ToString().Trim(),tbxPassword.Text.Trim());
          if (objdt.Rows.Count > 0)
          {
              userName = objdt.Rows[0]["UserName"].ToString().Trim();
              Form frmMainMenu = new frmMainMenu();
              frmMainMenu.Show();
              this.Hide();

          }
          else
          {
              lblError.Visible = true;
              tbxPassword.Focus();
          }
        }

    }
}