package com.tomastc.bta500.lib;

import java.util.HashMap;

public class ScheduleQRCode {

    public enum ScheduleStatus {
        NEW(0),
        NOT_COMPLETED(1),
        COMPLETED(2),
        NOT_FOUND(3);
        private final int id;

        ScheduleStatus(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static ScheduleQRCode.ScheduleStatus fromId(final int id) {
            for (ScheduleQRCode.ScheduleStatus e : ScheduleQRCode.ScheduleStatus.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }
    public enum ScheduleStepStatus {
        OK(0),
        SKIP(1);
        private final int id;

        ScheduleStepStatus(final int id) {
            this.id = id;
        }

        public int getId() {
            return id;
        }

        public static ScheduleQRCode.ScheduleStepStatus fromId(final int id) {
            for (ScheduleQRCode.ScheduleStepStatus e : ScheduleQRCode.ScheduleStepStatus.values()) {
                if (e.id == id) {
                    return e;
                }
            }
            return null;
        }
    }

    private String[] cols = new String[]{
            "prod_date"
            , "ws_cd"
            , "ws_no"
            , "ws_2d"
            , "seq_no"
            , "item_no"
            , "item_desc"
            , "prod_qty"
            , "parenti_no"
            , "parenti_desc"
            , "compl_lot"
    };

    private ScheduleStatus status;
    private ScheduleStepStatus stepStatus;
    private String documentNo;
    private String data_char8;
    private String totalQty;
    private String totalNg;
    private HashMap<String, String> elements;
    private SerialNo serialNo;
    private CompletionInput completionInput;

    private ScheduleQRCode() {}

    public ScheduleQRCode(String data, String regex) {
        String[] tokens = data.split(regex);

        init();
        for (int i=0;i<tokens.length;i++) {
            elements.put(cols[i], tokens[i]);
        }
    }

    private void init() {
        elements = new HashMap<String, String>() {{
            for (String token : cols) {
                put(token, "");
            }
        }
        };
    }

    public HashMap<String, String> getElements() {
        return elements;
    }

    public ScheduleStatus getStatus() {
        return status;
    }

    public void setStatus(ScheduleStatus status) {
        this.status = status;
    }

    public String getDocumentNo() {
        return documentNo;
    }

    public void setDocumentNo(String documentNo) {
        this.documentNo = documentNo;
    }

    public String getData_Char8() {
        return data_char8;
    }

    public void setData_Char8(String data_char8) {
        this.data_char8 = data_char8;
    }

    public String getTotalQty() {
        return totalQty;
    }

    public void setTotalQty(String totalQty) {
        this.totalQty = totalQty;
    }

    public String getTotalNg() {
        return totalNg;
    }

    public void setTotalNg(String totalNg) {
        this.totalNg = totalNg;
    }

    public ScheduleStepStatus getStepStatus() {
        return stepStatus;
    }

    public void setStepStatus(ScheduleStepStatus stepStatus) {
        this.stepStatus = stepStatus;
    }

    public SerialNo getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(SerialNo serialNo) {
        this.serialNo = serialNo;
    }

    public CompletionInput getCompletionInput() {
        return completionInput;
    }

    public void setCompletionInput(CompletionInput completionInput) {
        this.completionInput = completionInput;
    }
}
