package com.tomastc.bta500.lib.common;

import android.content.ContentResolver;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.util.Log;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;

public class FileUtil {

    public static void writeFile(String filename, String path, String data) throws IOException {
        try {
            File file = new File(path, filename);
            Log.d("BTA500", "Write to file " + file.getAbsolutePath());
            Log.d("BTA500", "data: " + data);
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(data);
            bw.close();
        } catch (IOException e) {
            throw e;
        }
    }

    public static String readFile(String filename, String path) throws IOException {
        Log.d("BTA500", "read file:" + path + "/" + filename);
        StringBuilder stringBuilder = new StringBuilder();
        try (FileInputStream inputStream =
                     new FileInputStream(new File(path, filename));
             BufferedReader reader = new BufferedReader(
                     new InputStreamReader(Objects.requireNonNull(inputStream)))) {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(System.getProperty("line.separator"));
            }
        }
        return stringBuilder.toString();
    }

    public static String readTextFromUri(Uri uri, ContentResolver contentResolver) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStream inputStream =
                     contentResolver.openInputStream(uri);
             BufferedReader reader = new BufferedReader(
                     new InputStreamReader(Objects.requireNonNull(inputStream)))) {
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(System.getProperty("line.separator"));
            }
        }
        return stringBuilder.toString();
    }

    public static void alterDocumentUri(Uri uri, ContentResolver contentResolver, String data) {
        try {
            ParcelFileDescriptor pfd = contentResolver.
                    openFileDescriptor(uri, "w");
            FileOutputStream fileOutputStream =
                    new FileOutputStream(pfd.getFileDescriptor());
            fileOutputStream.write(data.getBytes());

            // Let the document provider know it's done by closing the stream.
            fileOutputStream.close();
            pfd.close();
        } catch (FileNotFoundException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
