package com.tomastc.bta500.lib;

public enum ErrorCode {
    E100(100, "Invalid input scan data."),
    E101(101, "Parent MO number not found."),
    E102(102, "Compo detail is in suspend mode."),
    E103(103, "Duplicated scan slip."),
    E104(104, "Not enough quantity in slip."),
    E105(105, "Child item has already been finished."),
    E106(106, "Not approve 4M."),
    E107(107, "Item data not found."),
    E200(200, "Server connection failed."),
    E201(201, "Data insertion failed.");
    private final int id;
    private final String det;

    ErrorCode(final int id, final String det) {
        this.id = id;
        this.det = det;
    }

    public int getId() {
        return id;
    }

    public String getDet() { return det; }

    @Override
    public String toString() {
        return String.format("%s[Code:%d]", det, id);
    }

    public static ErrorCode fromId(final int id) {
        for (ErrorCode e : ErrorCode.values()) {
            if (e.id == id) {
                return e;
            }
        }
        return null;
    }
}
