package com.tomastc.bta500;

import static android.view.View.GONE;
import static android.view.View.INVISIBLE;
import static android.view.View.VISIBLE;

import static com.tomastc.bta500.lib.ErrorCode.E100;
import static com.tomastc.bta500.lib.ErrorCode.E101;
import static com.tomastc.bta500.lib.ErrorCode.E104;
import static com.tomastc.bta500.lib.ErrorCode.E105;
import static com.tomastc.bta500.lib.ErrorCode.E106;
import static com.tomastc.bta500.lib.ErrorCode.E107;
import static com.tomastc.bta500.lib.ErrorCode.E200;
import static com.tomastc.bta500.lib.ErrorCode.E201;

import androidx.appcompat.app.AppCompatActivity;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.media.ToneGenerator;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.RelativeLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.tomastc.bta500.lib.ActionListenerCallback;
import com.tomastc.bta500.lib.ErrorCode;
import com.tomastc.bta500.lib.KeyMapping;
import com.tomastc.bta500.lib.LabelInfo;
import com.tomastc.bta500.lib.NstErrorLog;
import com.tomastc.bta500.lib.Scanner;
import com.tomastc.bta500.lib.Settings;
import com.tomastc.bta500.lib.SpinAdapter;
import com.tomastc.bta500.lib.common.AsyncHttpClient;
import com.tomastc.bta500.lib.common.DatetimeUtil;
import com.tomastc.bta500.lib.common.Utils;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;

public class ComponentDetailActivity extends Scanner {

    private Button btn_back, btn_check_progress, btn_clear;
    private EditText txt_mo_no, txt_parent_item_no, txt_parent_item_desc, txt_ws_no, txt_child_item_no, txt_child_item_name
            , txt_instruction_qty, txt_label_qty, txt_actual_qty;
    private TextView lbl_shift_code;
    private RelativeLayout popupLayout1, popupLayout2;

    private boolean screen_locked = false;
    private int scan_step = 0;

    private String mo_number;
    private HashMap<String, JSONObject> childItems;
    private DecimalFormat formatter = new DecimalFormat("#,###.00");

    private void keepErrorLog(String mo_no, LabelInfo labelInfo, ErrorCode errorCode) {

        try {
            // Prepare error information
            NstErrorLog nstErrorLog = new NstErrorLog(
                    mo_no == null || (mo_no != null && mo_no.isEmpty()) ? "-" : mo_no
                    , labelInfo == null ? "-" : labelInfo.getChild_item_no()
                    , labelInfo == null ? "-" : labelInfo.getSlip_no()
                    , labelInfo == null || ( labelInfo != null && labelInfo.getLabel_qty() == null) ? 0 : labelInfo.getLabel_qty()
                    , labelInfo == null || ( labelInfo != null && labelInfo.getActual_qty() == null ) ? 0 : labelInfo.getActual_qty()
                    , errorCode.getDet() + "[" + String.valueOf(errorCode.getId()) + "]"
                    , getString(R.string.COMPO_PGM_NAME)
                    , Settings.getUserLogin_list().get(0).getUser_id()
                    , String.valueOf(errorCode.getId())
            );

            JSONObject json = new JSONObject();
            json.put("cmd", "nst-error-log");
            json.put("NST_ERROR_LOG", nstErrorLog.toString());

            new AsyncHttpClient(getApplicationContext()
                    ,Settings.getMgmtList().get("web_api") + "/nst_compo_detail.php"
                    , json.toString()
            ) {
                @Override
                public void onFinished(String response, int resp_code) {
                    Log.d(getString(R.string.tag), "response: " + response);
                }

                @Override
                protected void onError(Exception e) {
                }
            }.execute();

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void labelConfirm(JSONObject item, LabelInfo labelInfo) {
        try {
            Log.d(getString(R.string.tag), item.toString(2));
            // version 1.4.4 : just create new NST_TRACE_TRANS record for Non priority item.
            if (item.getString("PRIORITY_FLAG").equals("0")) {
                Log.d(getString(R.string.tag), "Label confirm for Non-Priority item.");

                labelInfo.setActual_qty(labelInfo.getActual_qty());

                JSONObject json = new JSONObject();
                json.put("cmd", "label-confirm");
                json.put("Nst_compo_detail", item);
                json.put("NST_TRACE_TRANS", labelInfo.toString());
                json.put("user_id", Settings.getUserLogin_list().get(0).getUser_id()); // For COMPO_DET it uses only 1 user login

                new AsyncHttpClient(getApplicationContext()
                        ,Settings.getMgmtList().get("web_api") + "/nst_compo_detail.php"
                        , json.toString()
                ) {
                    @Override
                    public void onFinished(String response, int resp_code) {
                        Log.d(getString(R.string.tag), "response: " + response);
                        Toast.makeText(getApplicationContext(), "Label confirmed.", Toast.LENGTH_LONG).show();
                        try {
                            JSONObject jobj;
                            try {
                                jobj = new JSONObject(response);
                            } catch (Exception e) {
                                keepErrorLog(mo_number, labelInfo, E200);
                                alertError(E200.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                                throw new Exception(E200.toString());
                            }

                            if (jobj.getInt("affected_rows") == 1) {
                                txt_instruction_qty.setText(
                                        formatter.format(item.getDouble("Inp_qty")) + "/"
                                                + formatter.format(item.getDouble("Dmd_qty"))
                                );
                                txt_actual_qty.setText(formatter.format(labelInfo.getUsing_qty()));
                                alertOk("Label confirmed for Non Priority item.", new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {
                                        //reset();
                                        //resetChildData();
                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                });
                            } else {
                                keepErrorLog(mo_number, labelInfo, E201);
                                alertError(E201.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    protected void onError(Exception e) {
                        alertError(E200.toString(), new ActionListenerCallback() {
                            @Override
                            public void onActionSuccess(String successMessage) throws Exception {

                            }

                            @Override
                            public void onActionFailure(Throwable throwableError) {

                            }
                        }, screen_locked = false);
                    }
                }.execute();

            } else {
                // update new actual qty
                Double old_using_qty = labelInfo.getUsing_qty();
                labelInfo.setActual_qty( labelInfo.getActual_qty() - labelInfo.getUsing_qty() );

                JSONObject json = new JSONObject();
                json.put("cmd", "label-confirm");
                json.put("Nst_compo_detail", item);
                json.put("NST_TRACE_TRANS", labelInfo.toString());
                json.put("user_id", Settings.getUserLogin_list().get(0).getUser_id()); // For COMPO_DET it uses only 1 user login

                new AsyncHttpClient(getApplicationContext()
                        ,Settings.getMgmtList().get("web_api") + "/nst_compo_detail.php"
                        , json.toString()
                ) {
                    @Override
                    public void onFinished(String response, int resp_code) {
                        Log.d(getString(R.string.tag), "response: " + response);
                        Toast.makeText(getApplicationContext(), "Label confirmed.", Toast.LENGTH_LONG).show();
                        try {
                            JSONObject jobj;
                            try {
                                jobj = new JSONObject(response);
                            } catch (Exception e) {
                                keepErrorLog(mo_number, labelInfo, E200);
                                alertError(E200.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                                throw new Exception(E200.toString());
                            }
                            if (jobj.getInt("affected_rows") == 2 && item.getString("Sts_cd") == "1") {
                                txt_instruction_qty.setText(
                                        formatter.format(item.getDouble("Inp_qty")) + "/"
                                                + formatter.format(item.getDouble("Dmd_qty"))
                                );
                                txt_actual_qty.setText(formatter.format(labelInfo.getUsing_qty()));
                                alertOk("Label confirmed and child item completed.", new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {
                                        //reset();
                                        //resetChildData();
                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                });
                            } else if (jobj.getInt("affected_rows") >= 2) {
                                alertOk("Label confirmed", new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {
                                        txt_instruction_qty.setText(
                                                formatter.format(item.getDouble("Inp_qty")) + "/"
                                                        + formatter.format(item.getDouble("Dmd_qty"))
                                        );
                                        txt_actual_qty.setText(formatter.format(labelInfo.getUsing_qty()));
                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                });
                            } else {
                                // rollback
                                labelInfo.setActual_qty(old_using_qty);

                                keepErrorLog(mo_number, labelInfo, E201);
                                alertError(E201.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                            }
                        } catch (Exception e) {
                            e.printStackTrace();

                            // rollback
                            labelInfo.setActual_qty(old_using_qty);
                        }
                    }

                    @Override
                    protected void onError(Exception e) {
                        alertError(E200.toString(), new ActionListenerCallback() {
                            @Override
                            public void onActionSuccess(String successMessage) throws Exception {

                            }

                            @Override
                            public void onActionFailure(Throwable throwableError) {

                            }
                        }, screen_locked = false);
                    }
                }.execute();

            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void doCheckItemChanged(LabelInfo labelInfo) {
        if (!labelInfo.getChild_item_no().equals(txt_child_item_no.getText().toString())
                && !txt_child_item_no.getText().toString().isEmpty()
        ) {
            confirmation("New ITEM \"" + labelInfo.getChild_item_no() + "\" detected!!\nClick \"Confirm\" to accept the changing an item?"
                    , getColor(R.color.red)
                    , true
                    , new ActionListenerCallback() {
                        @Override
                        public void onActionSuccess(String successMessage) {
                            doScanLabel(labelInfo);
                        }

                        @Override
                        public void onActionFailure(Throwable throwableError) {
                        }
                    }, null);
        } else {
            doScanLabel(labelInfo);
        }
    }

    private void doScanLabel(LabelInfo labelInfo) {
        // Check remaining quantity of label
        try {
            String key = mo_number + "-" + labelInfo.getChild_item_no();

            if (childItems == null || ( childItems != null && !childItems.containsKey(key))) {
                keepErrorLog(mo_number, labelInfo, E107);
                alertError(E107.toString(), new ActionListenerCallback() {
                    @Override
                    public void onActionSuccess(String successMessage) throws Exception {

                    }

                    @Override
                    public void onActionFailure(Throwable throwableError) {

                    }
                }, screen_locked=false);
                throw new Exception(E107.toString());
            }

            JSONObject compoDetail = childItems.get(key);

            // version 1.4.4 : just create new NST_TRACE_TRANS record for Non priority items
            if (compoDetail.getString("PRIORITY_FLAG").equals("0")) {
                // Set label info qty
                labelInfo.setUsing_qty(labelInfo.getLabel_qty());
                labelInfo.setActual_qty(labelInfo.getLabel_qty());

                // Display scan label data
                txt_child_item_no.setText(compoDetail.getString("ITEM_NO"));
                txt_child_item_name.setText(labelInfo.getChild_item_name());
                txt_instruction_qty.setText(
                        formatter.format(compoDetail.getDouble("Inp_qty")) + "/"
                                + formatter.format(compoDetail.getDouble("Dmd_qty"))
                );
                txt_label_qty.setText(formatter.format(labelInfo.getLabel_qty()));
                txt_actual_qty.setText(formatter.format(labelInfo.getUsing_qty()));

                // Skip the quantity check
                labelConfirm(compoDetail, labelInfo);

            } else {

                JSONObject json = new JSONObject();
                json.put("cmd", "get-last-trace-trans");
                json.put("slip_no", labelInfo.getSlip_no());
                json.put("child_item_no", labelInfo.getChild_item_no());
                json.put("labelprint_date", labelInfo.getPrintlabel_date());

                new AsyncHttpClient(getApplicationContext()
                        ,Settings.getMgmtList().get("web_api") + "/nst_compo_detail.php"
                        , json.toString()
                ) {
                    @Override
                    public void onFinished(String response, int resp_code) {
                        Log.d(getString(R.string.tag), "response: " + response);
                        Toast.makeText(getApplicationContext(), "Check label remaining qty.", Toast.LENGTH_LONG).show();

                        try {
                            JSONArray jArray;
                            try {
                                jArray = new JSONArray(response);
                            } catch (Exception e) {
                                keepErrorLog(mo_number, labelInfo, E200);
                                alertError(E200.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                                throw new Exception(E200.toString());
                            }
                            Log.d(getString(R.string.tag), "response json length: " + jArray.length());
                            double actual_qty = Double.valueOf(labelInfo.getLabel_qty());
                            if (jArray.length() != 0) {
                                JSONObject jobj = jArray.getJSONObject(0);

                                // get last used qty
                                actual_qty = jobj.getDouble("LABEL_OUTSTANDING_QTY");
                            }

                            labelInfo.setActual_qty(actual_qty);

                            // Check existence labelInfo with compo_detail
                            String key = mo_number + "-" + labelInfo.getChild_item_no();
                            if (childItems == null || ( childItems != null && !childItems.containsKey(key))) {

                                keepErrorLog(mo_number, labelInfo, E107);
                                alertError(E107.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked=false);
                                throw new Exception(E107.toString());
                            }

                            // Is empty qty
                            if (actual_qty == 0) {
                                keepErrorLog(mo_number, labelInfo, E104);
                                alertError(E104.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked = false);
                                throw new Exception(E104.toString());
                            }

                            // Check not approve 4M
                            if (compoDetail.getInt("PO_STOP_FLAG") != 0) {
                                keepErrorLog(mo_number, labelInfo, E106);
                                alertError(E106.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked=false);
                                throw new Exception(E106.toString());

                            }

                            // Display child item data
                            txt_child_item_no.setText(compoDetail.getString("ITEM_NO"));
                            txt_child_item_name.setText(labelInfo.getChild_item_name());
                            txt_instruction_qty.setText(
                                    formatter.format(compoDetail.getDouble("Inp_qty")) + "/"
                                            + formatter.format(compoDetail.getDouble("Dmd_qty"))
                            );
                            txt_label_qty.setText(formatter.format(labelInfo.getLabel_qty()));
                            txt_actual_qty.setText(formatter.format(labelInfo.getUsing_qty()));

                            double demand_qty = compoDetail.getDouble("Dmd_qty");
                            double input_qty = compoDetail.getDouble("Inp_qty");
                            String status_code = compoDetail.getString("Sts_cd"); // 0: Not completed, 1: Completed

                            // Check is it completed
                            if (status_code == "1" || demand_qty <= input_qty) {
                                keepErrorLog(mo_number, labelInfo, E105);
                                alertError(E105.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {
                                        //reset();
                                        resetChildData();
                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked=false);
                                throw new Exception(E105.toString());
                            }

                            // check new input qty
                            double free_slot_qty = demand_qty - input_qty;
                            double new_input_qty = actual_qty;
                            if (new_input_qty > free_slot_qty) {
                                new_input_qty = free_slot_qty;
                            }
                            labelInfo.setUsing_qty(new_input_qty);

                            compoDetail.put("Inp_qty", input_qty + new_input_qty);
                            compoDetail.put("Sts_cd", (input_qty + new_input_qty) == demand_qty ? "1" : "0");

                            labelConfirm(compoDetail, labelInfo);

                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }

                    @Override
                    protected void onError(Exception e) {

                    }
                }.execute();
            }


        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void processData(String data, DecodeResult.Result result, String codeType) {

        try {

            Log.d(getString(R.string.tag), String.format("data read[%d bytes]: %s", data.length(), data));

            switch (scan_step) {
                case 0:
                    // reset buffering
                    reset();

                    // Format: MO_QR_CODE e.g. 23034038
                    // Length: 8
                    // Other:

                    if (data.length()!=8) {
                        keepErrorLog(null, null, E100);
                        alertError(E100.toString(), new ActionListenerCallback() {
                            @Override
                            public void onActionSuccess(String successMessage) throws Exception {

                            }

                            @Override
                            public void onActionFailure(Throwable throwableError) {

                            }
                        }, screen_locked=false);
                        throw new Exception(E100.toString());
                    }

                    mo_number = data.trim(); // MO Number QRcode

                    //key manual check userid --> add to map
                    try {
                        JSONObject json = new JSONObject();
                        json.put("cmd", "get-component-detail");
                        json.put("id", mo_number);

                        new AsyncHttpClient(getApplicationContext()
                                ,Settings.getMgmtList().get("web_api") + "/nst_compo_detail.php"
                                , json.toString()
                        ) {
                            @Override
                            public void onFinished(String response, int resp_code) {
                                Log.d(getString(R.string.tag), "response: " + response);
                                Toast.makeText(getApplicationContext(), "Component detail downloaded.", Toast.LENGTH_LONG).show();
                                // update mapItems
                                try {
                                    JSONArray jArray = new JSONArray(response);
                                    Log.d(getString(R.string.tag), "response json length: " + jArray.length());
                                    if (jArray.length() != 0) { // keep current inquiry items
                                        childItems = new HashMap<>();
                                        for (int i=0; i<jArray.length(); i++) {
                                            JSONObject jobj = jArray.getJSONObject(i);
                                            String key = jobj.getString("Doc_no") + "-" + jobj.getString("ITEM_NO");
                                            childItems.put(key, jobj);
                                        }

                                        // Display master detail
                                        JSONObject jtmp = jArray.getJSONObject(0);
                                        txt_mo_no.setText(mo_number);
                                        txt_ws_no.setText(jtmp.getString("Ws_no"));
                                        txt_parent_item_no.setText(jtmp.getString("PARENT_ITEM_NO"));
                                        txt_parent_item_desc.setText(jtmp.getString("PARENT_ITEM_DESC") == "null" ? "-" : jtmp.getString("PARENT_ITEM_DESC"));

                                        scan_step++;
                                    } else {
                                        keepErrorLog(null, null, E101);
                                        alertError(E101.toString(), new ActionListenerCallback() {
                                            @Override
                                            public void onActionSuccess(String successMessage) throws Exception {
                                            }

                                            @Override
                                            public void onActionFailure(Throwable throwableError) {

                                            }
                                        }, screen_locked=false);
                                        throw new Exception(E101.toString());
                                    }

                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }

                            @Override
                            protected void onError(Exception e) {
                                keepErrorLog(null, null, E200);
                                alertError(E200.toString(), new ActionListenerCallback() {
                                    @Override
                                    public void onActionSuccess(String successMessage) throws Exception {

                                    }

                                    @Override
                                    public void onActionFailure(Throwable throwableError) {

                                    }
                                }, screen_locked=false);
                               e.printStackTrace();
                            }
                        }.execute();
                    } catch (JSONException e) {
                        Log.e(getString(R.string.tag), e.getMessage());
                    }

                    break;

                default:
                    // Scan item label, there are 3 types of label
                    resetChildData();

                    try {
                        // Extract label scan data
                        String[] tokens = data.split(getString(R.string.DELIMITER_SCAN_TOKEN));
                        Log.d(getString(R.string.tag), Arrays.deepToString(tokens));

                        // Check which label type scan
                        LabelInfo labelInfo = null;
                        if (tokens[0].contains("RN")) {
                            labelInfo = new LabelInfo(
                                    "RN"
                                    , tokens[8]
                                    , tokens[9]
                                    , tokens[8].substring(0,7)
                                    , tokens[1]
                                    , tokens[11]
                                    , "-"
                                    , DatetimeUtil.changeDateFormat(tokens[10], "yyyy/MM/dd", "yyyyMMdd") // Convert yyyy/MM/dd --> yyyyMMdd
                                    , Double.valueOf(tokens[5])
                                    , "-"
                                    , tokens[7]
                                    , "-"
                                    , "0"
                                    , tokens[2]
                                    , tokens[3]
                                    , tokens[13]
                            );
                        } else if (tokens[0].contains("SM")) {
                            labelInfo = new LabelInfo(
                                    "SM"
                                    , tokens[1]
                                    , tokens[6]
                                    , tokens[2]
                                    , tokens[3]
                                    , tokens[4]
                                    , tokens[10]
                                    , DatetimeUtil.changeDateFormat(tokens[7], "dd-MM-yyyy", "yyyyMMdd") // Convert dd-MM-yyyy --> yyyyMMdd
                                    , Double.valueOf(tokens[8])
                                    , "-"
                                    , "-"
                                    , "-"
                                    , DatetimeUtil.changeDateFormat(tokens[12], "HH:mm:ss", "HHmmss") // Convert dd-MM-yyyy --> yyyyMMdd
                                    , "-"
                                    , "-"
                                    , "-"
                            );
                        } else {
                            labelInfo = new LabelInfo(
                                    "SM"
                                    , tokens[0]
                                    , tokens[9]
                                    , tokens[13]
                                    , tokens[4]
                                    , "-" // Copy from compo_detail **doesn't found 2023-05-20
                                    , tokens[3]
                                    , DatetimeUtil.changeDateFormat(tokens[9], "dd/MM/yyyy", "yyyyMMdd") // Convert dd/MM/yyyy --> yyyyMMdd
                                    , Double.valueOf(tokens[7])
                                    , "-"
                                    , "-"
                                    , "-"
                                    , DatetimeUtil.changeDateFormat(tokens[10], "HH:mm:ss", "HHmmss") // Convert dd-MM-yyyy --> yyyyMMdd
                                    , "-"
                                    , "-"
                                    , "-"
                            );
                        }

                        doCheckItemChanged(labelInfo);

                    } catch (Exception e) {

                        keepErrorLog(null, null, E100);
                        alertError(E100.toString(), new ActionListenerCallback() {
                            @Override
                            public void onActionSuccess(String successMessage) throws Exception {

                            }

                            @Override
                            public void onActionFailure(Throwable throwableError) {

                            }
                        }, screen_locked=false);
                        throw new Exception(E100.toString());
                    }

                    break;
            }

            // always hide keyboard after scan
            //Utils.hideKeyboardFrom(getApplicationContext(), default_view);

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SuppressLint("MissingInflatedId")
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_component_detail);

        default_view = (EditText) findViewById(R.id.txt_tmp);

        btn_back = (Button) findViewById(R.id.btn_back);
        btn_check_progress = (Button) findViewById(R.id.btn_check_progress);
        btn_clear = (Button) findViewById(R.id.btn_clear);

        txt_mo_no = (EditText) findViewById(R.id.txt_mo_no);
        txt_parent_item_no = (EditText) findViewById(R.id.txt_parent_item_no);
        txt_parent_item_desc = (EditText) findViewById(R.id.txt_parent_item_desc);
        txt_ws_no = (EditText) findViewById(R.id.txt_ws_no);
        txt_child_item_no = (EditText) findViewById(R.id.txt_child_item_no);
        txt_child_item_name = (EditText) findViewById(R.id.txt_child_item_name);
        txt_instruction_qty = (EditText) findViewById(R.id.txt_instruction_qty);
        txt_label_qty = (EditText) findViewById(R.id.txt_label_qty);
        txt_actual_qty = (EditText) findViewById(R.id.txt_actual_qty);

        popupLayout1 = (RelativeLayout) findViewById(R.id.popupLayout1);
        popupLayout2 = (RelativeLayout) findViewById(R.id.popupLayout2);

        lbl_shift_code = (TextView) findViewById(R.id.lbl_shift_code);
        lbl_shift_code.setText("Shift code : " + Settings.getShiftCode().getId());

        btn_back.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                finish();
            }
        });

        btn_check_progress.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Log.d(getString(R.string.tag), "start component check progress activity");
                Settings.setWorkMode(Settings.WorkMode.COMPONENT_CHECK_PROGRESS);
                Intent intent =new Intent(ComponentDetailActivity.this, ComponentCheckProgressActivity.class);
                intent.putExtra("mo_no", txt_mo_no.getText().toString());
                intent.putExtra("parent_item_no", txt_parent_item_no.getText().toString());
                intent.putExtra("parent_item_desc", txt_parent_item_desc.getText().toString());
                startActivity(intent);
            }
        });

        btn_clear.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                reset();
            }
        });

    }

    private void resetChildData() {
        txt_child_item_no.setText("");
        txt_child_item_name.setText("");
        txt_instruction_qty.setText("");
        txt_label_qty.setText("");
        txt_actual_qty.setText("");
        txt_instruction_qty.setBackgroundColor(getColor(R.color.silver));
    }

    private void reset() {
        txt_mo_no.setText("");
        txt_parent_item_no.setText("");
        txt_parent_item_desc.setText("");
        txt_ws_no.setText("");
        txt_child_item_no.setText("");
        txt_child_item_name.setText("");
        txt_instruction_qty.setText("");
        txt_label_qty.setText("");
        txt_actual_qty.setText("");
        txt_instruction_qty.setBackgroundColor(getColor(R.color.silver));

        childItems = null;
        mo_number = null;

        scan_step = 0;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        Log.d(getString(R.string.tag), String.format("keyCode: %d", keyCode) );
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            if (popupLayout1.getVisibility() == VISIBLE) {
                Button btnOk = (Button) findViewById(R.id.popupLayout1_btn1);
                Button btnConfirm = (Button) findViewById(R.id.popupLayout1_btn2);
                switch (KeyMapping.fromId(keyCode)) {
                    case P1:
                        btnOk.performClick();
                        break;

                    case P2:
                        btnConfirm.performClick();
                        break;

                }
            } else {
                switch (KeyMapping.fromId(keyCode)) {
                    case P1:
                        btn_back.performClick();
                        break;

                    case P2:
                        btn_clear.performClick();
                        break;

                    case P3:
                        btn_check_progress.performClick();
                        break;

                }
            }
        } else if (keyCode == KeyMapping.ENT.getId()) {
            if (popupLayout2.getVisibility() == VISIBLE) {
                Button btn = (Button) findViewById(R.id.popupLayout2_btn1);
                btn.requestFocus();
                btn.performClick();
            }
            return false;
        }

        return super.onKeyUp(keyCode, event);
    }


    private void confirmation(String msg, int color, boolean isBtnOkShow
            , ActionListenerCallback callback, SpinAdapter spinAdapter) {


        Log.d(getString(R.string.tag), "confirmation() " + msg);

        RelativeLayout layout = popupLayout1;
        TextView lbl_msg = (TextView) findViewById(R.id.popupLayout1_txt);
        Button btnOk = (Button) findViewById(R.id.popupLayout1_btn1);
        Button btnConfirm = (Button) findViewById(R.id.popupLayout1_btn2);
        Spinner ddl_options = (Spinner) findViewById(R.id.ddl_options);

        ddl_options.setVisibility (spinAdapter == null ? GONE : VISIBLE);

        if (spinAdapter != null) {
            ddl_options.setAdapter(spinAdapter);
        }

        lbl_msg.setText(msg);
        lbl_msg.setTextColor(color);
        btnOk.setVisibility(isBtnOkShow ? VISIBLE : INVISIBLE);
        layout.setVisibility(VISIBLE);
        btnOk.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                try {
                    layout.setVisibility(GONE);
                    callback.onActionFailure(null);
                } catch (Exception e) {
                    e.printStackTrace();
                };
            }
        });
        btnConfirm.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                try {
                    layout.setVisibility(GONE);
                    if (spinAdapter != null) {
                        callback.onActionSuccess(
                                spinAdapter.getItem(
                                        ddl_options.getSelectedItemPosition()
                                ).getName()
                        );
                    } else {
                        callback.onActionSuccess("");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                };
            }
        });

    }

    private void alertOk(String msg, ActionListenerCallback callback) {
        // Enable the ENT key down, it must current focus on multiline text input
        default_view.requestFocus();

        RelativeLayout layout = popupLayout2;
        TextView lbl_msg = (TextView) findViewById(R.id.popupLayout2_txt);
        Button btn = (Button) findViewById(R.id.popupLayout2_btn1);
        EditText txt_leader_password = (EditText) findViewById(R.id.txt_leader_password);

        lbl_msg.setText(msg);
        lbl_msg.setTextColor(getColor(R.color.black));
        layout.setVisibility(VISIBLE);
        txt_leader_password.setVisibility(GONE);
        btn.setBackgroundColor(getColor(R.color.green));
        btn.setTextColor(getColor(R.color.white));
        btn.setText("OK [ENT]");
        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // stop activity
                try {
                    layout.setVisibility(GONE);
                    callback.onActionSuccess("");
                } catch (Exception e) {
                    // In case if item is the top most view
                };
            }
        });

    }

    private void alertError(String msg, ActionListenerCallback callback, Boolean isLockScreen) {
        alertError(msg, callback, isLockScreen, R.string.LEVEL_PERMIT_UNLOCK_SCREEN);
    }

    private void alertError(String msg, ActionListenerCallback callback, Boolean isLockScreen, int level_permit) {
        // Enable the ENT key down, it must current focus on multiline text input
        default_view.requestFocus();

        RelativeLayout layout = popupLayout2;
        TextView lbl_msg = (TextView) findViewById(R.id.popupLayout2_txt);
        Button btn = (Button) findViewById(R.id.popupLayout2_btn1);
        EditText txt_leader_password = (EditText) findViewById(R.id.txt_leader_password);

        if (isLockScreen) {
            txt_leader_password.setVisibility(VISIBLE);
            txt_leader_password.setText("");

            Utils.playMedia(getApplicationContext(), R.raw.ship_siren);
        } else {
            txt_leader_password.setVisibility(GONE);

            Utils.playTones(ToneGenerator.TONE_CDMA_ABBR_ALERT, 10000, 900);
        }

        lbl_msg.setText(msg);
        lbl_msg.setTextColor(getColor(R.color.red));
        layout.setVisibility(VISIBLE);
        btn.setBackgroundColor(getColor(R.color.red));
        btn.setTextColor(getColor(R.color.white));
        btn.setText("NG [" + (isLockScreen?"scan":"ENT") + "]");
        btn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                // stop activity
                try {
                    if (!isLockScreen) {
                        layout.setVisibility(GONE);
                        callback.onActionSuccess("");
                    } else {

                        /**
                         * Not implemented for this project, just close the error dialog
                         *
                        // check password
                        if (!Settings.getMgmtList().containsKey(getString(level_permit))) {
                            callback.onActionFailure(new Exception(String.valueOf(E111.getId())));
                            return;
                        }

                        List<String> levelTokens = Arrays.asList(Settings.getMgmtList().get(getString(level_permit))
                                .split(getString(R.string.DELIMITER_SETTINGS)));
                        EditText txt_leader_password = (EditText) findViewById(R.id.txt_leader_password);
                        if (!MainActivity.instance.userHashMap.containsKey(txt_leader_password.getText().toString())) {
                            callback.onActionFailure(new Exception(String.valueOf(E112.getId())));
                            return;
                        }

                        User user = MainActivity.instance.userHashMap.get(txt_leader_password.getText().toString());
                        if (levelTokens.contains(user.getLevel())) {
                            screen_locked = false;
                            layout.setVisibility(GONE);
                            callback.onActionSuccess("");
                        } else {
                            callback.onActionFailure(new Exception(String.valueOf(E122.getId())));
                        }
                         *
                         */
                        layout.setVisibility(GONE);
                        callback.onActionSuccess("");
                    }



                } catch (Exception e) {
                    // In case if item is the top most view
                };
            }
        });

    }
}