package com.tomas.st_nset.lib;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Color;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.TextView;

import com.tomas.st_nset.R;

public class MyAlert implements View.OnClickListener {

    private Context context = null;
    private Dialog dialog = null;
    private Button button = null;
    private TextView txt_Message = null;

    public MyAlert(Context context) {
        this.context = context;

        dialog = new Dialog(context);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.layout_dialog_error);
        dialog.setCancelable(false);
        button = (Button) dialog.findViewById(R.id.btn_ok);
        button.setOnClickListener(this);

        txt_Message = (TextView) dialog.findViewById(R.id.txt_message);
    }


    public void setMessage(CharSequence message) {
        txt_Message.setText(message);
    }

    public void setTypeAlert(Boolean type) {
        if (type == true){//ok
            txt_Message.setTextColor(Color.BLACK);
            button.setBackgroundResource(R.color.green);
            button.setText("OK [ENT]");


        }else {//ng
            txt_Message.setTextColor(Color.RED);
            button.setBackgroundResource(R.color.red);
            button.setText("NG [ENT]");
        }
    }

    public void show() {
        dialog.show();
    }

    @Override
    public void onClick(View v) {
        switch(v.getId()) {
            case R.id.btn_ok:
                dialog.dismiss();
                break;
        }
    }
}

