package com.tomas.st_nset;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;

import com.tomas.st_nset.lib.KeyMapping;
import com.tomas.st_nset.lib.Settings;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    TextView txt_user, txt_device;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);
        txt_user = (TextView) findViewById(R.id.txt_user_name);
        txt_user.setText("User : "+ Settings.getLoginUser().getName());
        Log.d(getString(R.string.tag), Settings.getLoginUser().getName()+"|"+ Settings.getLoginUser().getId());

        txt_device = (TextView) findViewById(R.id.txt_device);
        txt_device.setText("Device : "+Settings.getDeviceNo());
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_close:
                finishAffinity();
                System.exit(0);
                break;

            case R.id.btn_stocktaking:
                Intent_Stocktaking();
                break;

            case R.id.btn_sampling:
                Intent_Sampling();
                break;
        }
    }

    private void Intent_Sampling() {
        Intent intent1 = new Intent(MainActivity.this, ModeActivity.class);
        intent1.putExtra("main","Sampling");
        startActivity(intent1);
    }

    private void Intent_Stocktaking() {
        Intent intent = new Intent(MainActivity.this, ModeActivity.class);
        intent.putExtra("main","Stocktaking");
        startActivity(intent);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finishAffinity();
                    System.exit(0);
                    break;

                case P2:
                    Intent_Stocktaking();
                    break;

                case P3:
                    Intent_Sampling();
                    break;

            }
        }

        return super.onKeyUp(keyCode, event);
    }
}