package com.tomas.st_nset;

import androidx.appcompat.app.AppCompatActivity;

import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Intent;
import android.os.Bundle;
import android.text.InputType;
import android.view.KeyEvent;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.Spinner;

import com.tomas.st_nset.lib.KeyMapping;

import java.text.SimpleDateFormat;
import java.util.Calendar;

public class ModeActivity extends AppCompatActivity implements View.OnClickListener {
    Bundle bundle;
    EditText edt_m_y;
    Calendar calendar;
    SimpleDateFormat format_MY, F_MONTH_YEAR;
    String str_m_y, str_main, MONTH_YEAR;
    Spinner spinner_slip, spinner_process;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_mode);

        calendar = Calendar.getInstance();
        format_MY = new SimpleDateFormat("MM-yyyy");
        F_MONTH_YEAR = new SimpleDateFormat("MMyyyy");

        bundle = getIntent().getExtras();
        str_main = bundle.getString("main");

        edt_m_y = (EditText) findViewById(R.id.edt_m_y);
        edt_m_y.setText(format_MY.format(calendar.getTime()));
        edt_m_y.setInputType(InputType.TYPE_NULL);
        edt_m_y.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Calendar mcurrentDate = Calendar.getInstance();
                DatePickerDialog monthDatePickerDialog = new DatePickerDialog(ModeActivity.this,
                        AlertDialog.THEME_HOLO_LIGHT, new DatePickerDialog.OnDateSetListener() {
                    @Override
                    public void onDateSet(DatePicker view, int year, int month, int dayOfMonth) {
                        mcurrentDate.set(Calendar.YEAR, year);
                        mcurrentDate.set(Calendar.MONTH, month);
                        str_m_y = format_MY.format(mcurrentDate.getTime());
                        edt_m_y.setText(str_m_y);
                    }
                }, mcurrentDate.get(Calendar.YEAR), mcurrentDate.get(Calendar.MONTH), mcurrentDate.get(Calendar.DATE)){
                    @Override
                    protected void onCreate(Bundle savedInstanceState) {
                        super.onCreate(savedInstanceState);
                        getDatePicker().findViewById(getResources().getIdentifier("day","id","android")).setVisibility(View.GONE);
                    }
                };
                monthDatePickerDialog.setTitle("Select Month & Year");
                monthDatePickerDialog.show();
            }
        });
        spinner_slip = (Spinner) findViewById(R.id.spinner_slip);
        String[] slip = getResources().getStringArray(R.array.Slip_type);
        ArrayAdapter<String> adapterSlip= new ArrayAdapter<String>(this,
                android.R.layout.simple_dropdown_item_1line, slip);
        spinner_slip.setAdapter(adapterSlip);

        spinner_process = (Spinner) findViewById(R.id.spinner_process);

        if (str_main.equals("Stocktaking")){
            String[] process = getResources().getStringArray(R.array.Stocktaking);
            ArrayAdapter<String> adapterProcess= new ArrayAdapter<String>(this,
                    android.R.layout.simple_dropdown_item_1line, process);
            spinner_process.setAdapter(adapterProcess);
        }else {

            String[] process = getResources().getStringArray(R.array.Sampling);
            ArrayAdapter<String> adapterProcess = new ArrayAdapter<String>(this,
                    android.R.layout.simple_dropdown_item_1line, process);
            spinner_process.setAdapter(adapterProcess);
        }
    }

    @Override
    public void onClick(View v) {
        switch (v.getId()) {
            case R.id.btn_main:
                finish();
                break;

            case R.id.btn_confirm:
                Confirm();
                break;
        }
    }
    private void Confirm() {
        MONTH_YEAR = edt_m_y.getText().toString().trim();
        String[] tokens = MONTH_YEAR.split("-");
        MONTH_YEAR = tokens[1]+tokens[0];
        Intent intent = new Intent(ModeActivity.this, StocktakingActivity.class);
        intent.putExtra("main",str_main);
        intent.putExtra("month",MONTH_YEAR);
        intent.putExtra("slip_type",spinner_slip.getSelectedItem().toString().trim());
        intent.putExtra("process",spinner_process.getSelectedItem().toString().trim());
        startActivity(intent);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode >= KeyMapping.P1.getId()
                && keyCode <= KeyMapping.P4.getId())
        {
            switch (KeyMapping.fromId(keyCode)) {
                case P1:
                    finish();
                    break;

                case P2:
                    Confirm();
                    break;
            }
        }
        return super.onKeyUp(keyCode, event);
    }
}