﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.InteropServices;

namespace WDT_Project
{
    class Inifile
    {
        public string path;
        [DllImport("kernel32")]
        private static extern long WritePrivateProfileString(string section,
            string key, string val, string filePath);
        [DllImport("kernel32")]
        private static extern int GetPrivateProfileString(string section,
                 string key, string def, StringBuilder retVal,
            int size, string filePath);

        public string INIPath
        {
            set
            {
                path = value;
            }
            get
            {
                return path;
            }

        }
        public void IniWriteValue(string Section, string Key, string Value)
        {
            WritePrivateProfileString(Section, Key, Value, this.path);
        }
        public void IniWriteValueboolean(string Section, string Key, string Value)
        {
            string Databool = "";
            Databool = (Value == "true") ? Databool = "true" : Databool = "false";
            WritePrivateProfileString(Section, Key, Databool, this.path);
        }
        public string IniReadValue(string Section, string Key)
        {
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp,
                                            255, this.path);
            return temp.ToString();
        }
        public bool IniReadValueboolean(string Section, string Key)
        {
            bool Value = false;
            StringBuilder temp = new StringBuilder(255);
            int i = GetPrivateProfileString(Section, Key, "", temp, 255, this.path);
            Value = (temp.ToString() == "true") ? Value = true : Value = false;
            return Value;
        }
    }
}
