package com.tomastc.bta500;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

public class Outstanding_Adapter extends RecyclerView.Adapter<Outstanding_Adapter.ViewHolder>{
    private List<Outstanding_List> data;
    public Context context;

    public Outstanding_Adapter(List<Outstanding_List> dataset, Context context) {
        data = dataset;
        this.context = context;
    }
    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_item_no;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_item_no = (TextView)itemView.findViewById(R.id.txt_item_no);
        }
    }

    @NonNull
    @Override
    public Outstanding_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_outstanding,parent,false);
        context = parent.getContext();
        return new Outstanding_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        final Outstanding_List list = data.get(position);
        holder.txt_item_no.setText(list.item_no+" / "+list.getQty());

    }

    @Override
    public int getItemCount() {
        return data.size();
    }

}
