package com.tomas.lps_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.lps_asi.ListData.RankCard_Lists;
import com.tomas.lps_asi.R;

import java.util.List;

public class RankCard_Adapter extends RecyclerView.Adapter<RankCard_Adapter.ViewHolder> {
    private List<RankCard_Lists> data;
    public Context context;

    public RankCard_Adapter(List<RankCard_Lists>  dataset, Context context) {
        data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_lot_no, txt_qty, txt_qty_rack_card, txt_balance;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_lot_no = (TextView)itemView.findViewById(R.id.txt_lot_no);
            txt_qty = (TextView)itemView.findViewById(R.id.txt_qty);
            txt_qty_rack_card = (TextView)itemView.findViewById(R.id.txt_qty_rack_card);
            txt_balance = (TextView)itemView.findViewById(R.id.txt_balance);
        }
    }

    @NonNull
    @Override
    public RankCard_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_rankcard,parent,false);
        context = parent.getContext();
        return new RankCard_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull RankCard_Adapter.ViewHolder holder, int position) {
        final RankCard_Lists card_lists = data.get(position);
        holder.txt_lot_no.setText(card_lists.getLotNo());
        holder.txt_qty.setText(card_lists.getQty_Used());
        holder.txt_qty_rack_card.setText(card_lists.getQty_RankCard());
        holder.txt_balance.setText(card_lists.getBalance_RankCard());
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
