package com.tomastc.bta500.lib;

import org.json.JSONException;
import org.json.JSONObject;

public class LabelInfo {
    private String slip_type;
    private String slip_no;
    private String invoice_no;
    private String child_mo_no;
    private String child_item_no;
    private String child_item_name;
    private String mc_line;
    private String invoice_date;
    private Double label_qty;
    private Double actual_qty;
    private String supplier_id;
    private String supplier_name;
    private String cust_item_no;
    private String mfg_time;
    private String whs_cd;
    private String location;
    // v1.4.5
    private String labelprint_date;

    private double using_qty;

    public double getUsing_qty() {
        return using_qty;
    }

    public void setUsing_qty(double using_qty) {
        this.using_qty = using_qty;
    }

    public LabelInfo(String slip_type, String slip_no, String invoice_no, String child_mo_no, String child_item_no, String child_item_name, String mc_line, String invoice_date, Double label_qty, String supplier_id, String supplier_name, String cust_item_no, String mfg_time, String whs_cd, String location
            // v1.4.5
            , String printlabel_date) {
        this.slip_type = slip_type;
        this.slip_no = slip_no;
        this.invoice_no = invoice_no;
        this.child_mo_no = child_mo_no;
        this.child_item_no = child_item_no;
        this.child_item_name = child_item_name;
        this.mc_line = mc_line;
        this.invoice_date = invoice_date;
        this.label_qty = label_qty;
        this.supplier_id = supplier_id;
        this.supplier_name = supplier_name;
        this.cust_item_no = cust_item_no;
        this.mfg_time = mfg_time;
        this.whs_cd = whs_cd;
        this.location = location;
        // v1.4.5
        this.labelprint_date = printlabel_date;
    }

    public String toString() {
        JSONObject json = new JSONObject();
        try {
            json.put("RECORD_TYPE", "M");
            json.put("SLIP_TYPE", this.slip_type);
            json.put("SLIP_NO", this.slip_no);
            json.put("INVOICE_NO", this.invoice_no);
            json.put("CHILD_MO_NO", this.child_mo_no);
            json.put("CHILD_ITEM_NO", this.child_item_no);
            json.put("CHILD_ITEM_DESC", this.child_item_name);
            json.put("MACHINE_LINE", this.mc_line);
            json.put("INVOICE_DATE", this.invoice_date);
            json.put("LABEL_QUANTITY", this.label_qty);
            json.put("LABEL_OUTSTANDING_QTY", this.actual_qty);
            json.put("SUPPLIER_ID", this.supplier_id);
            json.put("SUPPLIER_DESC", this.supplier_name);
            json.put("CUST_ITEM_NO", this.cust_item_no);
            json.put("MFG_TIME", this.mfg_time);
            json.put("WHS_CD", this.whs_cd);
            json.put("LOCATION", this.location);
            json.put("CHG_PGM", "NST_TRACE");
            // v1.4.5
            json.put("LABELPRINT_DATE", this.labelprint_date);
        } catch (JSONException e) {
            e.printStackTrace();
        }

        return json.toString();
    }

    // v1.4.5
    public String getPrintlabel_date() { return labelprint_date; }

    public Double getActual_qty() {
        return actual_qty;
    }

    public void setActual_qty(Double actual_qty) {
        this.actual_qty = actual_qty;
    }

    public String getSlip_no() {
        return slip_no;
    }

    public void setSlip_no(String slip_no) {
        this.slip_no = slip_no;
    }

    public String getSlip_type() {
        return slip_type;
    }

    public void setSlip_type(String slip_type) {
        this.slip_type = slip_type;
    }

    public String getInvoice_no() {
        return invoice_no;
    }

    public void setInvoice_no(String invoice_no) {
        this.invoice_no = invoice_no;
    }

    public String getChild_mo_no() {
        return child_mo_no;
    }

    public void setChild_mo_no(String child_mo_no) {
        this.child_mo_no = child_mo_no;
    }

    public String getChild_item_no() {
        return child_item_no;
    }

    public void setChild_item_no(String child_item_no) {
        this.child_item_no = child_item_no;
    }

    public String getChild_item_name() {
        return child_item_name;
    }

    public void setChild_item_name(String child_item_name) {
        this.child_item_name = child_item_name;
    }

    public String getMc_line() {
        return mc_line;
    }

    public void setMc_line(String mc_line) {
        this.mc_line = mc_line;
    }

    public String getInvoice_date() {
        return invoice_date;
    }

    public void setInvoice_date(String invoice_date) {
        this.invoice_date = invoice_date;
    }

    public Double getLabel_qty() { return label_qty; }

    public void setLabel_qty(Double label_qty) {
        this.label_qty = label_qty;
    }

    public String getSupplier_id() {
        return supplier_id;
    }

    public void setSupplier_id(String supplier_id) {
        this.supplier_id = supplier_id;
    }

    public String getSupplier_name() {
        return supplier_name;
    }

    public void setSupplier_name(String supplier_name) {
        this.supplier_name = supplier_name;
    }

    public String getCust_item_no() {
        return cust_item_no;
    }

    public void setCust_item_no(String cust_item_no) {
        this.cust_item_no = cust_item_no;
    }

    public String getMfg_time() {
        return mfg_time;
    }

    public void setMfg_time(String mfg_time) {
        this.mfg_time = mfg_time;
    }

    public String getWhs_cd() {
        return whs_cd;
    }

    public void setWhs_cd(String whs_cd) {
        this.whs_cd = whs_cd;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}
