package com.tomas.lps_asi.Adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import com.tomas.lps_asi.ListData.Material_Lists;
import com.tomas.lps_asi.R;

import java.util.List;

public class Material_Adapter  extends RecyclerView.Adapter<Material_Adapter.ViewHolder>{
    private List<Material_Lists> data;
    public Context context;

    public Material_Adapter(List<Material_Lists> dataset, Context context) {
        this.data = dataset;
        this.context = context;
    }

    public class ViewHolder extends RecyclerView.ViewHolder{
        public LinearLayout layout;
        public TextView txt_material;
        public ViewHolder(@NonNull View itemView) {
            super(itemView);
            layout = (LinearLayout)itemView.findViewById(R.id.row_item);
            txt_material = (TextView)itemView.findViewById(R.id.txt_material);
        }
    }

    @NonNull
    @Override
    public Material_Adapter.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View content_view = LayoutInflater.from(parent.getContext()).inflate(R.layout.content_material,parent,false);
        context = parent.getContext();
        return new Material_Adapter.ViewHolder(content_view);
    }

    @Override
    public void onBindViewHolder(@NonNull Material_Adapter.ViewHolder holder, int position) {
        final Material_Lists list = data.get(position);
        holder.txt_material.setText(list.getMaterial());
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}
