package com.tomas.lps_asi.lib.common;

import android.os.Bundle;
import android.util.Log;
import android.widget.EditText;
import android.widget.Toast;

import androidx.appcompat.app.AppCompatActivity;

import com.keyence.autoid.sdk.scan.DecodeResult;
import com.keyence.autoid.sdk.scan.ScanManager;
import com.tomas.lps_asi.R;

abstract public class Scanner extends AppCompatActivity implements ScanManager.DataListener {
    protected ScanManager mScanManager;

    protected EditText default_view = null;

    abstract public void processData(String data, DecodeResult.Result result, String codeType);

    // Create a read event.
    @Override
    public void onDataReceived(DecodeResult decodeResult) {
        try {

            Log.d(getString(R.string.tag), "onDataReceived() called");

            if (default_view != null) {
                default_view.requestFocus();
            }

            // Acquire the reading result.
            DecodeResult.Result result = decodeResult.getResult();
            // Acquire the read code type.
            String codeType = decodeResult.getCodeType();
            // Acquire the read data.
            String data = decodeResult.getData();

            Log.d(getString(R.string.tag),result.toString() + "[" + codeType + "]");

            processData(data, result, codeType);
            Log.d(getString(R.string.tag), "onDataReceived() ended");
        } catch (Exception e) {
            Toast.makeText(getApplicationContext(), e.getMessage(), Toast.LENGTH_LONG).show();
        }
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        try {
            Log.d(getString(R.string.tag), "onCreate() called");
            super.onCreate(savedInstanceState);
            setContentView(R.layout.activity_main);
            // Create a ScanManager class instance.
            mScanManager = ScanManager.createScanManager(this);
            // Create a listener to receive a read event.
            mScanManager.addDataListener(this);
            Log.d(getString(R.string.tag), "onCreate() ended");
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
    }
    @Override
    protected void onDestroy() {
        try {
            Log.d(getString(R.string.tag), "onDestroy() called");
            super.onDestroy();
            // Discard the ScanManager class instance.
            mScanManager.removeDataListener(this);
            // Discard the ScanManager class instance to release the resources.
            mScanManager.releaseScanManager();
            Log.d(getString(R.string.tag), "onDestroy() ended");
        } catch (Exception e) {
            Log.e(getString(R.string.tag), e.getMessage());
        }
    }
}
