﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    public class TransactionLog
    {
        public static string table_name = "TransactionLog";
        public static List<TransactionLog> TransactionLogs { get; set; }

        public enum LEVEL
        {
            INFO,
            DEBUG,
            WARN,
            ERROR
        }

        public enum STATUS
        {
            None,
            Success,
            Error
        }


        public int Id { get; set; }
        public string Screen_no { get; set; }
        public string Shipping_date { get; set; }
        public string Kjt_no { get; set; }
        public string Customer { get; set; }
        public string Cust_code { get; set; }
        public string Scan_result { get; set; }
        public string Scan_step { get; set; }
        public string Level { get; set; }
        public string Status { get; set; }
        public string Remark { get; set; }
        public string Resolve { get; set; }
        public string Create_date { get; set; }
        public string Create_time { get; set; }
        public string Create_by { get; set; }
        public int Export { get; set; }

        public static class Column
        {
            public static string id = "id";
            public static string screen_no = "screen_no";
            public static string shipping_date = "shipping_date";
            public static string kjt_no = "kjt_no";
            public static string customer = "customer";
            public static string cust_code = "cust_code";
            public static string scan_result = "scan_result";
            public static string scan_step = "scan_step";
            public static string level = "level";
            public static string status = "status";
            public static string remark = "remark";
            public static string resolve = "resolve";
            public static string create_date = "create_date";
            public static string create_time = "create_time";
            public static string create_by = "create_by";
            public static string export = "export";
        }

        public TransactionLog() 
        { 
            Create_date = DateTime.Now.ToString("yyMMdd");
            Create_time = DateTime.Now.ToString("HHmmss");
            Create_by = Form_Login._Form_LoginInstance.userName;
        }

        public static List<TransactionLog> LoadCollectionData()
        {
            return TransactionLogs;
        }

        public StringBuilder getInsertSql()
        {
            StringBuilder stringBuilder = new StringBuilder(
                "INSERT INTO " + table_name + "(" +
                Column.screen_no + "," +
                Column.shipping_date + "," +
                Column.kjt_no + "," +
                Column.customer + "," +
                Column.cust_code + "," +
                Column.scan_result + "," +
                Column.scan_step + "," +
                Column.level + "," +
                Column.status + "," +
                Column.remark + "," +
                Column.resolve + "," +
                Column.create_date + "," +
                Column.create_time + "," +
                Column.create_by +
                " ) VALUES(" +
                "\"" + this.Screen_no + "\"," +
                "\"" + this.Shipping_date + "\"," +
                "\"" + this.Kjt_no + "\"," +
                "\"" + this.Customer + "\"," +
                "\"" + this.Cust_code + "\"," +
                "\"" + this.Scan_result + "\"," +
                "\"" + this.Scan_step + "\"," +
                "\"" + this.Level + "\"," +
                "\"" + this.Status + "\"," +
                "\"" + this.Remark + "\"," +
                "\"" + this.Resolve + "\"," +
                "\"" + this.Create_date + "\"," +
                "\"" + this.Create_time + "\"," +
                "\"" + this.Create_by + "\"" +
                ");");

            return stringBuilder;
        }

        public static string getCsvHeaderColumnName(string delimiter)
        {
            return "#" + delimiter
            + "Screen_no" + delimiter
            + "\"Shipping date\"" + delimiter
            + "\"KJT P/N\"" + delimiter
            + "\"Customer P/N\"" + delimiter
            + "Customer" + delimiter
            + "\"Working date\"" + delimiter
            + "\"Working time\"" + delimiter
            + "\"Operator ID\"" + delimiter
            + "\"Customer P/N scan\"" + delimiter
            + "Process" + delimiter
            + "Level" + delimiter
            + "Status" + delimiter
            + "\"Defect information\"" + delimiter
            + "\"How to fix\"";

        }
    }
}
