package com.example.satobtprintertest;

import androidx.appcompat.app.AppCompatActivity;

import android.bluetooth.BluetoothDevice;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.Button;

import com.sato.printer.Printer;

import java.util.Set;

public class MainActivity extends AppCompatActivity implements View.OnClickListener {
    private final Handler mHandler = new Handler() {
        @Override
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case Printer.MESSAGE_BLUETOOTH_DEVICE_SET:
                    if(msg.obj == null) {
                        Log.i(getString(R.string.tag), "Bluetooth Device not found !");
                    } else {
                        Set<BluetoothDevice> devices = (Set<BluetoothDevice>)msg.obj;
                    }
                    break;

                case Printer.MESSAGE_STATE_CHANGE:
                    switch (msg.arg1) {
                        case Printer.STATE_CONNECTED:
                            Log.i(getString(R.string.tag), "Device is connected !");
                            break;
                        case Printer.STATE_CONNECTING:
                            Log.i(getString(R.string.tag), "Device is connecting !");
                            break;
                        case Printer.STATE_NONE:
                            Log.i(getString(R.string.tag), "Connection is failed or disconnected !");
                            break;
                    }
            }
        }
    };

    Printer mPrinter;


    Button btn_unpair_pair;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        btn_unpair_pair = (Button) findViewById(R.id.btn_pair_unpair);
        mPrinter = new Printer(this, mHandler, null);
    }

    @Override
    public void onClick(View view) {
        switch (view.getId()) {
            case R.id.btn_find_bt:
                //printWithEsc();
                //printText();

                mPrinter.findBluetoothPrinters();

                break;

            case R.id.btn_pair_unpair:

                String addr = "00:0A:3A:32:C8:79";
                int type = Printer.BLUETOOTH_CLASSIC;
                mPrinter.connect(addr, type);

                if (mPrinter.isConnected()) {
                    Log.d(getString(R.string.tag), "Device is connected");
                } else {
                    Log.d(getString(R.string.tag), "Device is disconnected");
                }

                break;

        }
    }
}