<html>
<head>
<title>AdventureWorks Product Reviews</title>
</head>
<body>
<h1 align='center'>AdventureWorks Product Reviews</h1>
<h5 align='center'>This application is a demonstration of the
                   object oriented API (PDO_SQLSRV driver) for the
                   Microsoft Drivers for PHP for SQL Server.</h5><br/>

<?
error_reporting(E_ALL ^ E_DEPRECATED);
error_reporting(E_ALL ^ E_NOTICE);

DEFINE('__NO_AUTHENTICATE_REQUIRED__', '');

require_once ('global_env.php');
require_once ('lib/DB.php');

$logger = Logger::getInstance($_SERVER['PHP_SELF']);

/* Connect using Windows Authentication. */
try
{
  $conn = (new DB())->getInstance();
}
catch(Exception $e)
{
  die( print_r( $e->getMessage() ) );
}


$tsql = "SELECT id, name
 FROM supplier";

try
{
  $result = sqlsrv_query( $conn, $tsql );
  if($result === false) {
    die(print_r(sqlsrv_errors(), true));
  }
  #Fetching Data by array
  while($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
      print_r($row);
  }

  $params = array();
  $options =  array( "Scrollable" => SQLSRV_CURSOR_KEYSET );
  $result = sqlsrv_query( $conn, $tsql , $params, $options );

  if (!sqlsrv_has_rows($result)) {
    DisplayNoDatasMsg();
    return;
  }

  $row_count = sqlsrv_num_rows( $result );
  BeginSuppliersTable($row_count);
  #Fetching Data by array
  while($row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC)) {
    PopulateSuppliersTable( $row );
  }
  EndTable();

}
catch(Exception $e)
{
  die( print_r( $e->getMessage() ) );
}


/*** Presentation and Utility Functions ***/

function BeginSuppliersTable($rowCount)
{
  /* Display the beginning of the search results table. */
  $headings = array("Supplier ID", "Supplier Name");
  echo "<table align='center' cellpadding='5'>";
  echo "<tr bgcolor='silver'>$rowCount Results</tr><tr>";
  foreach ( $headings as $heading )
  {
    echo "<td>$heading</td>";
  }
  echo "</tr>";
}

function DisplayNoDatasMsg()
{
  echo "<h4 align='center'>No datas found.</h4>";
}

function EndTable()
{
  echo "</table><br/>";
}

function PopulateSuppliersTable( $values )
{
  /* Populate Products table with search results. */
  $supplierID = $values['id'];
  echo "<tr>";
  foreach ( $values as $key => $value )
  {
    if ( 0 == strcasecmp( "Name", $key ) )
    {
      echo "<td><a href='?action=getreview&productid=$supplierID'>$value</a></td>";
    }
    elseif( !is_null( $value ) )
    {
      echo "<td>$value</td>";
    }
    else
    {
      echo "<td>N/A</td>";
    }
  }
}
?>
</body>
</html>
