<?
function getDateTime($fmt) {

	list($usec, $sec) = explode(" ",microtime());
	$string = ((float)$usec + (float)$sec);

	$string2 = explode(".", $string);

	return date($fmt, $string2[0]);
}

function getDateTimeWithMicrosec($fmt) {

	list($usec, $sec) = explode(" ",microtime());
	$string = ((float)$usec + (float)$sec);

	$string2 = explode(".", $string);

	return date($fmt, $string2[0]).".".$string2[1];

}

function parseDate($str, $format='Y-m-d H:i:s', $new_format, $hide_current_year=null) {
	if ($date = date_create_from_format( $format, $str )) {
		if (isset($hide_current_year) && date('Y')===date_format($date, 'Y')) // remove Y from new_format if in current year
			$new_format = str_replace($hide_current_year, "", $new_format);
		return date_format($date, $new_format);
	} else
		return false;
}

function convertTz($str, $old_tz, $to_tz, $format='Y-m-d H:i:s') {
	if ($str !== '') {
		$o_dtz = new DateTimeZone($old_tz);
		if ($date = date_create_from_format( $format, $str )) {
			$dt = new DateTime(date_format($date, 'Y-m-d H:i:s'), $o_dtz);
			$dt->setTimeZone(new DateTimeZone($to_tz));
		  return date_format($dt, 'Y-m-d H:i:s');
		} else
			return $str;
	} else
		return null;
}

/**
 * Returns the timestamp of the provided time string using a specific timezone as the reference
 *
 * @param string $str
 * @param string $timezone
 * @return int number of the seconds
 */
function strtotimetz($str, $timezone)
{
    return strtotime(
        $str, strtotime(
            // convert timezone to offset seconds
            (new DateTimeZone($timezone))->getOffset(new DateTime()) - (new DateTimeZone(date_default_timezone_get()))->getOffset(new DateTime()) . ' seconds'
        )
    );
}

//getDateTime2('YmdHis');

if ($argv) {
	$str = "2019-12-25 01:17:29";
	$str = $argv[1];
	$old_format = "Y-m-d H:i:s";
	$new_format = "M d, Y";

	print parseDate($str, $old_format, $new_format, ", Y") . "\n";
}
