﻿using System.Collections.Generic;

namespace SCAN.lib.db
{
    class PackageType : DbTable
    {
        private readonly string TABLE = "MTR_Package";
        private Dictionary<string, string> COLUMNS = new Dictionary<string, string>
        {
            { "item_id" , "" },
            { "package_id" , "" },
            { "qty" , "" },
            { "create_date" , "" },
            { "create_time" , "" },
            { "create_by" , "" },
        };

        public override string __TABLE { get { return TABLE; } }
        public override Dictionary<string, string> __COLUMNS { get { return COLUMNS; } set { COLUMNS = value; } }

        
        public PackageType() : base() { }
        public PackageType(string[] p) : base(p) { }

        private static Dictionary<string, int> _BoxSizeList = null;
        public static Dictionary<string, int> BoxSizeList { set { _BoxSizeList = value; } }
        public static Dictionary<string, int> getBoxSizeList()
        {
            if (_BoxSizeList == null)
            {

                _BoxSizeList = new Dictionary<string, int>();
                List<string[]> rows = (new PackageType()).get(new Dictionary<string, string> { { "item_id", "" }, { "qty", "" } }
                    , "package_id='box'",
                    null, null, null);

                foreach (string[] row in rows)
                {
                    _BoxSizeList.Add(row[0], int.Parse(row[1]));
                }
            }

            return _BoxSizeList;
        }
    }
}
