﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SCAN.lib.db
{
    class Item : DbTable
    {
        private readonly string TABLE = "MTR_Item";
        private Dictionary<string, string> COLUMNS = new Dictionary<string, string>
        {
            { "id" , "" },
            { "division" , "" },
            { "name" , "" },
            { "customer_id" , "" },
            { "customer_dvsn_id" , "" },
            { "unit_price" , "" },
            { "order_point" , "" },
            { "safety_stock" , "" },
            { "trgt_ivnt_turnover" , "" },
            { "location_fix" , "" },
            { "location_last" , "" },
            { "create_date" , "" },
            { "create_time" , "" },
            { "create_by" , "" },
        };

        public override string __TABLE { get { return TABLE; } }
        public override Dictionary<string, string> __COLUMNS { get { return COLUMNS; } set { COLUMNS = value; } }
           
        public Item() : base() { }
        public Item(string[] p) : base(p) { }

        private static Dictionary<string, Item> _ItemList = null;
        public static Dictionary<string, Item> ItemList { set { _ItemList = value; } }
        public static Dictionary<string, Item> getItemList()
        {
            if (_ItemList == null)
            {

                _ItemList = new Dictionary<string, Item>();
                List<string[]> rows = (new Item()).getAll();

                foreach (string[] row in rows)
                {
                    _ItemList.Add(row[0], new Item(row));
                }
            }

            return _ItemList;
        }
    }
}
