﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    class InboundSimpleItemDisplay
    {
        public string No { get; set; }
        public string Item_id { get; set; }
        public string Customer_id { get; set; }
        public string Pkg_qty { get; set; }
        public string Qty { get; set; }
        public string Status { get; set; }

        public InboundSimpleItemDisplay()
        {
            No = "";
            Item_id = ""; /* show*/
            Customer_id = ""; /* show*/
            Pkg_qty = ""; /* not show*/
            Qty = ""; /*  show*/
            Status = ""; /*  show*/
        }

        public static List<InboundSimpleItemDisplay> LoadCollectionData(List<lib.db.HT_IB> items)
        {
            List<InboundSimpleItemDisplay> displayItems = new List<InboundSimpleItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_IB item in items)
            {
                displayItems.Add(new InboundSimpleItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Customer_id = item.__COLUMNS["customer_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = item.__COLUMNS["pc_qty_act"],
                    Status = item.__COLUMNS["status"]
                });
            }
            return displayItems;
        }

    }
}
