﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    class InboundItemDisplay
    {
        public string No { get; set; }
        public string Item_id { get; set; }
        public string Customer_id { get; set; }
        public string Pkg_qty { get; set; }
        public int Qty { get; set; }
        public string Status { get; set; }

        public static List<InboundItemDisplay> LoadCollectionData(List<lib.db.HT_IB> items)
        {
            List<InboundItemDisplay> displayItems = new List<InboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_IB item in items)
            {
                displayItems.Add(new InboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Customer_id = item.__COLUMNS["customer_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = int.Parse(item.__COLUMNS["pc_qty_act"]),
                    Status = item.__COLUMNS["status"]
                });
            }
            return displayItems;
        }

        public static List<InboundItemDisplay> LoadCollectionData(List<lib.db.HT_IB_RC> items)
        {
            List<InboundItemDisplay> displayItems = new List<InboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_IB_RC item in items)
            {
                displayItems.Add(new InboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = int.Parse(item.__COLUMNS["pc_qty_act"]),
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }

        public static List<InboundItemDisplay> LoadCollectionData(List<lib.db.HT_IB_RP> items)
        {
            List<InboundItemDisplay> displayItems = new List<InboundItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_IB_RP item in items)
            {
                displayItems.Add(new InboundItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = int.Parse(item.__COLUMNS["pc_qty_act"]),
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }
    }
}
