﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCAN
{
    public partial class Form_Menu : Form
    {
        public static Form_Menu _Form_MenuInstance;		// フォーム
        public String AppPath = "";						// アプリケーション実行パス
        public Form_Menu()
        {
            InitializeComponent();
        }

        private void Form_Menu_Load(object sender, EventArgs e)
        {
            // 画面サイズ調整
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // フォームの最大化・最小化ボタン非表示
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
            _Form_MenuInstance = this;

            // 実行パスを取得
            String path = this.GetType().Assembly.GetModules()[0].FullyQualifiedName;
            Int32 en = path.LastIndexOf("\\");
            AppPath = path.Substring(0, en);
            lbUser.Text = Form_Login._Form_LoginInstance.userName;
            lbDevNo.Text = Form_Login._Form_LoginInstance.DevNO;

            //Bt.ScanLib.Control.btScanDisable();
        }

        private void btnInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundMenu();
            frm.Show();
            this.Hide();
        }

        private void btnOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundMenu();
            frm.Show();
            this.Hide();
        }

        private void btnStockManagement_Click(object sender, EventArgs e)
        {
            Form frm = new Form_StockManagementMenu();
            frm.Show();
            this.Hide();
        }

        private void btnDataSync_Click(object sender, EventArgs e)
        {
            Form frm = new Form_DS();
            frm.Show();
            this.Hide();
        }

        private void btnClose_Click(object sender, EventArgs e)
        {
            //this.Close();
            Application.Exit();
        }

        private void Form_Menu_Closed(object sender, EventArgs e)
        {
            //Login form should being close together to prevent not properly close problem
            Form_Login._Form_LoginInstance.Close();

            if (Form_InboundMenu._Form_Instance != null)
            {
                Form_InboundMenu._Form_Instance.Close();
                Form_InboundMenu._Form_Instance.Dispose();
            }
            if (Form_OutboundMenu._Form_Instance != null)
            {
                Form_OutboundMenu._Form_Instance.Close();
                Form_OutboundMenu._Form_Instance.Dispose();
            }
            if (Form_StockManagementMenu._Form_Instance != null)
            {
                Form_StockManagementMenu._Form_Instance.Close();
                Form_StockManagementMenu._Form_Instance.Dispose();
            }
            if (Form_DS._Form_Instance != null)
            {
                Form_DS._Form_Instance.Close();
                Form_DS._Form_Instance.Dispose();
            }
                
        }


    }
}