﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCAN
{
    public partial class Form_InboundMenu : Form
    {
        public static Form _Form_Instance;
        public Form_InboundMenu()
        {
            InitializeComponent();
        }

        private void Form_InboundMenu_Load(object sender, EventArgs e)
        {
            // 画面サイズ調整
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // フォームの最大化・最小化ボタン非表示
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
            _Form_Instance = this;

            lbUser.Text = Form_Login._Form_LoginInstance.userName;
            lbDevNo.Text = Form_Login._Form_LoginInstance.DevNO;
        }

        private void btnInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_Inbound();
            frm.Show();
            this.Hide();
        }

        private void btnRecheckInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundRecheck();
            frm.Show();
            this.Hide();
        }

        private void btnRepackInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundRepack();
            frm.Show();
            this.Hide();
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            Form_Menu._Form_MenuInstance.Show();
            this.Close();
        }

        private void btnSimInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundSimple("IB");
            frm.Show();
            this.Hide();
        }

        private void Form_InboundMenu_KeyDown(object sender, KeyEventArgs e)
        {           
            if (e.KeyCode.ToString() == "F1")
            {
                btnBack_Click(sender, e);
            }
        }

        private void btnSimRepackInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundSimple("IB_RP");
            frm.Show();
            this.Hide();
        }

        private void btnSimRecheckInbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_InboundSimple("IB_RC");
            frm.Show();
            this.Hide();
        }



    }
}