﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Globalization;
using System.Windows;

namespace SCAN
{
    public partial class Form_ChangeLocationDetail : Form
    {
        private lib.LogWriter logger = lib.LogWriter.getInstance();

        // Master table
        private static Dictionary<string, int> __PackageTypes = lib.db.PackageType.getBoxSizeList();
        private static Dictionary<string, lib.db.Item> __ItemList = lib.db.Item.getItemList();
        private static Dictionary<string, lib.db.Location> __LocationList = lib.db.Location.getLocationList();

        private lib.BtScanLib btScanLib;

        public Form_ChangeLocationDetail(List<StockManagementItemDisplay> items, int index)
        {
            InitializeComponent();

            lbUser.Text = Form_Login._Form_LoginInstance.userName;

            // set all display element
            StockManagementItemDisplay item = items.ElementAt(index);
            lblProductCode.Text = item.Item_id;
            lblProductName.Text = item.Item_name;
            lblLocation.Text = item.Location_id;
            lblProductDate.Text = DateTime.ParseExact(item.Product_date, "yyyyMMdd", null).ToString("dd/MM/yyyy");
            lblBoxQty.Text = item.Pkg_qty;
            lblPsQty.Text = item.Qty;

            // Enable BTScanLib
            btScanLib = lib.BtScanLib.getInstance();
            btScanLib.OnScan += new SCAN.lib.ScanEventHandler(btScanLib_OnScan);
            btScanLib.Debug = false;
            btScanLib.Enable();
        }

        private void Form_Load(object sender, EventArgs e)
        {
            // set screen resolution
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // disable maximize and minimize button
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
        }

        void btScanLib_OnScan(string result)
        {
            string location_id = result;

            if (!__LocationList.Keys.Contains(location_id))
            {
                Form frm = new Form_Msg("Input error.", Color.Red);
                frm.ShowDialog();
                return;
            }

            txtLocationNew.Text = location_id;
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            // disable BTScanLib
            btScanLib.OnScan -= btScanLib_OnScan;
            btScanLib.Disable();

            Form_ChangeLocation._Form_Instance.Show();
            this.Close();
        }

        private void btnConfirm_Click(object sender, EventArgs e)
        {
            lib.db.HT_CL table = new SCAN.lib.db.HT_CL();
            Dictionary<string, string> cols = new Dictionary<string, string>(table.__COLUMNS);
            cols["item_id"] = lblProductCode.Text;
            cols["item_dvsn_id"] = __ItemList[lblProductCode.Text].__COLUMNS["division"];
            cols["olocation_id"] = lblLocation.Text;
            cols["olocation_dvsn_id"] = __LocationList[lblLocation.Text].__COLUMNS["division"];
            cols["location_id"] = txtLocationNew.Text;
            cols["location_dvsn_id"] = __LocationList[txtLocationNew.Text].__COLUMNS["division"];
            cols["pkg_qty_act"] = lblBoxQty.Text;
            cols["pkg_type_act"] = "box";
            cols["pc_qty_act"] = lblPsQty.Text;
            cols["product_date"] = DateTime.ParseExact(lblProductDate.Text, "dd/MM/yyyy", null).ToString("yyyyMMdd");
            cols["status"] = "Complete";
            cols["create_date"] = DateTime.Now.ToString("yyyyMMdd");
            cols["create_time"] = DateTime.Now.ToString("HHmmdd");
            cols["create_by"] = Form_Login._Form_LoginInstance.userName;
            cols.Remove("id");
            cols.Remove("update_date");
            cols.Remove("update_time");
            cols.Remove("update_by");

            table.add(cols);

            Form frm = new Form_Msg("Data save completed.", Color.Black);
            frm.ShowDialog();

            // disable BTScanLib
            btScanLib.OnScan -= btScanLib_OnScan;
            btScanLib.Disable();

            Form_ChangeLocation._Form_Instance.Show();
            this.Close();
        }

    }
}