<?
function sanitize_uglifyjs($buffer) {

	require_once "UglifyJS.php";
	$uglifyjs = new UglifyJS();
	$buffer = $uglifyjs->input($buffer)
        			->clear()
        			->write();

	return $buffer;
}

function sanitize_minify($buffer) {
    require_once('min/lib/Minify/HTML.php');
    require_once('min/lib/Minify/CSS.php');
    require_once('min/lib/JSMin.php');
    $buffer = Minify_HTML::minify($buffer, array(
        'cssMinifier' => array('Minify_CSS', 'minify'),
        'jsMinifier' => array('JSMin', 'minify')
    ));
    return $buffer;
}

function sanitize_html($buffer) {

    $search = array(
        '/\>[^\S ]+/s'  // strip whitespaces after tags, except space
        ,'/[^\S ]+\</s'  // strip whitespaces before tags, except space
        ,'/(\s)+/s'       // shorten multiple whitespace sequences
		,'/[\n\r\t]/s'
		,'/(,\s|\s,)/'
		,'/(;\s|\s;)/'
		,'/({\s|\s{)/'
		,'/(}\s|\s})/'
		,'/(<\s|\s<)/'
		,'/(>\s|\s>)/'
		,'/(\(\s|\s\()/'
		,'/(\)\s|\s\))/'
		,'/(=\s|\s=)/'
    );

    $replace = array(
        '>'
        ,'<'
        ,'\\1'
		,''
		,','
		,';'
		,'{'
		,'}'
		,'<'
		,'>'
		,'('
		,')'
		,'='
    );

    $buffer = preg_replace($search, $replace, $buffer);

    return $buffer;
}
