<?
require_once('BasicConstant.php');
abstract class BasicEnum {
    private static $constCacheArray = NULL;

    public static function getConstants() {
        if (self::$constCacheArray == NULL) {
            self::$constCacheArray = [];
        }
        $calledClass = get_called_class();
        if (!array_key_exists($calledClass, self::$constCacheArray)) {
            $reflect = new ReflectionClass($calledClass);
            self::$constCacheArray[$calledClass] = $reflect->getConstants();
        }
        return self::$constCacheArray[$calledClass];
    }

    public static function isValidName($name, $caseSensitive = false) {
        $constants = self::getConstants();

        if ($caseSensitive) {
            return array_key_exists($name, $constants);
        }

        $keys = array_map('strtolower', array_keys($constants));
        return in_array(strtolower($name), $keys);
    }

    public static function isValidValue($value, $caseSensitive = true) {
        $values = array_values(self::getConstants());
        return in_array($value, $values, $caseSensitive);
    }

	public static function toString($value) {
		$constants = self::getConstants();
		foreach ($constants as $name => $val)
			if ($val === $value) return $name;
		return null;
	}

	public static function getConstant($value) {
		$constants = self::getConstants();
		foreach ($constants as $name => $val)
			if ($val === $value) return new BasicConstant($name,$val);
		return null;
	}

  public static function getArrayConstants($key = 'key', $val = 'val') {
    $constants = self::getConstants();
    $rows = array();
		foreach ($constants as $name => $val_) {
      array_push($rows, array($key => $name , $val => $val_));
    }

		return $rows;
  }
}
