<?
error_reporting(E_ALL ^ E_DEPRECATED);
error_reporting(E_ALL ^ E_NOTICE);

DEFINE('__NO_AUTHENTICATE_REQUIRED__', '');

require_once "global_env.php";
$logger = Logger::getInstance($_SERVER['PHP_SELF']);

// memcached integrated
require_once "lib/Memcached_pool.php";
$mcache = new Memcached();
$mcache->addServers($GLOBALS['memcached-sets'][DEFAULT_MEMCACHED_SET]);

include_once "lib/sanitize.php";
//ob_start("sanitize_html");

// this will replace by login session
$db_user = $mcache->get(session_id() . MCACHE_SUFFIX);
if (!$db_user) {
  // go to index.php
  header("Location: signin.php");
  exit();
}

// Verify page authority
const pageid = 'menu00';
if (!isset($db_user['authority'][pageid])) {
  // go to index.php
  header("Location: signout.php");
  exit();
}

include_once "lib/ext/DateTimeUtil.php";
include_once "lib/Users.php";
include_once "lib/DBFactory.php";
include_once 'lib/Menu.php';

$error = "";
$warning = "";
if (isset($db_user['authority']['menu03.05'])) {

  $stocks = (new DBFactory())->query(
    '
    SELECT count(*) AS c
    FROM Item it
    LEFT JOIN Stock s
    ON it.id = s.item_id
    AND it.division = s.item_dvsn_id
    WHERE ISNULL(it.order_point,0) >= ISNULL(s.qty, 0)'
  );

  if ($stocks[0]['c'] > 0) {
    //$warning = "There are items that are lower than the Order point. <a href='order_point.php' target='_if'>Click for more details &gt;&gt;</a>" ;
  }
}

/*
<li class="dropdown">
  <a href="javascript:void(0)" class="dropbtn" style="text-align: left;"><i style='font-size:20px; color: white;' class='fas'>&#xf468;</i><span class='menu-title'>Inbound</span></a>
    <div class="dropdown-content">
      <a href="inbound_inquiry_register.php" style="text-align: left;" target="_if">Inbound Register / Edit</a>
      <a href="inbound_inquiry_report.php" style="text-align: left;" target="_if">Inbound Inquiry / Report</a>
    </div>
  </li>
*/

$menu = Menu::DbRows2ArrayMap((new Menu())->get(Menu::$__COLUMNS, "lang_id='" . $db_user['user']['lang_id'] . "'"), "id", "name");

function getDropdownMenu($id, $icon, $header=true/* ohterwise return footer */, $isdropdown=true, $url=null) {
  global $logger, $db_user, $menu;
  if (isset($db_user['authority'][$id])) {
    if ($header) {
      return '<li class="dropdown">'
        . '<a href="'
        . ( isset($url) ? $url : 'javascript:void(0)' )
        . '" class="dropbtn ' . ( isset($icon) ? 'fas ' . $icon : '' ) . '">'
        . '<span class="menu-title">' . $menu[$id] . '</span>'
        . '</a>'
        . ( $isdropdown ? '<div class="dropdown-content">' : '' );
    } else {
      return ( $isdropdown ? '</div>' : '' )
        . '</li>';
    }
  } else {
    return '';
  }
}

function getSubDropdownMenu($id, $icon, $header=true/* ohterwise return footer */) {
  global $logger, $db_user, $menu;
  if (isset($db_user['authority'][$id])) {
    if ($header) {
      return '<div class="sub-dropdown">'
        . '<a href="javascript:void(0)" class="dropbtn ' . ( isset($icon) ? 'fas ' . $icon : '' ) . '">'
        . '<span class="sub-menu-title">' . $menu[$id] . '</span>'
        . '</a>'
        . '<div class="sub-dropdown-content">';
    } else {
      return '</div></div>';
    }
  } else {
    return '';
  }
}

function getLinkMenu($id, $url) {
  global $logger, $db_user, $menu;
  if (isset($db_user['authority'][$id])) {
    return '<a href="' . $url . '" target="_if">' . $menu[$id] . '</a>';
  } else {
    return '';
  }
}

/*
function print_menu($menu_) {
  global $logger;
  $res = '';
  foreach ($menu_ as $key => $m) {
    if ($m['main']) {
      $res .= getDropdownMenu($key, $m['icon'], $m['open_tag']);
    } else {
      $res .= getLinkMenu($key, $m['url']);
    }
  }
  return $res;
}

$menu_ = array(
  'menu01' => array
    (
      'main' => 1,
      'icon' => '&#xf468;',
      'open_tag' => true,
    ),
  'menu01.01' => array
    (
      'main' => 0,
      'url' => 'inbound_inquiry_register.php',
    ),
  'menu01.02' => array
    (
      'main' => 0,
      'url' => 'inbound_inquiry_report.php',
    ),
  'menu01' => array
    (
      'main' => 1,
      'icon' => '',
      'open_tag' => false,
    ),
);

//print_menu($menu_);

*/

?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Pegasus System</title>
  <link rel="stylesheet" href="vendor/jquery/css/jquery.dataTables.min.css">
  <link rel="stylesheet" href="vendor/jquery/css/jquery-ui.css" />
  <link rel="stylesheet" href="vendor/fontawesome-free/css/fontawesome.min.css">
  <link rel="stylesheet" href="vendor/fontawesome-free/css/regular.css">
  <link rel="stylesheet" href="vendor/fontawesome-free/css/v4-shims.css">
  <link rel="stylesheet" href="vendor/fontawesome-free/css/solid.css">
  <link rel="stylesheet" href="vendor/jquery/css/buttons.dataTables.min.css">
  <link href="css/main.css" rel="stylesheet" />
  <link href="css/custom-pane.css" rel="stylesheet">

  <script type="text/javascript" src="vendor/jquery/js/jquery.min.js"></script>
  <script type="text/javascript" src="vendor/jquery/js/jquery-ui.js"></script>
  <script type="text/javascript" src="js/dd-icon.js"></script>

  <style>
  @import url('https://fonts.googleapis.com/css?family=Josefin+Sans&display=swap');
  *{
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    list-style: none;
    text-decoration: none;
    font-family: 'Josefin Sans', sans-serif;
  }
  .dd-icon {
    padding: 10px;
  }
  div.logo {
    background: url('img/Logo-pegasus-small.png');
    background-position: left;
    background-repeat: no-repeat;
    background-size: cover;
    width: 225px;
    height: 63px;
  }
  </style>

  <script>

    function menu_expand() {
      $('.menu-title').show();
      $('#menu-expand').hide();
      $('#menu-collapse').show();
      $('.sidebar').css('width', '225px');
      $('section.content').css('margin-left', '225px');
      $('.dropdown-content').css('margin-left', '75px');
      $('div.logo').css('width', '225px');
      $('div#div-custom-pane').css('margin-left', '225px');
    }

    function menu_collapse() {
      $('.menu-title').hide();
      $('#menu-expand').show();
      $('#menu-collapse').hide();
      $('.sidebar').css('width', '62px');
      $('section.content').css('margin-left', '62px');
      $('.dropdown-content').css('margin-left', '0px');
      $('div.logo').css('width', '62px');
      $('div#div-custom-pane').css('margin-left', '62px');
    }

  	function set_if_height() {
  		var hh = $( window ).height();
  		$('#_if').css('height', hh + 'px');
  	}

    $(document).ready(function(e){

      var warning = "<?=$warning?>";
      if (warning!='') {
        $('#warn-pane').show().html(warning);
      }

      set_if_height();

      $( window ).resize(function() {
        set_if_height();
      });

      $('.dropdown').on('hover', function() {
        $(this).find('.dropdown-content').each(function() {
          var h_screen = document.body.getBoundingClientRect().height;
          var positions = $(this)[0].getBoundingClientRect();
          var offset_top = $(this).parent().css('height').replace('px','');

          if (positions.height + positions.top > h_screen) {
            $(this).css('top', (h_screen - positions.height - offset_top) + 'px');
          }
        });
      });

      $('.sub-dropdown').on('hover', function() {
        $(this).find('.sub-dropdown-content').each(function() {
          var positions = $(this)[0].getBoundingClientRect();
          var offset_top = $(this).parent().css('height').replace('px','')/2;
          $(this).css('margin-top', '-' + (positions.height + offset_top) + 'px');
        });
      });
    });
  </script>
</head>
<body>
  <div class='container'>
    <div class='row'>
      <div class='col' id='div-custom-pane'>
        <div class='custom-pane custom-pane-info custom-pane-close-btn' id='info-pane' style='display:none'></div>
        <div class='custom-pane custom-pane-warn custom-pane-close-btn' id='warn-pane' style='display:none'></div>
      </div>
    </div>
  </div>

  <div class="wrapper">
    <div class="sidebar">
      <div class="logo"></div>
      <ul>

        <!--
        <?=getDropdownMenu('menu00', 'fa-calendar', true, false, 'schedule.php')?>
        <?=getDropdownMenu('menu00', null, false, false)?>-->

        <?=getDropdownMenu('menu01', 'fa-boxes')?>
        <!--<?=getLinkMenu('menu01.01', 'inbound_inquiry_register.php')?>-->
        <?=getLinkMenu('menu01.02', 'inbound_inquiry_report.php')?>
        <?=getDropdownMenu('menu01', null, false)?>

        <?=getDropdownMenu('menu02', 'fa-dolly-flatbed')?>
        <!--<?=getLinkMenu('menu02.01', 'outbound_inquiry_register.php')?>-->
        <?=getLinkMenu('menu02.02', 'outbound_inquiry_report.php')?>
        <?=getDropdownMenu('menu02', null, false)?>

        <?=getDropdownMenu('menu03', 'fa-warehouse')?>
        <?=getLinkMenu('menu03.01', 'stock_inquiry_report.php')?>
        <?=getLinkMenu('menu03.08', 'stock_inquiry_summary_report.php')?>
        <?=getLinkMenu('menu03.02', 'stock_maintenance.php')?>
        <?//=getLinkMenu('menu03.03', 'change_location.php')?>
        <?=getLinkMenu('menu03.04', 'stocktaking.php')?>
        <?//=getLinkMenu('menu03.05', 'order_point.php')  // ปิดก่อน ใช้ไม่ได้ ?>
        <?=getLinkMenu('menu03.06', 'stock_maintenance_report.php')?>
        <?=getSubDropdownMenu('menu03.07', null)?>
          <?=getLinkMenu('menu03.07.01', 'stock_quantity_list_report.php')?>
          <?=getLinkMenu('menu03.07.02', 'outbound_list_report.php')?>
          <?//=getLinkMenu('menu03.07.03', 'inventory_turnover_worst_report.php')?>
          <?//=getLinkMenu('menu03.07.04', 'highest_inventory_value_worst_report.php')?>
          <?//=getLinkMenu('menu03.07.05', 'slow_move_report.php')?>
        <?=getSubDropdownMenu('menu03.07', null, false)?>
        <?=getDropdownMenu('menu03', null, false)?>

        <?=getDropdownMenu('menu08', 'fa-flag')?>
        <?=getLinkMenu('menu08.01', 'stock_card_record.php')?>
        <?=getLinkMenu('menu08.02', 'stock_card_board.php')?>
        <?=getDropdownMenu('menu08', null, false)?>

        <?=getDropdownMenu('menu04', 'fa-database')?>
        <?=getLinkMenu('menu04.01', 'item_master.php')?>
        <?//=getLinkMenu('menu04.02', 'location_master.php')?>
        <?=getLinkMenu('menu04.03', 'user_master.php')?>
        <?=getLinkMenu('menu04.04', 'user_credential_master.php')?>
        <?=getLinkMenu('menu04.05', 'authority_master.php')?>
        <?=getLinkMenu('menu04.06', 'supplier_master.php')?>
        <?=getLinkMenu('menu04.07', 'customer_master.php')?>
        <?=getLinkMenu('menu04.08', 'department_master.php')?>
        <?=getLinkMenu('menu04.09', 'name_master.php')?>
        <?=getLinkMenu('menu04.10', 'package_type_master.php')?>
        <?=getLinkMenu('menu04.11', 'calendar_master.php')?>
        <?=getLinkMenu('menu04.12', 'forecast_master.php')?>
        <?=getDropdownMenu('menu04', null, false)?>

<!--
        <?=getDropdownMenu('menu05', 'fa-cog')?>
        <?=getDropdownMenu('menu05', null, false)?>
      -->

        <?=getDropdownMenu('menu06', 'fa-address-card', true, false)?>
        <span class='menu-title' style='padding-top: 15px;display:block;'><?=$db_user['user']['name']?></span>
        <?=getDropdownMenu('menu06', null, false, false)?>

        <?=getDropdownMenu('menu07', 'fa-power-off', true, false, 'signout.php')?>
        <?=getDropdownMenu('menu07', null, false, false)?>

<!--
        <li class="dropdown">
          <a href="javascript:void(0)" class="dropbtn" >
            <i class='fas' title='User Name : <?=$db_user['user']['name']?>'>&#xf2bb;</i>
            <span class='menu-title'>User Name :<br><br></span>
          </a>
          <span class='menu-title'><?=$db_user['user']['name']?></span>
        </li>
        <li class="dropdown">
          <a href="signout.php" class="dropbtn">
            <i class='fas' title='Logout'>&#xf011;</i>
            <span class='menu-title'>Logout</span>
          </a>
        </li>
      -->
      </ul>
      <i id='menu-expand' style="display:none; padding:20px" class="dd-icon fa fa-indent" for="menu_expand" title="Menu expand"></i>
      <i id='menu-collapse' class="dd-icon float-right fa fa-outdent" for="menu_collapse" title="Menu collapse"></i>

    </div>
    <section class="content" style="background-color:transparent;display:inline-flex;width:100%;padding:0">
      <iframe id='_if' name="_if" src="inbound_inquiry_report.php" width="100%" frameborder="0" scrolling="yes"> </iframe>
    </section>
  </div>

  <script src="js/custom-pane.js"></script>
</body>
</html>
