﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SCAN.lib.db
{
    class Location : DbTable
    {
        private readonly string TABLE = "MTR_Location";
        private Dictionary<string, string> COLUMNS = new Dictionary<string, string>
        {
            { "id" , "" },
            { "division" , "" },
            { "name" , "" },
            { "create_date" , "" },
            { "create_time" , "" },
            { "create_by" , "" },
        };

        public override string __TABLE { get { return TABLE; } }
        public override Dictionary<string, string> __COLUMNS { get { return COLUMNS; } set { COLUMNS = value; } }
        
        public Location() : base() { }
        public Location(string[] p) : base(p) { }

        private static Dictionary<string, Location> _LocationList = null;
        public static Dictionary<string, Location> LocationList { set { _LocationList = value; } }
        public static Dictionary<string, Location> getLocationList()
        {
            if (_LocationList == null)
            {

                _LocationList = new Dictionary<string, Location>();
                List<string[]> rows = (new Location()).getAll();

                foreach (string[] row in rows)
                {
                    _LocationList.Add(row[0], new Location(row));
                }
            }

            return _LocationList;
        }
    }
}
