﻿using System;
using System.Collections.Generic;
using System.Text;

namespace SCAN.lib.db
{
    class Customer : DbTable
    {
        private readonly string TABLE = "MTR_Customer";
        private Dictionary<string, string> COLUMNS = new Dictionary<string, string>()
        {
            { "id" , "" },
            { "division" , "" },
            { "name" , "" },
            { "create_date" , "" },
            { "create_time" , "" },
            { "create_by" , "" },
        };

        public override string __TABLE { get { return TABLE; } }
        public override Dictionary<string, string> __COLUMNS { get { return COLUMNS; } set { COLUMNS = value; } }
           
        public Customer() : base() { }
        public Customer(string[] p) : base(p) { }

        private static Dictionary<string, Customer> _CustomerList = null;
        public static Dictionary<string, Customer> CustomerList { set { _CustomerList = value; } }
        public static Dictionary<string, Customer> getCustomerList()
        {
            if (_CustomerList == null)
            {

                _CustomerList = new Dictionary<string, Customer>();
                List<string[]> rows = (new Customer()).getAll();

                foreach (string[] row in rows)
                {
                    _CustomerList.Add(row[0], new Customer(row));
                }
            }

            return _CustomerList;
        }
    }
}
