SELECT s.filename
	, MAX(
		CASE s.update_date
			WHEN ""
				THEN CAST(s.create_date as decimal)
			ELSE CAST(s.update_date as decimal)
		END
	) AS maxdate
FROM Schedule s
INNER JOIN
(
	SELECT filename 
		, MIN(status) AS status
		, count(*) AS c
	FROM
	(
		SELECT filename, status, count(*)
		FROM
		(
			SELECT filename, 
				CASE status
				WHEN 'Recheck'
					THEN 'OK'
				WHEN ''
					THEN 'NG'
				ELSE status
			END status
			FROM Schedule
		) a
		GROUP BY filename, status
	)
	GROUP BY filename
	HAVING status = 'NG'
) a
ON a.filename = s.filename
GROUP BY s.filename
