﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    class OutboundSimpleItemDisplay
    {
        public string No { get; set; }
        public string Item_id { get; set; }
        public string Product_date { get; set; }
        public string Customer_id { get; set; }
        public string Location_id { get; set; }
        public string Pkg_qty_plan { get; set; }
        public string Qty_plan { get; set; }
        public string Pkg_qty_act { get; set; }
        public string Qty_act { get; set; }
        public string Status { get; set; }

        public OutboundSimpleItemDisplay()
        {
            No = "";
            Item_id = ""; /* show*/
            Product_date = ""; /* not show*/
            Customer_id = ""; /* show*/
            Location_id = ""; /* not show*/
            Pkg_qty_plan = ""; /* not show*/
            Pkg_qty_act = ""; /* not show*/
            Qty_plan = ""; /*  show*/
            Qty_act = ""; /*  show*/
            Status = ""; /*  show*/
        }

        public static List<OutboundSimpleItemDisplay> LoadCollectionData(List<lib.db.HT_OB> items)
        {
            List<OutboundSimpleItemDisplay> displayItems = new List<OutboundSimpleItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB item in items)
            {
                displayItems.Add(new OutboundSimpleItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Product_date = item.__COLUMNS["product_date"],
                    Customer_id = item.__COLUMNS["customer_id"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty_plan = item.__COLUMNS["pkg_qty_plan"],
                    Qty_plan = item.__COLUMNS["pc_qty_plan"],
                    Pkg_qty_act = item.__COLUMNS["pkg_qty_act"],
                    Qty_act = item.__COLUMNS["pc_qty_act"],
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }
    }
}
