﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    public class OutboundItemScheduleDisplay
    {
        public string No { get; set; }
        public string Item_id { get; set; }
        public string Pkg_qty { get; set; }
        public int Qty { get; set; }
        public string Status { get; set; }

        public static List<OutboundItemScheduleDisplay> LoadCollectionData(List<lib.db.HT_OB> items)
        {
            List<OutboundItemScheduleDisplay> displayItems = new List<OutboundItemScheduleDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB item in items)
            {
                displayItems.Add(new OutboundItemScheduleDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = int.Parse(item.__COLUMNS["pc_qty_act"]),
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }
    }
}
