﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Bt.ScanLib;
using Bt;
using CsvReadWrite;
using System.Threading;
using Bt.FileLib;
using Bt.SysLib;
using System.IO;
using System.Runtime.InteropServices;

namespace SCAN
{
    public partial class NGSCAN : Form
    {
        string K_OK = "OK";
        string Q_OK = "OK";
        string rPDS = "";
        string rCKAN = "";
        string rCQTY = "";
        string rSKAN = "";
        string rSQTY = "";
        string okUser = "";
        public String dbFilePath = "\\FlashDisk\\BT_FILES\\drv1\\HT_SKT.DB";
        public int dbIdx = 0;
        public int recordCount = 0;
        public NGSCAN(bool KOK,bool QOK,string PDS,string CKAN,string CQTY,string SKAN,string SQTY)
        {
            if(!KOK)
            K_OK = "NG";

            if(!QOK)
            Q_OK = "NG";


            rPDS = PDS;
            rCKAN = CKAN;
            rCQTY = CQTY;
            rSKAN = SKAN;
            rSQTY = SQTY;



            InitializeComponent();

        }

        private void NGSCAN_Load(object sender, EventArgs e)
        {
            // 画面サイズ調整
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // フォームの最大化・最小化ボタン非表示
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
            this.ControlBox = !this.ControlBox;
            comboBox1.Items.Clear();

            for (int i = 0; i < Form_Login._Form_LoginInstance.mngList.Count; i++)
            {
                comboBox1.Items.Add(Form_Login._Form_LoginInstance.mngList[i][0].Replace("\r",""));
            }


            //scan setting
            //Form_Login._Form_LoginInstance.ScanMode = 0;
            ResKAN.Text = K_OK;
            ResQTY.Text = Q_OK;

        }

        private void OKbtn_Click(object sender, EventArgs e)
        {
            try
            {
                string tgtPass = Form_Login._Form_LoginInstance.mngList[comboBox1.SelectedIndex][1].Replace("\r", "");
                okUser = Form_Login._Form_LoginInstance.mngList[comboBox1.SelectedIndex][0].Replace("\r", "");

                if (tgtPass == textBox1.Text)
                {
                    //Form frmD = new Form_Menu();
                    //frmD.Show();
                    insertRecordKB();
                    this.Close();
                }
                else
                {
                    PassErr err = new PassErr();
                    err.Show();
                    textBox1.Text = "";
                }
            }
            catch (Exception ee)
            {
            }
        }

        /////////////////////////////////////////////////////////////
        /// Open
        /////////////////////////////////////////////////////////////
        private int openDB()
        {
            if (dbIdx > 0) return -1;
            dbIdx = Bt.FileLib.SQLite.btSQLiteOpen(new StringBuilder(dbFilePath));
            if (dbIdx > 0)
            {
                return 0;
            }
            else
            {
                
                return -1;
            }
        }

        /////////////////////////////////////////////////////////////
        /// Close
        /////////////////////////////////////////////////////////////
        private int closeDB()
        {
            if (dbIdx <= 0) return -1;
            int ret = Bt.FileLib.SQLite.btSQLiteClose(dbIdx);
            dbIdx = 0;
            if (ret == 0)
            {
                
                return 0;
            }
            else
            {
                
                return -1;
            }
        }

       

        /////////////////////////////////////////////////////////////
        /// Insert
        /////////////////////////////////////////////////////////////
        private void insertRecordKB()
        {
            openDB();

            string tableName = "Record_KB";

            if (dbIdx <= 0) return;
            StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + " VALUES('" + DateTime.Now.ToString("yyMMdd") + "', '" +
                                                                                                DateTime.Now.ToString("HHmmss") + "', '" +
                                                                                                Form_Login._Form_LoginInstance.userName + "', '" +
                                                                                                Form_Login._Form_LoginInstance.DevNO + "', '" +
                                                                                                rPDS + "', '" +
                                                                                                rSKAN + "', '" +
                                                                                                rSQTY + "', '" +
                                                                                                rCKAN + "', '" +
                                                                                                rCQTY + "', '" +
                                                                                                ResKAN.Text + "', '" +
                                                                                                ResQTY.Text + "', '" +
                                                                                                
                                                                                                this.okUser + "');");
            int ret = Bt.FileLib.SQLite.btSQLiteExecute(dbIdx, sql);
            if (ret == 0)
            {
                
            }
            else
            {
               
            }

            closeDB();
        }



        /////////////////////////////////////////////////////////////
        /// CSV output
        /////////////////////////////////////////////////////////////
        private int outputCSVFile(string dbFileName, string outputPath)
        {
            int retcode = -1;
            int cIdx = 0;
            int cIdx2 = 0;
            int dbIdx = Bt.FileLib.SQLite.btSQLiteOpen(new StringBuilder(dbFilePath));
            if (dbIdx <= 0) return retcode;
            IntPtr data;
            data = Marshal.AllocCoTaskMem(Marshal.SizeOf(typeof(Char)) * (8192 + 1));
            string sep = ",";

            StringBuilder sql = new StringBuilder("SELECT name FROM sqlite_master WHERE type = 'table';");
            cIdx = Bt.FileLib.SQLite.btSQLiteCmdCreate(dbIdx);
            if (cIdx <= 0) goto FUNCEND;
            int ret = Bt.FileLib.SQLite.btSQLiteCmdSetCommandText(cIdx, sql);
            if (ret < 0) goto FUNCEND;
            ret = Bt.FileLib.SQLite.btSQLiteCmdExecuteReader(cIdx);
            if (ret < 0) goto FUNCEND;

            int read_ret = 0;
            do
            {
                read_ret = Bt.FileLib.SQLite.btSQLiteCmdRead(cIdx);
                if (read_ret < 0) goto FUNCEND;
                else if (read_ret == 1)
                {
                    ret = Bt.FileLib.SQLite.btSQLiteCmdGetValue(cIdx, 0, data, 8192);
                    if (ret != 0) goto FUNCEND;
                    string tableName = Marshal.PtrToStringUni(data);

                    sql = new StringBuilder("SELECT * FROM " + tableName + ";");
                    cIdx2 = Bt.FileLib.SQLite.btSQLiteCmdCreate(dbIdx);
                    if (cIdx2 <= 0) goto FUNCEND;
                    ret = Bt.FileLib.SQLite.btSQLiteCmdSetCommandText(cIdx2, sql);
                    if (ret < 0) goto FUNCEND;
                    ret = Bt.FileLib.SQLite.btSQLiteCmdExecuteReader(cIdx2);
                    if (ret < 0) goto FUNCEND;

                    System.IO.StreamWriter writer = null;
                    try
                    {
                        writer = new System.IO.StreamWriter(outputPath + tableName + ".csv", false, System.Text.Encoding.GetEncoding("Shift_JIS"));
                        do
                        {
                            ret = Bt.FileLib.SQLite.btSQLiteCmdRead(cIdx2);
                            if (ret < 0) goto FUNCEND;
                            else if (ret == 1)
                            {
                                StringBuilder line = new StringBuilder("");
                                int cnt = Bt.FileLib.SQLite.btSQLiteCmdGetValueCount(cIdx2);
                                for (int i = 0; i < cnt; i++)
                                {
                                    if (line.ToString() != "") line.Append(sep);
                                    Bt.FileLib.SQLite.btSQLiteCmdGetValue(cIdx2, i, data, 8192);
                                    line.Append("\"" + Marshal.PtrToStringUni(data) + "\"");
                                }
                                writer.WriteLine(line);
                            }
                        } while (ret == 1);
                    }
                    finally
                    {
                        if (writer != null) writer.Close();
                    }
                }
            } while (read_ret == 1);

            retcode = 0;

        FUNCEND:
            if (cIdx > 0) Bt.FileLib.SQLite.btSQLiteCmdDelete(dbIdx);
            if (cIdx2 > 0) Bt.FileLib.SQLite.btSQLiteCmdDelete(cIdx2);
            Marshal.FreeCoTaskMem(data);
            if (dbIdx > 0) Bt.FileLib.SQLite.btSQLiteClose(dbIdx);
            return retcode;
        }

        private void ResQTY_ParentChanged(object sender, EventArgs e)
        {

        }

        private void label3_ParentChanged(object sender, EventArgs e)
        {

        }


    }
}