﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Globalization;
using System.Windows;

namespace SCAN
{
    public partial class Form_StockCheckDetail : Form
    {
        private lib.LogWriter logger = lib.LogWriter.getInstance();

        // Master table
        private Dictionary<string, int> __PackageTypes = lib.db.PackageType.getBoxSizeList();
        private Dictionary<string, lib.db.Item> __ItemList = lib.db.Item.getItemList();

        private lib.BtScanLib btScanLib;

        public Form_StockCheckDetail(List<StockManagementItemDisplay> items, int index)
        {
            InitializeComponent();

            lbUser.Text = Form_Login._Form_LoginInstance.userName;

            // set all display element
            StockManagementItemDisplay item = items.ElementAt(index);
            lblProductCode.Text = item.Item_id;
            lblProductName.Text = item.Item_name;
            lblLocation.Text = item.Location_id;
            lblProductDate.Text = DateTime.ParseExact(item.Product_date, "yyyyMMdd", null).ToString("dd/MM/yyyy");
            lblBoxQty.Text = item.Pkg_qty;
            lblPsQty.Text = item.Qty;
        }

        private void Form_Load(object sender, EventArgs e)
        {
            // set screen resolution
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // disable maximize and minimize button
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            Form_StockCheck._Form_Instance.Show();
            this.Close();
        }

    }
}