﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCAN
{
    public partial class Form_OutboundMenu : Form
    {
        public static Form_OutboundMenu _Form_Instance;		// フォーム
        public String AppPath = "";						// アプリケーション実行パス
        public Form_OutboundMenu()
        {
            InitializeComponent();
        }

        private void Form_OutboundMenu_Load(object sender, EventArgs e)
        {
            // 画面サイズ調整
            if (System.Windows.Forms.Screen.PrimaryScreen.Bounds.Width == 240)
            {
                resolution.ScreenSize.VGAtoQVGA(this);
            }

            // フォームの最大化・最小化ボタン非表示
            this.MaximizeBox = !this.MaximizeBox;
            this.MinimizeBox = !this.MinimizeBox;
            _Form_Instance = this;

            lbUser.Text = Form_Login._Form_LoginInstance.userName;
            lbDevNo.Text = Form_Login._Form_LoginInstance.DevNO;
        }
        private void btnOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundSchedule();
            frm.Show();
            this.Hide();
        }

        private void btnRecheckOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundRecheck();
            frm.Show();
            this.Hide();
        }

        private void btnRepackOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundRepack();
            frm.Show();
            this.Hide();
        }

        private void btnBack_Click(object sender, EventArgs e)
        {
            Form_Menu._Form_MenuInstance.Show();
            this.Close();
        }

        private void btnSimOutbound_Click(object sender, EventArgs e)
        {

            Form frm = new Form_OutboundSimple("OB");
            frm.Show();
            this.Hide();
        }

        private void Form_OutboundMenu_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode.ToString() == "F1")
            {
                btnBack_Click(sender, e);
            }
        }

        private void btnSimRepackOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundSimple("OB_RP");
            frm.Show();
            this.Hide();
        }

        private void btnSimRecheckOutbound_Click(object sender, EventArgs e)
        {
            Form frm = new Form_OutboundSimple("OB_RC");
            frm.Show();
            this.Hide();
        }

    }
}