﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SCAN
{
    public partial class Form_EditQtyOutboundSimple : Form
    {
        private List<lib.db.HT_OB> outboundItems;
        private int currentItem; // zero base item index

        private Dictionary<string, int> __PackageTypes = lib.db.PackageType.getBoxSizeList();

        public Form_EditQtyOutboundSimple(List<lib.db.HT_OB> outboundItems, int selectedIndex)
        {
            InitializeComponent();
            this.outboundItems = outboundItems;
            this.currentItem = selectedIndex;
            new_box_qty_outbound.Text = outboundItems.ElementAt(selectedIndex).__COLUMNS["pkg_qty_act"];
            lblItem.Text = outboundItems.ElementAt(selectedIndex).__COLUMNS["item_id"];
        }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            string new_box_qty = new_box_qty_outbound.Text;
            if (new_box_qty.Length <= 0 || new_box_qty == "0")
            {
                Form FrmMsg = new Form_Msg("Please Input Qty", Color.Blue);
                FrmMsg.ShowDialog();
                return;
            }

            string item_id = lblItem.Text;
            int packing_size = __PackageTypes[item_id];
            int new_pc_qty_act = int.Parse(new_box_qty) * packing_size;

            lib.db.HT_OB ib = outboundItems.ElementAt(currentItem);

            ib.__COLUMNS["pkg_qty_act"] = new_box_qty;
            ib.__COLUMNS["pc_qty_act"] = new_pc_qty_act.ToString();
            ib.__COLUMNS["status"] = "";


            string customer_id = outboundItems.ElementAt(currentItem).__COLUMNS["customer_id"];
            string product_date = outboundItems.ElementAt(currentItem).__COLUMNS["product_date"];
            string create_date = outboundItems.ElementAt(currentItem).__COLUMNS["create_date"];

            //MessageBox.Show(packing_size.ToString());
            string sql = @"UPDATE HT_OB 
                    SET status=''
                        , pkg_qty_act = '{0}'
                        , pc_qty_act = '{1}'
                        , update_date='{2}'
                        , update_time='{3}'
                        , update_by='{4}' 
                    WHERE item_id='{5}' AND customer_id='{6}' AND product_date='{7}' AND create_date='{8}' AND status='Confirm' AND sync=0 ";
            List<string[]> rows = (new lib.DbTable()).executeQuery(String.Format(sql
                , new_box_qty
                , new_pc_qty_act.ToString()
                , DateTime.Now.ToString("yyMMdd")
                , DateTime.Now.ToString("HHmmss")
                , Form_Login._Form_LoginInstance.userName
                , item_id
                , customer_id
                , product_date
                , create_date
                ));

            // update item back to buffer list
            outboundItems[currentItem] = ib;
            Form_OutboundSimple.outboundItems = outboundItems;
            this.Close();
        }


    }
}