﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Text;

namespace SCAN
{
    class OutboundRecheckItemDisplay
    {
        public string No { get; set; }
        public string Item_id { get; set; }
        public string Location_id { get; set; }
        public string Pkg_qty { get; set; }
        public string Qty { get; set; }
        public string Status { get; set; }

        public OutboundRecheckItemDisplay()
        {
            No = "";
            Item_id = "";
            Location_id = "";
            Pkg_qty = "";
            Qty = "";
            Status = "";
        }

        public static List<OutboundRecheckItemDisplay> LoadCollectionData(List<lib.db.HT_OB_RC> items)
        {
            List<OutboundRecheckItemDisplay> displayItems = new List<OutboundRecheckItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB_RC item in items)
            {
                displayItems.Add(new OutboundRecheckItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = item.__COLUMNS["pc_qty_act"],
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }

        public static List<OutboundRecheckItemDisplay> LoadCollectionData(List<lib.db.HT_OB_RP> items)
        {
            List<OutboundRecheckItemDisplay> displayItems = new List<OutboundRecheckItemDisplay>();
            int i = 0;
            foreach (lib.db.HT_OB_RP item in items)
            {
                displayItems.Add(new OutboundRecheckItemDisplay()
                {
                    No = (++i).ToString(),
                    Item_id = item.__COLUMNS["item_id"],
                    Location_id = item.__COLUMNS["location_id"],
                    Pkg_qty = item.__COLUMNS["pkg_qty_act"],
                    Qty = item.__COLUMNS["pc_qty_act"],
                    Status = item.__COLUMNS["status"]
                });
            }

            return displayItems;
        }
    }
}
